/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginCompatibility {
    private static final Logger LOGGER = Logger.getLogger("AnimalHunger.Compatibility");
    private final JavaPlugin plugin;
    private final Random random = new Random();
    private boolean isMythicMobsEnabled = false;
    private MythicBukkit mythicBukkit = null;
    private boolean isMMOItemsEnabled = false;
    private MMOItems mmoItems = null;

    public PluginCompatibility(JavaPlugin plugin) {
        this.plugin = plugin;
        this.initializeCompatibility();
    }

    private void initializeCompatibility() {
        this.initializeMythicMobs();
        this.initializeMMOItems();
        this.createExampleConfig();
    }

    private void initializeMythicMobs() {
        Plugin mythicPlugin = Bukkit.getPluginManager().getPlugin("MythicMobs");
        if (mythicPlugin != null && mythicPlugin.isEnabled()) {
            try {
                this.mythicBukkit = MythicBukkit.inst();
                if (this.mythicBukkit != null) {
                    this.isMythicMobsEnabled = true;
                }
            }
            catch (Exception e) {
                LOGGER.warning("Error connecting to MythicMobs: " + e.getMessage());
                this.isMythicMobsEnabled = false;
            }
        } else {
            LOGGER.info("MythicMobs not found");
        }
    }

    private void initializeMMOItems() {
        Plugin mmoPlugin = Bukkit.getPluginManager().getPlugin("MMOItems");
        if (mmoPlugin != null && mmoPlugin.isEnabled()) {
            try {
                Class.forName("net.Indyuce.mmoitems.MMOItems");
                Class.forName("net.Indyuce.mmoitems.api.Type");
                Class.forName("net.Indyuce.mmoitems.api.item.mmoitem.MMOItem");
                this.mmoItems = MMOItems.plugin;
                if (this.mmoItems != null && this.mmoItems.getItems() != null) {
                    this.isMMOItemsEnabled = true;
                    if (this.plugin.getConfig().getBoolean("debug", false)) {
                        this.mmoItems.getTypes().getAll().forEach(type -> LOGGER.info("Available MMO item types: " + type.getId()));
                    }
                } else {
                    LOGGER.warning("MMOItems found, but API unavailable");
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                LOGGER.warning("MMOItems found, but version incompatible: " + e.getMessage());
                this.isMMOItemsEnabled = false;
            }
            catch (Exception e) {
                LOGGER.severe("Error initializing MMOItems: " + e.getMessage());
                this.isMMOItemsEnabled = false;
            }
        }
    }

    private void createExampleConfig() {
        if (!this.plugin.getConfig().contains("custom_drops")) {
            this.plugin.getConfig().set("custom_drops.example_info", (Object)"Copy and adapt examples below to your config.yml");
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.type", (Object)"mmoitems");
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.mmo_type", (Object)"CONSUMABLE");
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.mmo_id", (Object)"GOLDEN_BEEF");
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.chance", (Object)15.0);
            this.plugin.getConfig().set("custom_drops.cow.kill_drops.rare_meat.amount", (Object)1);
        }
    }

    public boolean isMythicMob(Entity entity) {
        if (!this.isMythicMobsEnabled || this.mythicBukkit == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        try {
            return this.mythicBukkit.getMobManager().isActiveMob(entity.getUniqueId());
        }
        catch (Exception e) {
            this.logDebug("Error checking MythicMob: " + e.getMessage());
            return false;
        }
    }

    public String getMythicMobType(Entity entity) {
        if (!this.isMythicMobsEnabled || this.mythicBukkit == null || !(entity instanceof LivingEntity)) {
            return null;
        }
        try {
            ActiveMob activeMob = this.mythicBukkit.getMobManager().getMythicMobInstance((Entity)((LivingEntity)entity));
            return activeMob != null ? activeMob.getMobType() : null;
        }
        catch (Exception e) {
            this.logDebug("Error getting MythicMob type: " + e.getMessage());
            return null;
        }
    }

    public String getMythicMobDisplayName(Entity entity) {
        String mythicType = this.getMythicMobType(entity);
        if (mythicType != null) {
            String configName = this.plugin.getConfig().getString("animals." + mythicType.toLowerCase() + ".display_name");
            if (configName != null && !configName.isEmpty()) {
                return configName;
            }
            return mythicType;
        }
        return null;
    }

    public ItemStack createMMOItem(String typeStr, String id, int amount) {
        if (!this.isMMOItemsEnabled || this.mmoItems == null) {
            LOGGER.warning("MMOItems unavailable for creating item " + typeStr + ":" + id);
            return null;
        }
        try {
            Type type = this.mmoItems.getTypes().get(typeStr.toUpperCase());
            if (type == null) {
                LOGGER.warning("Unknown MMOItems type: " + typeStr);
                this.logAvailableTypes();
                return null;
            }
            MMOItem mmoItem = this.mmoItems.getItems().getMMOItem(type, id);
            if (mmoItem == null) {
                LOGGER.warning("MMOItems item not found: " + typeStr + ":" + id);
                this.logAvailableItems(type);
                return null;
            }
            ItemStack itemStack = mmoItem.newBuilder().build();
            if (itemStack != null && itemStack.getType() != Material.AIR) {
                itemStack.setAmount(amount);
                this.logDebug("Created MMOItems: " + typeStr + ":" + id + " x" + amount);
                return itemStack;
            }
            LOGGER.warning("Failed to create ItemStack for " + typeStr + ":" + id);
            return null;
        }
        catch (Exception e) {
            LOGGER.severe("Error creating MMOItems " + typeStr + ":" + id + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean mmoItemExists(String typeStr, String id) {
        if (!this.isMMOItemsEnabled || this.mmoItems == null) {
            return false;
        }
        try {
            Type type = this.mmoItems.getTypes().get(typeStr.toUpperCase());
            if (type == null) {
                return false;
            }
            MMOItem mmoItem = this.mmoItems.getItems().getMMOItem(type, id);
            return mmoItem != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemStack getCustomDrop(Animals animal, boolean isKillDrop) {
        String animalKey = this.getAnimalConfigKey(animal);
        String dropType = isKillDrop ? "kill_drops" : "resource_drops";
        ConfigurationSection dropsSection = this.plugin.getConfig().getConfigurationSection("custom_drops." + animalKey + "." + dropType);
        if (dropsSection == null) {
            return null;
        }
        ArrayList<DropInfo> possibleDrops = new ArrayList<DropInfo>();
        for (String dropKey : dropsSection.getKeys(false)) {
            DropInfo dropInfo;
            ConfigurationSection dropConfig = dropsSection.getConfigurationSection(dropKey);
            if (dropConfig == null || (dropInfo = this.parseDropConfig(dropConfig, dropKey)) == null) continue;
            possibleDrops.add(dropInfo);
        }
        return this.selectRandomDrop(possibleDrops);
    }

    private DropInfo parseDropConfig(ConfigurationSection config, String dropKey) {
        String type = config.getString("type", "vanilla").toLowerCase();
        double chance = config.getDouble("chance", 100.0);
        int amount = config.getInt("amount", 1);
        ItemStack item = null;
        switch (type) {
            case "vanilla": {
                String material = config.getString("material", "STONE");
                try {
                    ItemMeta meta;
                    Material mat = Material.valueOf((String)material.toUpperCase());
                    item = new ItemStack(mat, amount);
                    String displayName = config.getString("display_name");
                    List lore = config.getStringList("lore");
                    if (displayName == null && lore.isEmpty() || (meta = item.getItemMeta()) == null) break;
                    if (displayName != null) {
                        meta.setDisplayName(this.colorize(displayName));
                    }
                    if (!lore.isEmpty()) {
                        ArrayList coloredLore = new ArrayList();
                        lore.forEach(line -> coloredLore.add(this.colorize((String)line)));
                        meta.setLore(coloredLore);
                    }
                    item.setItemMeta(meta);
                    break;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warning("Invalid material in config: " + material + " (drop: " + dropKey + ")");
                    return null;
                }
            }
            case "mmoitems": 
            case "mmoitem": {
                if (!this.isMMOItemsEnabled) {
                    LOGGER.warning("MMOItems drop configured but plugin unavailable: " + dropKey);
                    return null;
                }
                String mmoType = config.getString("mmo_type", "");
                String mmoId = config.getString("mmo_id", "");
                if (mmoType.isEmpty() || mmoId.isEmpty()) {
                    LOGGER.warning("Invalid MMOItems drop config: " + dropKey + " (need mmo_type and mmo_id)");
                    return null;
                }
                item = this.createMMOItem(mmoType, mmoId, amount);
                if (item != null) break;
                LOGGER.warning("Failed to create MMOItems: " + mmoType + ":" + mmoId);
                return null;
            }
            default: {
                LOGGER.warning("Unknown drop type: " + type + " (drop: " + dropKey + ")");
                return null;
            }
        }
        if (item != null) {
            this.logDebug("Loaded drop: " + dropKey + " (" + type + ") with chance " + chance + "%");
            return new DropInfo(item, chance);
        }
        return null;
    }

    private ItemStack selectRandomDrop(List<DropInfo> drops) {
        if (drops.isEmpty()) {
            return null;
        }
        for (DropInfo drop : drops) {
            double roll = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            if (!(roll < drop.chance)) continue;
            this.logDebug("Drop selected: " + drop.item.getType() + " (chance: " + drop.chance + "%, rolled: " + String.format("%.1f", roll) + "%)");
            return drop.item.clone();
        }
        this.logDebug("No drop selected from " + drops.size() + " possible");
        return null;
    }

    private String getAnimalConfigKey(Animals animal) {
        String mythicType;
        if (this.isMythicMob((Entity)animal) && (mythicType = this.getMythicMobType((Entity)animal)) != null) {
            return mythicType.toLowerCase();
        }
        return animal.getType().name().toLowerCase();
    }

    public boolean hasCustomDrops(Animals animal, boolean isKillDrop) {
        String animalKey = this.getAnimalConfigKey(animal);
        String dropType = isKillDrop ? "kill_drops" : "resource_drops";
        return this.plugin.getConfig().getConfigurationSection("custom_drops." + animalKey + "." + dropType) != null;
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private void logAvailableTypes() {
        if (this.isMMOItemsEnabled && this.mmoItems != null) {
            this.mmoItems.getTypes().getAll().forEach(type -> LOGGER.info("- " + type.getId()));
        }
    }

    private void logAvailableItems(Type type) {
        if (!this.isMMOItemsEnabled || this.mmoItems != null) {
            // empty if block
        }
    }

    public boolean isSupportedEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Animals) {
            String animalType = entity.getType().name().toLowerCase();
            return this.plugin.getConfig().contains("animals." + animalType);
        }
        if (this.isMythicMobsEnabled && this.mythicBukkit != null) {
            try {
                return this.mythicBukkit.getMobManager().isActiveMob(entity.getUniqueId());
            }
            catch (Exception e) {
                this.logDebug("Error checking MythicMob: " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    public String getEntityDisplayName(Entity entity) {
        if (entity == null) {
            return "Unknown";
        }
        if (this.isMythicMobsEnabled && this.mythicBukkit != null && entity instanceof LivingEntity) {
            try {
                ActiveMob activeMob = this.mythicBukkit.getMobManager().getMythicMobInstance((Entity)((LivingEntity)entity));
                if (activeMob != null) {
                    String configName = this.plugin.getConfig().getString("animals." + activeMob.getMobType().toLowerCase() + ".display_name");
                    return configName != null && !configName.isEmpty() ? this.colorize(configName) : activeMob.getMobType();
                }
            }
            catch (Exception e) {
                this.logDebug("Error getting MythicMob display name: " + e.getMessage());
            }
        }
        if (entity instanceof Animals) {
            String animalType = entity.getType().name().toLowerCase();
            String configName = this.plugin.getConfig().getString("animals." + animalType + ".display_name");
            return configName != null && !configName.isEmpty() ? this.colorize(configName) : animalType;
        }
        return entity.getType().name().toLowerCase();
    }

    public boolean isValidFeedItem(ItemStack item, List<String> feedItems) {
        if (item == null || item.getType() == Material.AIR || feedItems == null || feedItems.isEmpty()) {
            return false;
        }
        String itemMaterial = item.getType().name().toUpperCase();
        if (feedItems.contains(itemMaterial)) {
            return true;
        }
        if (this.isMMOItemsEnabled && this.mmoItems != null) {
            try {
                for (String feedItem : feedItems) {
                    ItemStack mmoItemStack;
                    String[] parts;
                    if (!feedItem.startsWith("mmoitems:") || (parts = feedItem.split(":")).length != 3) continue;
                    String mmoType = parts[1].toUpperCase();
                    String mmoId = parts[2];
                    MMOItem mmoItem = this.mmoItems.getItems().getMMOItem(this.mmoItems.getTypes().get(mmoType), mmoId);
                    if (mmoItem == null || (mmoItemStack = mmoItem.newBuilder().build()) == null || !mmoItemStack.isSimilar(item)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                this.logDebug("Error checking MMOItems feed item: " + e.getMessage());
            }
        }
        return false;
    }

    private void logDebug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            // empty if block
        }
    }

    public boolean isMythicMobsEnabled() {
        return this.isMythicMobsEnabled;
    }

    public boolean isMMOItemsEnabled() {
        return this.isMMOItemsEnabled;
    }

    private static class DropInfo {
        final ItemStack item;
        final double chance;

        DropInfo(ItemStack item, double chance) {
            this.item = item;
            this.chance = chance;
        }
    }
}

