/*
 * Decompiled with CFR 0.152.
 */
package animalhunger.animalhunger;

import animalhunger.animalhunger.ColorUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final int resourceId;
    private final boolean enabled;
    private final boolean notifyPlayers;
    private final boolean showInConsole;

    public UpdateChecker(JavaPlugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
        this.enabled = plugin.getConfig().getBoolean("update-checker.enabled", true);
        this.notifyPlayers = plugin.getConfig().getBoolean("update-checker.notify-players", true);
        this.showInConsole = plugin.getConfig().getBoolean("update-checker.show-in-console", true);
    }

    public void check() {
        if (!this.enabled || !this.showInConsole) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(3000);
                connection.setReadTimeout(3000);
                String latest = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
                if (latest == null) {
                    return;
                }
                latest = latest.trim();
                String current = this.plugin.getDescription().getVersion();
                if (!latest.equalsIgnoreCase(current)) {
                    this.plugin.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557"));
                    this.plugin.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8\u2551   &6&lNEW UPDATE AVAILABLE!&r               &8\u2551"));
                    this.plugin.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8\u2551                                       \u2551"));
                    this.plugin.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u2551   &7Current: &c" + current + "                    &8\u2551")));
                    this.plugin.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u2551   &7Latest:  &a&l" + latest + "                    &8\u2551")));
                    this.plugin.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8\u2551                                       \u2551"));
                    this.plugin.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8\u2551   &e&lDownload: &b&nspigotmc.org/resources/" + this.resourceId + " &8\u2551")));
                    this.plugin.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d"));
                }
                connection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void notifyPlayer(Player player) {
        if (!this.enabled || !this.notifyPlayers) {
            return;
        }
        if (player.hasPermission("animalhunger.admin")) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    HttpURLConnection connection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(3000);
                    connection.setReadTimeout(3000);
                    String latest = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
                    if (latest == null) {
                        return;
                    }
                    latest = latest.trim();
                    String current = this.plugin.getDescription().getVersion();
                    if (!latest.equalsIgnoreCase(current)) {
                        String finalLatest = latest;
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                            player.sendMessage("");
                            player.sendMessage(ColorUtils.colorize("\u00a78\u00a7m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
                            player.sendMessage(ColorUtils.colorize("&#FFD700&l         \u26a1 ANIMAL HUNGER UPDATE \u26a1"));
                            player.sendMessage("");
                            player.sendMessage(ColorUtils.colorize("  &#87CEEBCurrent Version: &#F08080" + current));
                            player.sendMessage(ColorUtils.colorize("  &#87CEEBLatest Version:  &#98FB98&l" + finalLatest));
                            player.sendMessage("");
                            player.sendMessage(ColorUtils.colorize("  &#FFD700&l\u00bb &#FFA500Download: &#00BFFF&nhttps://www.spigotmc.org/resources/117419"));
                            player.sendMessage("");
                            player.sendMessage(ColorUtils.colorize("\u00a78\u00a7m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
                            player.sendMessage("");
                        });
                    }
                    connection.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

