/*
 * Decompiled with CFR 0.152.
 */
package de.miraisoft.ash2;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.miraisoft.ash2.AshMod;
import de.miraisoft.ash2.config.AshConfig;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;

public class AshCommands {
    private static final String COMMAND_TOGGLE = "ash2toggle";
    private static final String COMMAND_RESET = "ash2reset";
    private static final String COMMAND_FPS = "ash2togglefps";
    private static final String COMMAND_COORDS = "ash2togglecoords";
    private static final String COMMAND_DIRECTION = "ash2toggledirection";
    private static final String COMMAND_COLOR = "ash2color";
    private static final String COMMAND_TEXT_ALPHA = "ash2textalpha";
    private static final String COMMAND_BACKGROUND_COLOR = "ash2backgroundcolor";
    private static final String COMMAND_BACKGROUND_ALPHA = "ash2backgroundalpha";
    private static final String COMMAND_LIGHTLEVEL = "ash2togglelightlevel";
    private static final String COMMAND_TIME = "ash2toggletime";
    private static final String COMMAND_BIOME = "ash2togglebiome";
    private static final String COMMAND_CONCISE_COORDS = "ash2toggleconcisecoords";
    private static final String COMMAND_TOGGLE_BACKGROUND = "ash2togglebackground";
    public static AshConfig config;

    public static void registerCommands() {
        if (config == null) {
            config = (AshConfig)AutoConfig.getConfigHolder(AshConfig.class).getConfig();
        }
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_TOGGLE).executes(context -> {
            AshCommands.config.showHud = !AshCommands.config.showHud;
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_RESET).executes(context -> {
            AshCommands.resetConfig(config);
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_FPS).executes(context -> {
            AshCommands.config.showFps = !AshCommands.config.showFps;
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_COORDS).executes(context -> {
            AshCommands.config.showCoords = !AshCommands.config.showCoords;
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_DIRECTION).executes(context -> {
            AshCommands.config.showDirection = !AshCommands.config.showDirection;
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_COLOR).then(ClientCommandManager.argument((String)"r", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"g", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"b", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int r = IntegerArgumentType.getInteger((CommandContext)context, (String)"r");
            int g = IntegerArgumentType.getInteger((CommandContext)context, (String)"g");
            int b = IntegerArgumentType.getInteger((CommandContext)context, (String)"b");
            AshCommands.config.hudTextColor = b + (g << 8) + (r << 16);
            AshMod.configManager.save();
            return 1;
        }))))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_TEXT_ALPHA).then(ClientCommandManager.argument((String)"text alpha", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int alpha = IntegerArgumentType.getInteger((CommandContext)context, (String)"text alpha");
            if (alpha < 0) {
                alpha = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            }
            AshCommands.config.hudTextAlpha = alpha;
            AshMod.configManager.save();
            return 1;
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_BACKGROUND_COLOR).then(ClientCommandManager.argument((String)"r", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"g", (ArgumentType)IntegerArgumentType.integer()).then(ClientCommandManager.argument((String)"b", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int r = IntegerArgumentType.getInteger((CommandContext)context, (String)"r");
            int g = IntegerArgumentType.getInteger((CommandContext)context, (String)"g");
            int b = IntegerArgumentType.getInteger((CommandContext)context, (String)"b");
            AshCommands.config.hudBackgroundColor = b + (g << 8) + (r << 16);
            AshMod.configManager.save();
            return 1;
        }))))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_BACKGROUND_ALPHA).then(ClientCommandManager.argument((String)"bg alpha", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int alpha = IntegerArgumentType.getInteger((CommandContext)context, (String)"bg alpha");
            if (alpha < 0) {
                alpha = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            }
            AshCommands.config.hudBackgroundAlpha = alpha;
            AshMod.configManager.save();
            return 1;
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_LIGHTLEVEL).executes(context -> {
            AshCommands.config.showLightLevel = !AshCommands.config.showLightLevel;
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_TIME).executes(context -> {
            AshCommands.config.showTime = !AshCommands.config.showTime;
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_BIOME).executes(context -> {
            AshCommands.config.showBiome = !AshCommands.config.showBiome;
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_CONCISE_COORDS).executes(context -> {
            AshCommands.config.conciseCoords = !AshCommands.config.conciseCoords;
            AshMod.configManager.save();
            return 1;
        })));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)COMMAND_TOGGLE_BACKGROUND).executes(context -> {
            AshCommands.config.showBackground = !AshCommands.config.showBackground;
            AshMod.configManager.save();
            return 1;
        })));
    }

    private static void resetConfig(AshConfig config) {
        config.showHud = true;
        config.hudTextColor = 0xFFFFFF;
        config.hudTextAlpha = 255;
        config.hudBackgroundColor = 0;
        config.hudBackgroundAlpha = 128;
        config.showFps = true;
        config.showCoords = true;
        config.showDirection = true;
        config.showLightLevel = true;
        config.showBiome = true;
        config.showTime = true;
        config.conciseCoords = false;
        config.showBackground = true;
    }
}

