/*
 * Decompiled with CFR 0.152.
 */
package de.miraisoft.ash2;

public enum DirectionEnum {
    N("North"),
    NE("North-east"),
    E("East"),
    SE("South-east"),
    S("South"),
    SW("South-west"),
    W("West"),
    NW("North-west");

    public String longName;

    private DirectionEnum(String longName) {
        this.longName = longName;
    }

    public static DirectionEnum getByYawDegrees(float degrees) {
        switch (Math.round((degrees += 180.0f) / 45.0f)) {
            case 0: {
                return N;
            }
            case 1: {
                return NE;
            }
            case 2: {
                return E;
            }
            case 3: {
                return SE;
            }
            case 4: {
                return S;
            }
            case 5: {
                return SW;
            }
            case 6: {
                return W;
            }
            case 7: {
                return NW;
            }
        }
        return N;
    }

    public String getX() {
        if (E.equals((Object)this)) {
            return " ++";
        }
        if (NE.equals((Object)this)) {
            return " +";
        }
        if (SE.equals((Object)this)) {
            return " +";
        }
        if (W.equals((Object)this)) {
            return " --";
        }
        if (NW.equals((Object)this)) {
            return " -";
        }
        if (SW.equals((Object)this)) {
            return " -";
        }
        return "";
    }

    public String getZ() {
        if (S.equals((Object)this)) {
            return " ++";
        }
        if (SE.equals((Object)this)) {
            return " +";
        }
        if (SW.equals((Object)this)) {
            return " +";
        }
        if (N.equals((Object)this)) {
            return " --";
        }
        if (NE.equals((Object)this)) {
            return " -";
        }
        if (NW.equals((Object)this)) {
            return " -";
        }
        return "";
    }
}

