/*
 * Decompiled with CFR 0.152.
 */
package de.miraisoft.ash2.mixin;

import de.miraisoft.ash2.AshCommands;
import de.miraisoft.ash2.DirectionEnum;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public class InGameHudMixin {
    private static final int COLOR_X = -2228259;
    private static final int COLOR_Y = -35;
    private static final int COLOR_Z = -2236929;
    private static final int PADDING = 5;
    private static final int TEXT_POS_X = 5;
    private int textPosY = 5;

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void render(class_332 drawContext, class_9779 tickCounter, CallbackInfo info) {
        class_310 client = class_310.method_1551();
        class_1297 cameraEntity = client.method_1560();
        this.textPosY = 5;
        if (!client.method_53526().method_53536() && AshCommands.config.showHud) {
            this.drawFps(drawContext, client, cameraEntity);
            this.drawCoordsAndDirection(drawContext, client, cameraEntity);
            this.drawLightLevel(drawContext, client, cameraEntity);
            this.drawBiome(drawContext, client, cameraEntity);
            this.drawTime(drawContext, client, cameraEntity);
        }
    }

    private void drawFps(class_332 drawContext, class_310 client, class_1297 cameraEntity) {
        if (!AshCommands.config.showFps) {
            return;
        }
        String ashString = String.format("%d fps", client.method_47599());
        int backgroundColor = AshCommands.config.hudBackgroundColor + (AshCommands.config.hudBackgroundAlpha << 24);
        int textColor = AshCommands.config.hudTextColor + (AshCommands.config.hudTextAlpha << 24);
        if (AshCommands.config.showBackground) {
            int n = 5 + 6 * ashString.length();
            Objects.requireNonNull(client.field_1772);
            drawContext.method_25294(5, this.textPosY, n, this.textPosY + 9 - 1, backgroundColor);
        }
        drawContext.method_25303(client.field_1772, ashString, 5, this.textPosY, textColor);
        Objects.requireNonNull(client.field_1772);
        this.textPosY += 9 + 1;
    }

    private void drawCoordsAndDirection(class_332 drawContext, class_310 client, class_1297 cameraEntity) {
        if (!AshCommands.config.showCoords && !AshCommands.config.showDirection || client.method_1555()) {
            return;
        }
        float degrees = class_3532.method_15393((float)cameraEntity.method_36454());
        DirectionEnum directionEnum = DirectionEnum.getByYawDegrees(degrees);
        int backgroundColor = AshCommands.config.hudBackgroundColor + (AshCommands.config.hudBackgroundAlpha << 24);
        int textColor = AshCommands.config.hudTextColor + (AshCommands.config.hudTextAlpha << 24);
        if (AshCommands.config.showCoords) {
            class_2338 blockPos = cameraEntity.method_24515();
            if (AshCommands.config.conciseCoords) {
                Object direction = "";
                if (AshCommands.config.showDirection) {
                    direction = (String)direction + directionEnum.name();
                }
                String coordsText = String.format("%d / %d / %d  %s", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), direction);
                if (AshCommands.config.showBackground) {
                    int n = 5 + 6 * coordsText.length();
                    Objects.requireNonNull(client.field_1772);
                    drawContext.method_25294(5, this.textPosY, n, this.textPosY + 9 - 1, backgroundColor);
                }
                drawContext.method_25303(client.field_1772, coordsText, 5, this.textPosY, textColor);
            } else {
                Object xText = String.format("x: %d", blockPos.method_10263());
                String yText = String.format("y: %d", blockPos.method_10264());
                Object zText = String.format("z: %d", blockPos.method_10260());
                xText = (String)xText + directionEnum.getX();
                zText = (String)zText + directionEnum.getZ();
                Objects.requireNonNull(client.field_1772);
                int heightDiff = 9 + 1;
                if (AshCommands.config.showBackground) {
                    int n = 5 + 6 * ((String)xText).length();
                    Objects.requireNonNull(client.field_1772);
                    drawContext.method_25294(5, this.textPosY, n, this.textPosY + 9 - 1, backgroundColor);
                }
                drawContext.method_25303(client.field_1772, (String)xText, 5, this.textPosY, -2228259);
                this.textPosY += heightDiff;
                if (AshCommands.config.showBackground) {
                    int n = 5 + 6 * yText.length();
                    Objects.requireNonNull(client.field_1772);
                    drawContext.method_25294(5, this.textPosY, n, this.textPosY + 9 - 1, backgroundColor);
                }
                drawContext.method_25303(client.field_1772, yText, 5, this.textPosY, -35);
                this.textPosY += heightDiff;
                if (AshCommands.config.showBackground) {
                    int n = 5 + 6 * ((String)zText).length();
                    Objects.requireNonNull(client.field_1772);
                    drawContext.method_25294(5, this.textPosY, n, this.textPosY + 9 - 1, backgroundColor);
                }
                drawContext.method_25303(client.field_1772, (String)zText, 5, this.textPosY, -2236929);
            }
            Objects.requireNonNull(client.field_1772);
            this.textPosY += 9 + 1;
        }
        if (!AshCommands.config.showDirection || AshCommands.config.conciseCoords) {
            return;
        }
        String ashString = "Direction: " + directionEnum.longName;
        if (AshCommands.config.showBackground) {
            int n = 5 + 6 * ashString.length();
            Objects.requireNonNull(client.field_1772);
            drawContext.method_25294(5, this.textPosY, n, this.textPosY + 9 - 1, backgroundColor);
        }
        drawContext.method_25303(client.field_1772, ashString, 5, this.textPosY, textColor);
        Objects.requireNonNull(client.field_1772);
        this.textPosY += 9 + 1;
    }

    private void drawLightLevel(class_332 drawContext, class_310 client, class_1297 cameraEntity) {
        if (!AshCommands.config.showLightLevel) {
            return;
        }
        class_2338 blockPos = cameraEntity.method_24515();
        int lightLevel = client.field_1687.method_8314(class_1944.field_9282, blockPos);
        String ashString = "Light Level: " + lightLevel;
        int backgroundColor = AshCommands.config.hudBackgroundColor + (AshCommands.config.hudBackgroundAlpha << 24);
        int textColor = AshCommands.config.hudTextColor + (AshCommands.config.hudTextAlpha << 24);
        if (lightLevel == 0) {
            textColor = -21846;
        }
        int textPosX = client.method_22683().method_4486() - client.field_1772.method_1727(ashString) - 5;
        if (AshCommands.config.showBackground) {
            int n = textPosX + 6 * ashString.length();
            Objects.requireNonNull(client.field_1772);
            drawContext.method_25294(textPosX, 5, n, 5 + 9 - 1, backgroundColor);
        }
        drawContext.method_25303(client.field_1772, ashString, textPosX, 5, textColor);
    }

    private void drawBiome(class_332 drawContext, class_310 client, class_1297 cameraEntity) {
        if (!AshCommands.config.showBiome) {
            return;
        }
        class_2338 blockPos = cameraEntity.method_24515();
        String biomeKey = ((class_5321)client.field_1687.method_23753(blockPos).method_40230().get()).method_29177().method_42093("biome");
        String ashString = "Biome: " + class_2561.method_43471((String)biomeKey).getString();
        int backgroundColor = AshCommands.config.hudBackgroundColor + (AshCommands.config.hudBackgroundAlpha << 24);
        int textColor = AshCommands.config.hudTextColor + (AshCommands.config.hudTextAlpha << 24);
        if (AshCommands.config.showBackground) {
            int n = 5 + 6 * ashString.length();
            Objects.requireNonNull(client.field_1772);
            drawContext.method_25294(5, this.textPosY, n, this.textPosY + 9 - 1, backgroundColor);
        }
        drawContext.method_25303(client.field_1772, ashString, 5, this.textPosY, textColor);
        Objects.requireNonNull(client.field_1772);
        this.textPosY += 9 + 1;
    }

    private void drawTime(class_332 drawContext, class_310 client, class_1297 cameraEntity) {
        if (!AshCommands.config.showTime) {
            return;
        }
        int backgroundColor = AshCommands.config.hudBackgroundColor + (AshCommands.config.hudBackgroundAlpha << 24);
        int textColor = AshCommands.config.hudTextColor + (AshCommands.config.hudTextAlpha << 24);
        int hour = (int)((double)client.field_1687.method_8532() / 1000.0 + 6.0) % 24;
        int minutes = (int)((double)client.field_1687.method_8532() / 1000.0 * 60.0 % 60.0);
        String ashString = minutes <= 9 ? String.format("Time: %d:0%d", hour, minutes) : String.format("Time: %d:%d", hour, minutes);
        if (AshCommands.config.showBackground) {
            int n = 5 + 6 * ashString.length();
            Objects.requireNonNull(client.field_1772);
            drawContext.method_25294(5, this.textPosY, n, this.textPosY + 9 - 1, backgroundColor);
        }
        drawContext.method_25303(client.field_1772, ashString, 5, this.textPosY, textColor);
        Objects.requireNonNull(client.field_1772);
        this.textPosY += 9 + 1;
    }
}

