/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aesthetictables.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Table
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LEG1 = BooleanProperty.create((String)"leg1");
    public static final BooleanProperty LEG2 = BooleanProperty.create((String)"leg2");
    public static final BooleanProperty LEG3 = BooleanProperty.create((String)"leg3");
    public static final BooleanProperty LEG4 = BooleanProperty.create((String)"leg4");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape TOP = Block.box((double)0.0, (double)13.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_1 = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)13.5, (double)3.0);
    protected static final VoxelShape LEG_2 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)13.5, (double)15.0);
    protected static final VoxelShape LEG_3 = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)13.5, (double)15.0);
    protected static final VoxelShape LEG_4 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)13.5, (double)3.0);

    public Table(BlockBehaviour.Properties settings) {
        super(settings.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LEG1, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LEG1, LEG2, LEG3, LEG4, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER;
        return this.getUpdatedLegs((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)), (LevelAccessor)ctx.getLevel(), ctx.getClickedPos());
    }

    protected BlockState updateShape(BlockState state, Direction dir, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.getUpdatedLegs(state, world, pos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    private BlockState getUpdatedLegs(BlockState state, LevelAccessor world, BlockPos pos) {
        boolean north = this.connectsTo(world, pos.north());
        boolean east = this.connectsTo(world, pos.east());
        boolean south = this.connectsTo(world, pos.south());
        boolean west = this.connectsTo(world, pos.west());
        boolean ne = this.connectsTo(world, pos.north().east());
        boolean se = this.connectsTo(world, pos.south().east());
        boolean sw = this.connectsTo(world, pos.south().west());
        boolean nw = this.connectsTo(world, pos.north().west());
        boolean leg1 = !north && !east || north && east && !ne;
        boolean leg2 = !east && !south || east && south && !se;
        boolean leg3 = !south && !west || south && west && !sw;
        boolean leg4 = !north && !west || north && west && !nw;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)LEG1, (Comparable)Boolean.valueOf(leg1))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(leg2))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(leg3))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(leg4));
    }

    private boolean connectsTo(LevelAccessor world, BlockPos pos) {
        BlockState neighbor = world.getBlockState(pos);
        return neighbor.getBlock() == this;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ctx) {
        VoxelShape shape = TOP;
        if (((Boolean)state.getValue((Property)LEG1)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)LEG_1);
        }
        if (((Boolean)state.getValue((Property)LEG2)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)LEG_2);
        }
        if (((Boolean)state.getValue((Property)LEG3)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)LEG_3);
        }
        if (((Boolean)state.getValue((Property)LEG4)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)LEG_4);
        }
        return shape;
    }
}

