/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aesthetictables.block.custom;

import java.util.ArrayList;
import net.alminoris.aesthetictables.block.custom.YAxisRotatedBlock;
import net.alminoris.aesthetictables.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GardenTable
extends YAxisRotatedBlock {
    protected static final VoxelShape TABLE_TOP = YAxisRotatedBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_FRONT = YAxisRotatedBlock.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0);
    protected static final VoxelShape LEG_BACK = YAxisRotatedBlock.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);

    public GardenTable(BlockBehaviour.Properties settings) {
        super(settings.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Variant variant = (Variant)((Object)state.m_61143_(VARIANT));
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        switch (variant) {
            case NORMAL: {
                boxes.add(TABLE_TOP.m_83215_());
                boxes.add(LEG_FRONT.m_83215_());
                boxes.add(LEG_BACK.m_83215_());
                break;
            }
            case CENTER: {
                boxes.add(TABLE_TOP.m_83215_());
                break;
            }
            case LEFT: {
                boxes.add(TABLE_TOP.m_83215_());
                boxes.add(LEG_FRONT.m_83215_());
                break;
            }
            case RIGHT: {
                boxes.add(TABLE_TOP.m_83215_());
                boxes.add(LEG_BACK.m_83215_());
            }
        }
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return this.updateGardenTableVariant(state, world, pos);
    }

    @Override
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        super.m_6807_(state, world, pos, oldState, notify);
        this.updateSurroundingGardenTablees(world, pos);
    }

    private void updateSurroundingGardenTablees(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121955_(direction.m_122436_());
            BlockState neighborState = world.m_8055_(neighborPos);
            if (neighborState.m_60734_() != this) continue;
            world.m_7731_(neighborPos, this.updateGardenTableVariant(neighborState, (LevelAccessor)world, neighborPos), 3);
        }
    }

    private BlockState updateGardenTableVariant(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos leftPos = pos.m_121955_(facing.m_175364_(Direction.Axis.Y).m_122436_());
        BlockPos rightPos = pos.m_121955_(facing.m_175362_(Direction.Axis.Y).m_122436_());
        boolean leftConnected = this.isGardenTable(world, leftPos, facing);
        boolean rightConnected = this.isGardenTable(world, rightPos, facing);
        if (leftConnected && rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.CENTER));
        }
        if (leftConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.RIGHT));
        }
        if (rightConnected) {
            return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.LEFT));
        }
        return (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    private boolean isGardenTable(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() == this && state.m_61143_((Property)FACING) == facing;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        CENTER("center"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

