/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aesthetictables.util.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape rotateShape(List<AABB> boxes, Direction facing) {
        ArrayList<VoxelShape> rotatedShapes = new ArrayList<VoxelShape>();
        for (AABB originalBox : boxes) {
            double minX = originalBox.minX;
            double minY = originalBox.minY;
            double minZ = originalBox.minZ;
            double maxX = originalBox.maxX;
            double maxY = originalBox.maxY;
            double maxZ = originalBox.maxZ;
            VoxelShape rotatedShape = switch (facing) {
                case Direction.NORTH -> Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                case Direction.SOUTH -> Shapes.box((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ));
                case Direction.WEST -> Shapes.box((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX));
                case Direction.EAST -> Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                default -> Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            };
            rotatedShape = VoxelShapeHelper.ensureValidBox(rotatedShape);
            rotatedShapes.add(rotatedShape);
        }
        VoxelShape finalShape = Shapes.empty();
        for (VoxelShape shape : rotatedShapes) {
            finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)shape);
        }
        return finalShape;
    }

    private static VoxelShape ensureValidBox(VoxelShape shape) {
        AABB box = shape.bounds();
        double minX = Math.min(box.minX, box.maxX);
        double maxX = Math.max(box.minX, box.maxX);
        double minY = Math.min(box.minY, box.maxY);
        double maxY = Math.max(box.minY, box.maxY);
        double minZ = Math.min(box.minZ, box.maxZ);
        double maxZ = Math.max(box.minZ, box.maxZ);
        return Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }
}

