
package xyz.naomieow.difficultyex.config

import blue.endless.jankson.Jankson
import io.wispforest.owo.config.ConfigWrapper
import io.wispforest.owo.config.Option
import io.wispforest.owo.util.Observable
import kotlin.reflect.KProperty

class DifficultyEXConfig private constructor(janksonBuilder: (Jankson.Builder) -> Unit) : ConfigWrapper<DifficultyEXConfigModel>(DifficultyEXConfigModel::class.java, janksonBuilder) {
    private val parentKey = Option.Key.ROOT
    
    constructor(): this({})
    
    companion object {
        fun createAndLoad(janksonBuilder: (Jankson.Builder) -> Unit = {}): DifficultyEXConfig {
            return DifficultyEXConfig(janksonBuilder).apply {
                load()
            }
        }
    }
    
    val dimensionSettings = DimensionScalingSettings(parentKey.child("dimensionSettings"))
    
    val biomeScalingSettings = BiomeScalingSettings(parentKey.child("biomeScalingSettings"))
    
    val structureScalingSettings = StructureScalingSettings(parentKey.child("structureScalingSettings"))
    
    val scalingLevelSettings = EntityScalingSettings(parentKey.child("scalingLevelSettings"))
    
    val visualSettings = VisualSettings(parentKey.child("visualSettings"))
    
    
    inner class DimensionScalingSettings(parentKey: Option.Key) {
        
        var startingLevels: kotlin.collections.Map<net.minecraft.resources.ResourceLocation, kotlin.Int> by optionForKey(parentKey.child("startingLevels"))!!
        
        
        var maximumLevels: kotlin.collections.Map<net.minecraft.resources.ResourceLocation, kotlin.Int> by optionForKey(parentKey.child("maximumLevels"))!!
        
        
        
    }
    
    inner class BiomeScalingSettings(parentKey: Option.Key) {
        
        var startingLevels: kotlin.collections.Map<net.minecraft.resources.ResourceLocation, kotlin.Int> by optionForKey(parentKey.child("startingLevels"))!!
        
        
        var maximumLevels: kotlin.collections.Map<net.minecraft.resources.ResourceLocation, kotlin.Int> by optionForKey(parentKey.child("maximumLevels"))!!
        
        
        
    }
    
    inner class StructureScalingSettings(parentKey: Option.Key) {
        
        var radius: kotlin.Int by optionForKey(parentKey.child("radius"))!!
        
        
        var startingLevels: kotlin.collections.Map<net.minecraft.resources.ResourceLocation, kotlin.Int> by optionForKey(parentKey.child("startingLevels"))!!
        
        
        var maximumLevels: kotlin.collections.Map<net.minecraft.resources.ResourceLocation, kotlin.Int> by optionForKey(parentKey.child("maximumLevels"))!!
        
        
        
    }
    
    inner class EntityScalingSettings(parentKey: Option.Key) {
        
        var maximumLevel: kotlin.Int by optionForKey(parentKey.child("maximumLevel"))!!
        
        
        var startingLevel: kotlin.Int by optionForKey(parentKey.child("startingLevel"))!!
        
        
        var levelScalingMaxRadiusByBlocks: kotlin.Int by optionForKey(parentKey.child("levelScalingMaxRadiusByBlocks"))!!
        
        
        var levelScalingByPlayerFormula: kotlin.String by optionForKey(parentKey.child("levelScalingByPlayerFormula"))!!
        
        
        var levelAverageDecrement: kotlin.Int by optionForKey(parentKey.child("levelAverageDecrement"))!!
        
        
        var levelAverageIncrement: kotlin.Int by optionForKey(parentKey.child("levelAverageIncrement"))!!
        
        
        var entityStartingLevels: kotlin.collections.Map<kotlin.String, kotlin.Int> by optionForKey(parentKey.child("entityStartingLevels"))!!
        
        
        var entityMaximumLevels: kotlin.collections.Map<kotlin.String, kotlin.Int> by optionForKey(parentKey.child("entityMaximumLevels"))!!
        
        
        var entityExperiencePercentage: kotlin.Double by optionForKey(parentKey.child("entityExperiencePercentage"))!!
        
        
        var entityBaseDamagePercentage: kotlin.Double by optionForKey(parentKey.child("entityBaseDamagePercentage"))!!
        
        
        var entityBaseArmorPercentage: kotlin.Double by optionForKey(parentKey.child("entityBaseArmorPercentage"))!!
        
        
        var entityBaseHealthPercentage: kotlin.Double by optionForKey(parentKey.child("entityBaseHealthPercentage"))!!
        
        
        var mobBlacklist: kotlin.collections.List<kotlin.String> by optionForKey(parentKey.child("mobBlacklist"))!!
        
        
        
    }
    
    inner class VisualSettings(parentKey: Option.Key) {
        
        var nameplateEnabled: kotlin.Boolean by optionForKey(parentKey.child("nameplateEnabled"))!!
        
        
        var showNameplateLevel: kotlin.Boolean by optionForKey(parentKey.child("showNameplateLevel"))!!
        
        
        var showNameplateHealthBar: kotlin.Boolean by optionForKey(parentKey.child("showNameplateHealthBar"))!!
        
        
        var showNameplateHealthText: kotlin.Boolean by optionForKey(parentKey.child("showNameplateHealthText"))!!
        
        
        var nameplateRenderDistance: kotlin.Int by optionForKey(parentKey.child("nameplateRenderDistance"))!!
        
        
        var nameplateShowHostileMobsOnly: kotlin.Boolean by optionForKey(parentKey.child("nameplateShowHostileMobsOnly"))!!
        
        
        var nameplateOffsetY: kotlin.Float by optionForKey(parentKey.child("nameplateOffsetY"))!!
        
        
        var nameplateOffsetScale: kotlin.Float by optionForKey(parentKey.child("nameplateOffsetScale"))!!
        
        
        var nameplateColor: io.wispforest.owo.ui.core.Color by optionForKey(parentKey.child("nameplateColor"))!!
        
        
        var nameplateBackgroundColor: io.wispforest.owo.ui.core.Color by optionForKey(parentKey.child("nameplateBackgroundColor"))!!
        
        
        var nameplateMobBlacklist: kotlin.collections.List<kotlin.String> by optionForKey(parentKey.child("nameplateMobBlacklist"))!!
        
        
        
    }
    
}

private operator fun <T> Option<T>.getValue(hisRef: Any?, property: KProperty<*>): T = this.value()
private operator fun <T> Option<T>.setValue(hisRef: Any?, property: KProperty<*>, value: T): Unit = this.set(value)

