package xyz.naomieow.difficultyex.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.naomieow.difficultyex.DifficultyEX;
import xyz.naomieow.difficultyex.component.DifficultyEXComponents;

@Mixin(class_1309.class)
public class LivingEntityMixin {
	@WrapMethod(method = "getMaxHealth")
	public float GetMaxHealth(Operation<Float> original) {
		class_1309 entity = (class_1309) (Object) this;
		if (entity instanceof class_1308) {
			return (float) (original.call() * (1 + entity.getComponent(DifficultyEXComponents.ENTITY_DATA).getLevel() * DifficultyEX.CONFIG.getScalingLevelSettings().getEntityBaseHealthPercentage()));
		}
		return original.call();
	}

	@WrapMethod(method = "getArmorValue")
	public int GetArmorValue(Operation<Integer> original) {
		class_1309 entity = (class_1309) (Object) this;
		if (entity instanceof class_1308) {
			return (int) (original.call() * (1 + entity.getComponent(DifficultyEXComponents.ENTITY_DATA).getLevel() * DifficultyEX.CONFIG.getScalingLevelSettings().getEntityBaseArmorPercentage()));
		}
		return original.call();
	}
}