package xyz.naomieow.difficultyex.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import xyz.naomieow.difficultyex.DifficultyEX;
import xyz.naomieow.difficultyex.component.DifficultyEXComponents;

@Mixin(class_1308.class)
public class MobMixin {
    @WrapOperation(method = "doHurtTarget", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Mob;getAttributeValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D"))
    public double DoHurtTarget(class_1308 instance, class_1320 attribute, Operation<Double> original) {
        var level = instance.getComponent(DifficultyEXComponents.ENTITY_DATA).getLevel();

        Double mobDamage = original.call(instance, attribute) * (1 + level * DifficultyEX.CONFIG.getScalingLevelSettings().getEntityBaseDamagePercentage());

        return mobDamage;
    }



    @ModifyReturnValue(method = "getExperienceReward", at = @At("RETURN"))
    public int GetExperienceReward(int original) {
        class_1309 livingEntity = (class_1309) (Object) this;

        var level = livingEntity.getComponent(DifficultyEXComponents.ENTITY_DATA).getLevel();

        return (int) (original * (1 + level * DifficultyEX.CONFIG.getScalingLevelSettings().getEntityExperiencePercentage()));
    }
}
