package xyz.naomieow.difficultyex.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import xyz.naomieow.difficultyex.nameplate.util.NameplateRender;

@Environment(EnvType.CLIENT)
@Mixin(GeoEntityRenderer.class)
public abstract class GeoEntityRendererMixin<T extends class_1309> extends class_897<T> {

    public GeoEntityRendererMixin(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Inject(method = "render", at = @At("HEAD"), remap = false)
    private void render(class_1297 entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, CallbackInfo ci) {
        if (entity instanceof class_1308) {
            NameplateRender.renderNameplate(this, (class_1308) entity, poseStack, bufferSource, field_4676, this.method_3932(), entity.method_5733(), packedLight);
        }
    }

    @Override
    protected boolean shouldShowName(T entity) {
        if (entity instanceof class_1308) {
            return false;
        }
        return super.method_3921(entity);
    }

    @Inject(method = "shouldShowName", at = @At(value = "RETURN", ordinal = 1), cancellable = true, remap = false)
    private void shouldShowNameMixin(class_1297 animatable, CallbackInfoReturnable<Boolean> cir) {
        if (animatable instanceof class_1308) {
            cir.setReturnValue(false);
        }
    }
}