package xyz.naomieow.difficultyex.mixin.client;


import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_922;
import net.minecraft.class_927;
import net.fabricmc.api.EnvType;
import xyz.naomieow.difficultyex.nameplate.util.NameplateRender;

@Environment(EnvType.CLIENT)
@Mixin(class_927.class)
public abstract class MobEntityRendererMixin<T extends class_1308, M extends class_583<T>> extends class_922<T, M> {

    public MobEntityRendererMixin(class_5617.class_5618 ctx, M model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method = "render*", at = @At("HEAD"))
    private void renderMixin(T mobEntity, float f, float g, class_4587 matrices, class_4597 vertexConsumers, int i, CallbackInfo info) {
        NameplateRender.renderNameplate(this, mobEntity, matrices, vertexConsumers, field_4676, this.method_3932(), this.method_4056(mobEntity), i);
    }

    @Inject(method = "shouldShowName(Lnet/minecraft/world/entity/Mob;)Z", at = @At("HEAD"), cancellable = true)
    protected void shouldShowName(T mobEntity, CallbackInfoReturnable<Boolean> info) {
        info.setReturnValue(false);
    }
}