/*
 * Decompiled with CFR 0.152.
 */
package lusouzadev.enhancedmotd;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.imageio.ImageIO;
import lusouzadev.enhancedmotd.Config;
import lusouzadev.enhancedmotd.FOModVersion;
import lusouzadev.enhancedmotd.ServerEventHandler;
import lusouzadev.enhancedmotd.TextFormatter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ServerStatus;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="enhanced_motd")
public class EnhancedMotd {
    public static final String MODID = "enhanced_motd";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static FOModVersion VERSION;
    private static Config CONFIG;
    private static final Random random;
    private static String[][] motds;
    private static ServerStatus.Favicon[] icons;

    public EnhancedMotd(@NotNull IEventBus modEventBus, @NotNull ModContainer modContainer) {
        VERSION = FOModVersion.fromString(modContainer.getModInfo().getVersion().toString());
        modEventBus.addListener(this::setup);
        NeoForge.EVENT_BUS.register((Object)new ServerEventHandler());
        LOGGER.info("EnhancedMOTD version: {}", (Object)VERSION);
    }

    private void setup(FMLCommonSetupEvent ignoredEvent) {
        LOGGER.info("EnhancedMOTD initializing...");
        EnhancedMotd.loadConfigFromFile();
    }

    public static Component getEnhancedMotd() {
        return EnhancedMotd.getRandomMotd(random);
    }

    public static Component getRandomMotd(Random random) {
        StringBuilder s = new StringBuilder();
        for (String[] w : motds) {
            s.append(w[random.nextInt(w.length)]);
        }
        return TextFormatter.formatText(s.toString());
    }

    public static ServerStatus.Favicon getRandomIcon() {
        return EnhancedMotd.getRandomIcon(random);
    }

    public static ServerStatus.Favicon getRandomIcon(@NotNull Random random) {
        LOGGER.info("Getting random icon");
        return icons[random.nextInt(icons.length)];
    }

    public static boolean useRandomIcons() {
        return icons.length > 0;
    }

    public static void log(String output) {
        LOGGER.info(output);
    }

    public static void loadConfigFromFile() {
        CONFIG = Config.init();
        Objects.requireNonNull(CONFIG);
        EnhancedMotd.cacheMotds();
        Objects.requireNonNull(CONFIG);
        EnhancedMotd.cacheIcons();
    }

    private static void cacheMotds() {
        motds = (String[][])EnhancedMotd.CONFIG.motds.stream().map(l -> (String[])l.toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
    }

    private static void cacheIcons() {
        ArrayList<ServerStatus.Favicon> list = new ArrayList<ServerStatus.Favicon>();
        for (String iconPath : EnhancedMotd.CONFIG.icons) {
            try {
                BufferedImage bufferedImage = null;
                if (iconPath.toLowerCase().startsWith("https://")) {
                    bufferedImage = EnhancedMotd.loadIconFromUrl(iconPath);
                } else {
                    if (iconPath.toLowerCase().startsWith("http://")) {
                        LOGGER.warn("Icon `{}` uses insecure HTTP protocol. Please use HTTPS instead. Skipping.", (Object)iconPath);
                        continue;
                    }
                    Optional<File> optional = Optional.of(new File(".", iconPath)).filter(File::isFile);
                    if (optional.isEmpty()) {
                        LOGGER.info("Icon `{}` does not exist!", (Object)iconPath);
                        continue;
                    }
                    bufferedImage = ImageIO.read(optional.get());
                }
                if (bufferedImage == null) continue;
                Preconditions.checkState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                list.add(new ServerStatus.Favicon(byteArrayOutputStream.toByteArray()));
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't load server icon from `{}`", (Object)iconPath, (Object)exception);
            }
        }
        icons = (ServerStatus.Favicon[])list.toArray(ServerStatus.Favicon[]::new);
    }

    private static BufferedImage loadIconFromUrl(String urlString) throws Exception {
        URI uri = new URI(urlString);
        if (!"https".equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("Only HTTPS URLs are allowed for security reasons");
        }
        URL url = uri.toURL();
        try (InputStream inputStream = url.openStream();){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
    }

    static {
        random = new Random();
    }
}

