/*
 * Decompiled with CFR 0.152.
 */
package lusouzadev.enhancedmotd;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class FOModVersion {
    public final int major;
    public final int minor;
    public final int patch;
    public final String suffix;

    public FOModVersion(@NotNull String version) {
        String versionCore = version;
        String versionSuffix = "";
        int plusIndex = version.indexOf(43);
        if (plusIndex != -1) {
            versionCore = version.substring(0, plusIndex);
            versionSuffix = version.substring(plusIndex);
        }
        this.suffix = versionSuffix;
        boolean index0 = false;
        int[] indexes = new int[2];
        for (int i = 0; i < versionCore.length(); ++i) {
            if (versionCore.charAt(i) != '.') continue;
            if (!index0) {
                indexes[0] = i;
                index0 = true;
                continue;
            }
            indexes[1] = i;
        }
        this.major = FOModVersion.substringToInt(versionCore, 0, indexes[0]);
        this.minor = FOModVersion.substringToInt(versionCore, indexes[0] + 1, indexes[1]);
        this.patch = FOModVersion.substringToInt(versionCore, indexes[1] + 1, versionCore.length());
    }

    private static int substringToInt(@NotNull String str, int index1, int index2) {
        return Integer.parseInt(str.substring(index1, index2));
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + this.suffix;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static FOModVersion fromString(String version) {
        return new FOModVersion(version);
    }
}

