/*
 * Decompiled with CFR 0.152.
 */
package lusouzadev.enhancedmotd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.NotNull;

public class TextFormatter {
    private static final Pattern RAINBOW_PATTERN = Pattern.compile("<rb>(.*?)</rb>");
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<gradient:#([0-9a-fA-F]{6}):#([0-9a-fA-F]{6})>(.*?)</gradient>");

    public static Component formatText(String text) {
        if (text == null || text.isEmpty()) {
            return Component.literal((String)"");
        }
        text = TextFormatter.processGradients(text);
        text = TextFormatter.convertHexColors(text);
        return TextFormatter.parseLegacyText(text);
    }

    @NotNull
    private static String processGradients(String text) {
        Matcher gradientMatcher = GRADIENT_PATTERN.matcher(text);
        StringBuilder result = new StringBuilder();
        while (gradientMatcher.find()) {
            String startHex = gradientMatcher.group(1);
            String endHex = gradientMatcher.group(2);
            String content = gradientMatcher.group(3);
            String replacement = TextFormatter.applyGradient(content, startHex, endHex);
            gradientMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        gradientMatcher.appendTail(result);
        text = result.toString();
        Matcher rainbowMatcher = RAINBOW_PATTERN.matcher(text);
        result = new StringBuilder();
        while (rainbowMatcher.find()) {
            String content = rainbowMatcher.group(1);
            String replacement = TextFormatter.applyRainbow(content);
            rainbowMatcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        rainbowMatcher.appendTail(result);
        return result.toString();
    }

    @NotNull
    private static FormattingExtraction extractFormatting(@NotNull String text) {
        StringBuilder formats = new StringBuilder();
        String cleanText = text;
        while (cleanText.length() >= 2 && cleanText.charAt(0) == '&' && "klmnor".indexOf(cleanText.charAt(1)) >= 0) {
            formats.append(cleanText, 0, 2);
            cleanText = cleanText.substring(2);
        }
        return new FormattingExtraction(formats.toString(), cleanText);
    }

    @NotNull
    private static String applyRainbow(@NotNull String text) {
        if (text.isEmpty()) {
            return text;
        }
        FormattingExtraction extraction = TextFormatter.extractFormatting(text);
        String formats = extraction.formats;
        String cleanText = extraction.cleanText;
        String[] rainbowColors = new String[]{"FF0000", "FF7F00", "FFFF00", "00FF00", "0000FF", "8B00FF"};
        StringBuilder result = new StringBuilder();
        int length = cleanText.length();
        int charIndex = 0;
        for (int i = 0; i < length; ++i) {
            char c = cleanText.charAt(i);
            if (c == ' ') {
                result.append(c);
                continue;
            }
            float position = (float)charIndex / (float)Math.max(1, TextFormatter.countNonSpace(cleanText) - 1);
            int colorIndex = (int)(position * (float)(rainbowColors.length - 1));
            float localPos = position * (float)(rainbowColors.length - 1) - (float)colorIndex;
            String color1 = rainbowColors[Math.min(colorIndex, rainbowColors.length - 1)];
            String color2 = rainbowColors[Math.min(colorIndex + 1, rainbowColors.length - 1)];
            String interpolatedColor = TextFormatter.interpolateColor(color1, color2, localPos);
            result.append("&#").append(interpolatedColor).append(formats).append(c);
            ++charIndex;
        }
        return result.toString();
    }

    @NotNull
    private static String applyGradient(@NotNull String text, String startHex, String endHex) {
        if (text.isEmpty()) {
            return text;
        }
        FormattingExtraction extraction = TextFormatter.extractFormatting(text);
        String formats = extraction.formats;
        String cleanText = extraction.cleanText;
        StringBuilder result = new StringBuilder();
        int length = cleanText.length();
        int charIndex = 0;
        for (int i = 0; i < length; ++i) {
            char c = cleanText.charAt(i);
            if (c == ' ') {
                result.append(c);
                continue;
            }
            float position = (float)charIndex / (float)Math.max(1, TextFormatter.countNonSpace(cleanText) - 1);
            String interpolatedColor = TextFormatter.interpolateColor(startHex, endHex, position);
            result.append("&#").append(interpolatedColor).append(formats).append(c);
            ++charIndex;
        }
        return result.toString();
    }

    private static int countNonSpace(@NotNull String text) {
        int count = 0;
        for (char c : text.toCharArray()) {
            if (c == ' ') continue;
            ++count;
        }
        return Math.max(1, count);
    }

    @NotNull
    private static String interpolateColor(@NotNull String hex1, @NotNull String hex2, float ratio) {
        int r1 = Integer.parseInt(hex1.substring(0, 2), 16);
        int g1 = Integer.parseInt(hex1.substring(2, 4), 16);
        int b1 = Integer.parseInt(hex1.substring(4, 6), 16);
        int r2 = Integer.parseInt(hex2.substring(0, 2), 16);
        int g2 = Integer.parseInt(hex2.substring(2, 4), 16);
        int b2 = Integer.parseInt(hex2.substring(4, 6), 16);
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return String.format("%02X%02X%02X", r, g, b);
    }

    private static String convertHexColors(String text) {
        return text;
    }

    @NotNull
    private static Component parseLegacyText(@NotNull String text) {
        MutableComponent component = Component.literal((String)"");
        StringBuilder currentText = new StringBuilder();
        Style currentStyle = Style.EMPTY;
        for (int i = 0; i < text.length(); ++i) {
            if (i < text.length() - 8 && text.charAt(i) == '&' && text.charAt(i + 1) == '#') {
                if (!currentText.isEmpty()) {
                    component.append((Component)Component.literal((String)currentText.toString()).setStyle(currentStyle));
                    currentText = new StringBuilder();
                }
                String hexColor = text.substring(i + 2, i + 8);
                try {
                    int color = Integer.parseInt(hexColor, 16);
                    currentStyle = Style.EMPTY.withColor(TextColor.fromRgb((int)color)).withBold(Boolean.valueOf(currentStyle.isBold())).withItalic(Boolean.valueOf(currentStyle.isItalic())).withUnderlined(Boolean.valueOf(currentStyle.isUnderlined())).withStrikethrough(Boolean.valueOf(currentStyle.isStrikethrough())).withObfuscated(Boolean.valueOf(currentStyle.isObfuscated()));
                    i += 7;
                }
                catch (NumberFormatException e) {
                    currentText.append(text.charAt(i));
                }
                continue;
            }
            if (i < text.length() - 1 && text.charAt(i) == '&') {
                char code = text.charAt(i + 1);
                if (!currentText.isEmpty()) {
                    component.append((Component)Component.literal((String)currentText.toString()).setStyle(currentStyle));
                    currentText = new StringBuilder();
                }
                currentStyle = TextFormatter.getStyleForCode(code, currentStyle);
                ++i;
                continue;
            }
            currentText.append(text.charAt(i));
        }
        if (!currentText.isEmpty()) {
            component.append((Component)Component.literal((String)currentText.toString()).setStyle(currentStyle));
        }
        return component;
    }

    private static Style getStyleForCode(char code, Style currentStyle) {
        return switch (code) {
            case '0' -> currentStyle.withColor(ChatFormatting.BLACK);
            case '1' -> currentStyle.withColor(ChatFormatting.DARK_BLUE);
            case '2' -> currentStyle.withColor(ChatFormatting.DARK_GREEN);
            case '3' -> currentStyle.withColor(ChatFormatting.DARK_AQUA);
            case '4' -> currentStyle.withColor(ChatFormatting.DARK_RED);
            case '5' -> currentStyle.withColor(ChatFormatting.DARK_PURPLE);
            case '6' -> currentStyle.withColor(ChatFormatting.GOLD);
            case '7' -> currentStyle.withColor(ChatFormatting.GRAY);
            case '8' -> currentStyle.withColor(ChatFormatting.DARK_GRAY);
            case '9' -> currentStyle.withColor(ChatFormatting.BLUE);
            case 'a' -> currentStyle.withColor(ChatFormatting.GREEN);
            case 'b' -> currentStyle.withColor(ChatFormatting.AQUA);
            case 'c' -> currentStyle.withColor(ChatFormatting.RED);
            case 'd' -> currentStyle.withColor(ChatFormatting.LIGHT_PURPLE);
            case 'e' -> currentStyle.withColor(ChatFormatting.YELLOW);
            case 'f' -> currentStyle.withColor(ChatFormatting.WHITE);
            case 'k' -> currentStyle.withObfuscated(Boolean.valueOf(true));
            case 'l' -> currentStyle.withBold(Boolean.valueOf(true));
            case 'm' -> currentStyle.withStrikethrough(Boolean.valueOf(true));
            case 'n' -> currentStyle.withUnderlined(Boolean.valueOf(true));
            case 'o' -> currentStyle.withItalic(Boolean.valueOf(true));
            case 'r' -> Style.EMPTY;
            default -> currentStyle;
        };
    }

    private record FormattingExtraction(String formats, String cleanText) {
    }
}

