/*
 * Decompiled with CFR 0.152.
 */
package lusouzadev.enhancedmotd.mixin;

import java.util.Optional;
import lusouzadev.enhancedmotd.EnhancedMotd;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={ServerStatusPacketListenerImpl.class})
public class StatusResponsePacketMixin {
    @Shadow
    @Final
    private ServerStatus status;

    @ModifyArg(method={"handleStatusRequest"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;send(Lnet/minecraft/network/protocol/Packet;)V"), index=0)
    private Packet<?> modifyStatusPacket(Packet<?> packet) {
        try {
            if (packet instanceof ClientboundStatusResponsePacket) {
                EnhancedMotd.LOGGER.info("StatusResponsePacketMixin is being applied!");
                ServerStatus newStatus = new ServerStatus(EnhancedMotd.getEnhancedMotd(), this.status.players(), this.status.version(), EnhancedMotd.useRandomIcons() ? Optional.of(EnhancedMotd.getRandomIcon()) : this.status.favicon(), this.status.enforcesSecureChat(), this.status.isModded());
                EnhancedMotd.LOGGER.info("Successfully modified server status with random MOTD");
                return new ClientboundStatusResponsePacket(newStatus);
            }
        }
        catch (Throwable e) {
            EnhancedMotd.LOGGER.error("Failed to modify server status packet", e);
        }
        return packet;
    }
}

