/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nesoi.aysihuniks.nclaim.NClaim;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.nandayo.dapi.Util;

public class ClaimBlockManager {
    private final Map<Material, ClaimBlockInfo> claimBlocks = new LinkedHashMap<Material, ClaimBlockInfo>();

    public ClaimBlockManager() {
        this.loadClaimBlocks();
    }

    private void loadClaimBlocks() {
        File claimBlocksFile = new File(NClaim.inst().getDataFolder(), "claim_blocks.yml");
        if (!claimBlocksFile.exists()) {
            NClaim.inst().saveResource("claim_blocks.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)claimBlocksFile);
        this.claimBlocks.clear();
        ConfigurationSection section = config.getConfigurationSection("claim_blocks");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                Material mat = Material.matchMaterial((String)key);
                if (mat == null || !mat.isBlock()) {
                    Util.log("Invalid claim block material in config: " + key);
                    continue;
                }
                ConfigurationSection entry = section.getConfigurationSection(key);
                String displayName = entry.getString("display_name", mat.name());
                double price = entry.getDouble("price", 0.0);
                List lore = entry.getStringList("lore");
                String permission = entry.getString("permission", null);
                boolean enabled = entry.getBoolean("enabled", true);
                this.claimBlocks.put(mat, new ClaimBlockInfo(mat, displayName, price, lore, permission, enabled));
            }
        }
    }

    public List<Material> getAllowedBlocks() {
        ArrayList<Material> list = new ArrayList<Material>();
        for (ClaimBlockInfo info : this.claimBlocks.values()) {
            if (!info.enabled) continue;
            list.add(info.material);
        }
        return list;
    }

    public ClaimBlockInfo getBlockInfo(Material mat) {
        return this.claimBlocks.get(mat);
    }

    public Collection<ClaimBlockInfo> getAllBlockInfos() {
        return this.claimBlocks.values();
    }

    public static class ClaimBlockInfo {
        public final Material material;
        public final String displayName;
        public final double price;
        public final List<String> lore;
        public final String permission;
        public final boolean enabled;

        public ClaimBlockInfo(Material material, String displayName, double price, List<String> lore, String permission, boolean enabled) {
            this.material = material;
            this.displayName = displayName;
            this.price = price;
            this.lore = lore;
            this.permission = permission;
            this.enabled = enabled;
        }
    }
}

