/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.color;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import org.bukkit.Color;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DColor {
    public static final char LEGACY_COLOR_CHAR = '\u00a7';
    public static final char LEGACY_ALTERNATIVE_CHAR = '&';
    public static final String LEGACY_ALL_CODES = "0123456789ABCDEFKLMNORX";
    public static final String LEGACY_COLOR_CODES = "0123456789ABCDEF";
    public static final String LEGACY_DECORATION_CODES = "KLMNOR";
    public static final char LEGACY_HEX_CHAR = 'X';
    private static final Map<String, DColor> LEGACY_CODE_MAP = new HashMap<String, DColor>();
    private static final Map<String, DColor> MINIMESSAGE_FORMAT_MAP = new HashMap<String, DColor>();
    public static final DColor AQUA = new DColor(Color.fromRGB((int)0x55FFFF), "b", "<aqua>");
    public static final DColor BLACK = new DColor(Color.fromRGB((int)0), "0", "<black>");
    public static final DColor BLUE = new DColor(Color.fromRGB((int)0x5555FF), "9", "<blue>");
    public static final DColor DARK_AQUA = new DColor(Color.fromRGB((int)43690), "3", "<dark_aqua>");
    public static final DColor DARK_BLUE = new DColor(Color.fromRGB((int)170), "1", "<dark_blue>");
    public static final DColor DARK_GRAY = new DColor(Color.fromRGB((int)0x555555), "8", "<dark_gray>");
    public static final DColor DARK_GREEN = new DColor(Color.fromRGB((int)43520), "2", "<dark_green>");
    public static final DColor DARK_PURPLE = new DColor(Color.fromRGB((int)0xAA00AA), "5", "<dark_purple>");
    public static final DColor DARK_RED = new DColor(Color.fromRGB((int)0xAA0000), "4", "<dark_red>");
    public static final DColor GRAY = new DColor(Color.fromRGB((int)0xAAAAAA), "7", "<gray>");
    public static final DColor GOLD = new DColor(Color.fromRGB((int)0xFFAA00), "6", "<gold>");
    public static final DColor GREEN = new DColor(Color.fromRGB((int)0x55FF55), "a", "<green>");
    public static final DColor LIGHT_PURPLE = new DColor(Color.fromRGB((int)0xFF55FF), "d", "<light purple>");
    public static final DColor RED = new DColor(Color.fromRGB((int)0xFF5555), "c", "<red>");
    public static final DColor WHITE = new DColor(Color.fromRGB((int)0xFFFFFF), "f", "<white>");
    public static final DColor YELLOW = new DColor(Color.fromRGB((int)0xFFFF55), "e", "<yellow>");
    public static final DColor BOLD = new DColor("l", "<bold>");
    public static final DColor ITALIC = new DColor("o", "<italic>");
    public static final DColor OBFUSCATED = new DColor("k", "<obfuscated>");
    public static final DColor RESET = new DColor("r", "<reset>");
    public static final DColor STRIKETHROUGH = new DColor("m", "<strikethrough>");
    public static final DColor UNDERLINED = new DColor("n", "<underlined>");
    private final Color color;
    private final String legacyCode;
    private final String miniMessageFormat;

    private DColor(Color color, String legacyCode, String miniMessageFormat) {
        this.color = color;
        this.legacyCode = legacyCode;
        this.miniMessageFormat = miniMessageFormat;
        LEGACY_CODE_MAP.put(legacyCode, this);
        MINIMESSAGE_FORMAT_MAP.put(miniMessageFormat, this);
    }

    private DColor(String legacyCode, String miniMessageFormat) {
        this(null, legacyCode, miniMessageFormat);
    }

    public DColor(String hexString) {
        Validate.validate(hexString.length() == 7 && hexString.charAt(0) == '#', "Invalid hex string.");
        int rgb = Validate.validateReturn(() -> Integer.parseInt(hexString.substring(1), 16), "Invalid hex format.");
        this.color = Color.fromRGB((int)rgb);
        this.legacyCode = "X" + hexString;
        this.miniMessageFormat = "<#" + hexString + ">";
    }

    public DColor(Color color) {
        this.color = color;
        String hexString = Validate.validateReturn(() -> String.format("%06X", color.asRGB()), "Invalid hex legacy color.");
        this.legacyCode = "X" + hexString;
        this.miniMessageFormat = "<#" + hexString + ">";
    }

    public DColor(int rgb) {
        this(Color.fromRGB((int)rgb));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DColor dColor = (DColor)o;
        return Objects.equals(this.legacyCode, dColor.legacyCode) && Objects.equals(this.color, dColor.color) && Objects.equals(this.miniMessageFormat, dColor.miniMessageFormat);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.legacyCode, this.miniMessageFormat);
    }

    public static DColor getByLegacyCode(String legacyCode) {
        return LEGACY_CODE_MAP.get(legacyCode);
    }

    public static DColor getByMiniMessageFormat(String miniMessageFormat) {
        Validate.notNull(miniMessageFormat, "miniMessage format cannot be null!");
        return MINIMESSAGE_FORMAT_MAP.get(miniMessageFormat);
    }

    @Generated
    public Color getColor() {
        return this.color;
    }

    @Generated
    public String getLegacyCode() {
        return this.legacyCode;
    }

    @Generated
    public String getMiniMessageFormat() {
        return this.miniMessageFormat;
    }
}

