/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.model;

import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.service.AdventureService;
import nesoi.aysihuniks.libs.dapi.util.ColorizeType;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class MiniString {
    private static final String ITALIC_FALSE = "<!italic>";
    @NotNull
    private final String rawText;

    public MiniString(String text) {
        Validate.validate(text != null, "MiniString text cannot be null!");
        this.rawText = text;
    }

    public MiniString(Component component) {
        AdventureService.validateMiniMessage();
        Validate.validate(component != null, "MiniString component cannot be null!");
        this.rawText = (String)AdventureService.getMiniMessage().serialize(component);
    }

    @NotNull
    public MiniString copy() {
        return new MiniString(this.rawText);
    }

    @NotNull
    public MiniString replace(String key, String value) {
        return new MiniString(this.rawText.replace(key, value));
    }

    @NotNull
    public MiniString colorize(ColorizeType colorizeType) {
        Validate.validate(colorizeType != null, "ColorizeType cannot be null!");
        return new MiniString(colorizeType.apply(this.rawText));
    }

    @NotNull
    public Component asComponent() {
        AdventureService.validateMiniMessage();
        return AdventureService.getMiniMessage().deserialize((Object)(ITALIC_FALSE + this.rawText));
    }

    @NotNull
    @Generated
    public String getRawText() {
        return this.rawText;
    }
}

