/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.libs.dapi.object.DEntityType;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.api.events.ClaimEnterEvent;
import nesoi.aysihuniks.nclaim.api.events.ClaimLeaveEvent;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.service.ClaimCoopManager;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.utils.LangManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.projectiles.ProjectileSource;

public class ClaimManager
implements Listener {
    private final NClaim plugin;
    private final ClaimCoopManager coopManager;
    private final Map<UUID, Long> messageCooldown = new HashMap<UUID, Long>();

    private void sendCooldownMessage(Player player, String message) {
        long lastMessageTime;
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastMessageTime = this.messageCooldown.getOrDefault(playerUUID, 0L).longValue()) >= 15000L) {
            ChannelType.CHAT.send((CommandSender)player, message);
            this.messageCooldown.put(playerUUID, currentTime);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Chunk fromChunk = event.getFrom().getChunk();
        if (event.getTo() == null) {
            return;
        }
        Chunk toChunk = event.getTo().getChunk();
        if (fromChunk.equals((Object)toChunk)) {
            return;
        }
        if (NClaim.inst().getNconfig().getBlacklistedWorlds().contains(player.getWorld().getName())) {
            return;
        }
        if (NClaim.inst().isWorldGuardEnabled()) {
            RegionManager regions;
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            World world = event.getTo().getWorld();
            if (world != null && (regions = container.get(BukkitAdapter.adapt((World)world))) != null) {
                ApplicableRegionSet regionSet = regions.getApplicableRegions(BukkitAdapter.asBlockVector((Location)event.getTo()));
                for (ProtectedRegion region : regionSet) {
                    if (!NClaim.inst().getNconfig().getBlacklistedRegions().contains(region.getId())) continue;
                    return;
                }
            }
        }
        Claim fromClaim = Claim.getClaim(fromChunk);
        Claim toClaim = Claim.getClaim(toChunk);
        if (fromClaim != null && !fromClaim.equals(toClaim)) {
            ClaimLeaveEvent leaveEvent = new ClaimLeaveEvent(player, fromClaim);
            Bukkit.getPluginManager().callEvent((Event)leaveEvent);
            LangManager.sendSortedMessage(player, this.plugin.getLangManager().getString("move.unclaimed_chunk"));
        }
        if (!(toClaim == null || fromClaim != null && fromClaim.equals(toClaim))) {
            ClaimEnterEvent enterEvent = new ClaimEnterEvent(toClaim, player);
            Bukkit.getPluginManager().callEvent((Event)enterEvent);
            boolean isPvpEnabled = NClaim.inst().getClaimSettingsManager().isSettingEnabled(toClaim, Setting.CLAIM_PVP);
            String pvpStatus = this.plugin.getLangManager().getString(isPvpEnabled ? "move.pvp_enabled" : "move.pvp_disabled");
            OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)toClaim.getOwner());
            LangManager.sendSortedMessage(player, this.plugin.getLangManager().getString("move.claimed_chunk").replace("{owner}", owner.getName() != null ? owner.getName() : "Unknown").replace("{pvp_status}", pvpStatus));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Location explodeLocation = event.getLocation();
        Claim explodeClaim = Claim.getClaim(explodeLocation.getChunk());
        Entity explodingEntity = event.getEntity();
        boolean isTNT = explodingEntity.getType() == NClaim.getEntityType(DEntityType.TNT, DEntityType.PRIMED_TNT) || explodingEntity.getType() == NClaim.getEntityType(DEntityType.MINECART_TNT, DEntityType.TNT_MINECART);
        boolean isCreeper = explodingEntity.getType() == EntityType.CREEPER;
        ArrayList<Block> blocksToRemove = new ArrayList<Block>();
        for (Block block : event.blockList()) {
            Claim blockClaim = Claim.getClaim(block.getChunk());
            if (blockClaim == null) continue;
            if (isTNT && !this.plugin.getClaimSettingsManager().isSettingEnabled(blockClaim, Setting.TNT_DAMAGE)) {
                blocksToRemove.add(block);
                continue;
            }
            if (!isCreeper || this.plugin.getClaimSettingsManager().isSettingEnabled(blockClaim, Setting.CREEPER_DAMAGE)) continue;
            blocksToRemove.add(block);
        }
        event.blockList().removeAll(blocksToRemove);
        if (explodeClaim != null && (isTNT && !this.plugin.getClaimSettingsManager().isSettingEnabled(explodeClaim, Setting.TNT_DAMAGE) || isCreeper && !this.plugin.getClaimSettingsManager().isSettingEnabled(explodeClaim, Setting.CREEPER_DAMAGE))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        Player player = event.getPlayer();
        Claim targetClaim = Claim.getClaim(event.getTo().getChunk());
        if (targetClaim != null && !this.coopManager.hasPermission(player, targetClaim, Permission.USE_ENDER_PEARL)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Projectile projectile;
        Entity remover = event.getRemover();
        Hanging hanging = event.getEntity();
        if (!(hanging instanceof ItemFrame) && !(hanging instanceof Painting)) {
            return;
        }
        Player player = null;
        if (remover instanceof Player) {
            player = (Player)remover;
        } else if (remover instanceof Projectile && (projectile = (Projectile)remover).getShooter() instanceof Player) {
            player = (Player)projectile.getShooter();
        }
        if (player != null) {
            Claim claim = Claim.getClaim(hanging.getLocation().getChunk());
            if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.interact")) {
                return;
            }
            Permission perm = Permission.INTERACT_ITEM_FRAME;
            if (hanging instanceof Painting) {
                perm = Permission.PLACE_BLOCKS;
            }
            boolean hasPerm = this.coopManager.hasPermission(player, claim, perm);
            if (claim != null && !hasPerm) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity damager;
        boolean mobAttackingEnabled;
        Claim claim;
        Player player;
        if (event.getEntity() instanceof Player) {
            if (event.getDamager().hasPermission("nclaim.bypass.*") || event.getDamager().hasPermission("nclaim.bypass.pvp")) {
                return;
            }
            Player damaged = (Player)event.getEntity();
            Player damager2 = null;
            if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
                damager2 = (Player)((Projectile)event.getDamager()).getShooter();
            } else if (event.getDamager() instanceof Player) {
                damager2 = (Player)event.getDamager();
            }
            if (damager2 != null) {
                Claim damagedClaim = Claim.getClaim(damaged.getLocation().getChunk());
                Claim damagerClaim = Claim.getClaim(damager2.getLocation().getChunk());
                if (damagedClaim != null && !this.plugin.getClaimSettingsManager().isSettingEnabled(damagedClaim, Setting.CLAIM_PVP)) {
                    event.setCancelled(true);
                    return;
                }
                if (damagerClaim != null && !this.plugin.getClaimSettingsManager().isSettingEnabled(damagerClaim, Setting.CLAIM_PVP)) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (event.getEntity() instanceof ItemFrame || event.getEntity() instanceof Painting || event.getEntity() instanceof ArmorStand) {
            Projectile projectile;
            player = null;
            if (event.getDamager() instanceof Player) {
                player = (Player)event.getDamager();
            } else if (event.getDamager() instanceof Projectile && (projectile = (Projectile)event.getDamager()).getShooter() instanceof Player) {
                player = (Player)projectile.getShooter();
            }
            if (player != null && !player.hasPermission("nclaim.bypass.*") && !player.hasPermission("nclaim.bypass.interact")) {
                claim = Claim.getClaim(event.getEntity().getLocation().getChunk());
                Permission perm = Permission.INTERACT_ITEM_FRAME;
                if (event.getEntity() instanceof Painting) {
                    perm = Permission.PLACE_BLOCKS;
                }
                if (event.getEntity() instanceof ArmorStand) {
                    perm = Permission.INTERACT_ARMOR_STAND;
                }
                if (claim != null && !this.coopManager.hasPermission(player, claim, perm)) {
                    event.setCancelled(true);
                    this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
                    return;
                }
            }
        }
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Monster && (claim = Claim.getClaim((player = (Player)event.getEntity()).getLocation().getChunk())) != null && !(mobAttackingEnabled = this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.MOB_ATTACKING)) && !claim.getOwner().equals(player.getUniqueId()) && !claim.getCoopPlayers().contains(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (event.getEntity() instanceof Monster && event.getDamager() instanceof Player) {
            damager = (Player)event.getDamager();
            if (damager.hasPermission("nclaim.bypass.*") || damager.hasPermission("nclaim.bypass.mob_attacking")) {
                return;
            }
            claim = Claim.getClaim(event.getEntity().getLocation().getChunk());
            if (!(claim == null || (mobAttackingEnabled = this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.MOB_ATTACKING)) || claim.getOwner().equals(damager.getUniqueId()) || claim.getCoopPlayers().contains(damager.getUniqueId()))) {
                event.setCancelled(true);
                return;
            }
        }
        if (event.getEntity() instanceof LivingEntity) {
            damager = event.getDamager();
            claim = Claim.getClaim(event.getEntity().getLocation().getChunk());
            if (claim != null) {
                if ((damager instanceof TNTPrimed || damager instanceof ExplosiveMinecart) && !this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.TNT_DAMAGE)) {
                    event.setCancelled(true);
                } else if (damager instanceof Creeper && !this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.CREEPER_DAMAGE)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void windCharge(ExplosionPrimeEvent event) {
        Player player;
        Projectile projectile;
        ProjectileSource source;
        Claim claim;
        EntityType type = event.getEntity().getType();
        if ((type == EntityType.WIND_CHARGE || type == EntityType.BREEZE_WIND_CHARGE) && (claim = Claim.getClaim(event.getEntity().getLocation().getChunk())) != null && event.getEntity() instanceof Projectile && (source = (projectile = (Projectile)event.getEntity()).getShooter()) instanceof Player && !this.coopManager.hasPermission(player = (Player)source, claim, Permission.PLACE_BLOCKS)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileHit(ProjectileHitEvent event) {
        Claim claim;
        Block hitBlock;
        Projectile projectile = event.getEntity();
        if (projectile.getType().name().equalsIgnoreCase("WIND_CHARGE") && (hitBlock = event.getHitBlock()) != null && (claim = Claim.getClaim(hitBlock.getChunk())) != null && projectile.getShooter() instanceof Player) {
            Player player = (Player)projectile.getShooter();
            Material type = hitBlock.getType();
            if ((Tag.BUTTONS.isTagged((Keyed)type) || Tag.PRESSURE_PLATES.isTagged((Keyed)type) || Tag.DOORS.isTagged((Keyed)type) || Tag.TRAPDOORS.isTagged((Keyed)type) || Tag.FENCE_GATES.isTagged((Keyed)type)) && !this.coopManager.hasPermission(player, claim, Permission.USE_DOORS)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            }
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Claim claim = Claim.getClaim(event.getLocation().getChunk());
        if (claim == null) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL) {
            if (event.getEntity() instanceof Monster) {
                if (!this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.MONSTER_SPAWNING)) {
                    event.setCancelled(true);
                }
            } else if (!this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.ANIMAL_SPAWNING)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Claim claim = Claim.getClaim(block.getChunk());
        if (claim != null && block.getType() == claim.getClaimBlockType() && block.getLocation().equals((Object)claim.getClaimBlockLocation()) && !player.isSneaking()) {
            event.setCancelled(true);
        }
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.break")) {
            return;
        }
        if (claim != null) {
            if (block.getType() == Material.SPAWNER) {
                if (!this.coopManager.hasPermission(player, claim, Permission.BREAK_SPAWNER)) {
                    event.setCancelled(true);
                    this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
                }
            } else if (!this.coopManager.hasPermission(player, claim, Permission.BREAK_BLOCKS)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            }
            if (block.getType() == Material.ITEM_FRAME) {
                if (!this.coopManager.hasPermission(player, claim, Permission.INTERACT_ITEM_FRAME)) {
                    event.setCancelled(true);
                    this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
                }
            } else if (block.getType() == Material.PAINTING) {
                if (!this.coopManager.hasPermission(player, claim, Permission.PLACE_BLOCKS)) {
                    event.setCancelled(true);
                    this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
                }
            } else if (block.getType() == Material.GLOW_ITEM_FRAME && !this.coopManager.hasPermission(player, claim, Permission.INTERACT_ITEM_FRAME)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Claim claim = Claim.getClaim(block.getChunk());
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.place")) {
            return;
        }
        if (claim != null) {
            if (block.getType() == Material.SPAWNER) {
                if (!this.coopManager.hasPermission(player, claim, Permission.PLACE_SPAWNER)) {
                    event.setCancelled(true);
                    this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
                }
            } else if (!this.coopManager.hasPermission(player, claim, Permission.PLACE_BLOCKS)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Claim claim = Claim.getClaim(block.getChunk());
        if (claim == null) {
            return;
        }
        if (block.getType() == claim.getClaimBlockType() && claim.getClaimBlockLocation().equals((Object)block.getLocation())) {
            if (this.coopManager.isClaimOwner(claim, player) || this.coopManager.hasPermission(player, claim, Permission.OPEN_CLAIM_MENU)) {
                new ClaimManagementMenu(player, claim, false);
            } else if (player.hasPermission("nclaim.admin") && player.isSneaking() && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                new ClaimManagementMenu(player, claim, true);
            }
            return;
        }
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.interact")) {
            return;
        }
        Material type = block.getType();
        if (type == Material.SPAWNER && !this.coopManager.hasPermission(player, claim, Permission.PLACE_SPAWNER) && !this.coopManager.hasPermission(player, claim, Permission.BREAK_SPAWNER)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.CHEST && !this.coopManager.hasPermission(player, claim, Permission.USE_CHEST)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (!(type != Material.FURNACE && type != Material.BLAST_FURNACE && type != Material.SMOKER || this.coopManager.hasPermission(player, claim, Permission.USE_FURNACE))) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.TRAPPED_CHEST && !this.coopManager.hasPermission(player, claim, Permission.USE_TRAPPED_CHEST)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.BARREL && !this.coopManager.hasPermission(player, claim, Permission.USE_BARREL)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (Tag.SHULKER_BOXES.isTagged((Keyed)type) && !this.coopManager.hasPermission(player, claim, Permission.USE_SHULKER)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.HOPPER && !this.coopManager.hasPermission(player, claim, Permission.USE_HOPPER)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.DISPENSER && !this.coopManager.hasPermission(player, claim, Permission.USE_DISPENSER)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.DROPPER && !this.coopManager.hasPermission(player, claim, Permission.USE_DROPPER)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.REPEATER && !this.coopManager.hasPermission(player, claim, Permission.USE_REPEATER)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.COMPARATOR && !this.coopManager.hasPermission(player, claim, Permission.USE_COMPARATOR)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (Tag.BUTTONS.isTagged((Keyed)type) && !this.coopManager.hasPermission(player, claim, Permission.USE_BUTTONS)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (Tag.PRESSURE_PLATES.isTagged((Keyed)type) && !this.coopManager.hasPermission(player, claim, Permission.USE_PRESSURE_PLATES)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.LEVER && !this.coopManager.hasPermission(player, claim, Permission.USE_LEVERS)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (Tag.DOORS.isTagged((Keyed)type) && !this.coopManager.hasPermission(player, claim, Permission.USE_DOORS)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (Tag.TRAPDOORS.isTagged((Keyed)type) && !this.coopManager.hasPermission(player, claim, Permission.USE_TRAPDOORS)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (Tag.FENCE_GATES.isTagged((Keyed)type) && !this.coopManager.hasPermission(player, claim, Permission.USE_GATES)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.CRAFTING_TABLE && !this.coopManager.hasPermission(player, claim, Permission.USE_CRAFTING)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.ENCHANTING_TABLE && !this.coopManager.hasPermission(player, claim, Permission.USE_ENCHANTING)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (Tag.ANVIL.isTagged((Keyed)type) && !this.coopManager.hasPermission(player, claim, Permission.USE_ANVIL)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.GRINDSTONE && !this.coopManager.hasPermission(player, claim, Permission.USE_GRINDSTONE)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.STONECUTTER && !this.coopManager.hasPermission(player, claim, Permission.USE_STONECUTTER)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.LOOM && !this.coopManager.hasPermission(player, claim, Permission.USE_LOOM)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.SMITHING_TABLE && !this.coopManager.hasPermission(player, claim, Permission.USE_SMITHING)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.CARTOGRAPHY_TABLE && !this.coopManager.hasPermission(player, claim, Permission.USE_CARTOGRAPHY)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.BREWING_STAND && !this.coopManager.hasPermission(player, claim, Permission.USE_BREWING)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.BELL && !this.coopManager.hasPermission(player, claim, Permission.USE_BELL)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.BEACON && !this.coopManager.hasPermission(player, claim, Permission.USE_BEACON)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.JUKEBOX && !this.coopManager.hasPermission(player, claim, Permission.USE_JUKEBOX)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.NOTE_BLOCK && !this.coopManager.hasPermission(player, claim, Permission.USE_NOTEBLOCK)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.CAMPFIRE && !this.coopManager.hasPermission(player, claim, Permission.USE_CAMPFIRE)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (type == Material.SOUL_CAMPFIRE && !this.coopManager.hasPermission(player, claim, Permission.USE_SOUL_CAMPFIRE)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (Tag.BEDS.isTagged((Keyed)type) && !this.coopManager.hasPermission(player, claim, Permission.USE_BED)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material handType = player.getInventory().getItemInMainHand().getType();
            if (!(handType != Material.ITEM_FRAME && handType != Material.GLOW_ITEM_FRAME || this.coopManager.hasPermission(player, claim, Permission.INTERACT_ITEM_FRAME))) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
                return;
            }
            if (handType == Material.PAINTING && !this.coopManager.hasPermission(player, claim, Permission.PLACE_BLOCKS)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
                return;
            }
            if (handType == Material.ARMOR_STAND && !this.coopManager.hasPermission(player, claim, Permission.INTERACT_ARMOR_STAND)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
                return;
            }
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        Claim claim = Claim.getClaim(entity.getLocation().getChunk());
        if (claim == null) {
            return;
        }
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.interact")) {
            return;
        }
        if (entity instanceof Villager && !this.coopManager.hasPermission(player, claim, Permission.INTERACT_VILLAGER)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
        }
        if (entity instanceof ItemFrame && !this.coopManager.hasPermission(player, claim, Permission.INTERACT_ITEM_FRAME)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
        }
    }

    @EventHandler
    public void onArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ArmorStand armorStand = event.getRightClicked();
        Claim claim = Claim.getClaim(armorStand.getLocation().getChunk());
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.interact")) {
            return;
        }
        if (claim != null && !this.coopManager.hasPermission(player, claim, Permission.INTERACT_ARMOR_STAND)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
        }
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent event) {
        Entity entity = event.getEntered();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Vehicle vehicle = event.getVehicle();
        Claim claim = Claim.getClaim(vehicle.getLocation().getChunk());
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.interact")) {
            return;
        }
        if (claim != null && !this.coopManager.hasPermission(player, claim, Permission.RIDE_ENTITIES)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
        }
    }

    @EventHandler
    public void onPlayerLeashEntity(PlayerLeashEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        Claim claim = Claim.getClaim(entity.getLocation().getChunk());
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.interact")) {
            return;
        }
        if (claim != null && !this.coopManager.hasPermission(player, claim, Permission.LEASH_MOBS)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
        }
    }

    @EventHandler
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Claim claim = Claim.getClaim(block.getChunk());
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.interact")) {
            return;
        }
        if (claim != null) {
            if (event.getBucket() == Material.WATER_BUCKET && !this.coopManager.hasPermission(player, claim, Permission.TAKE_WATER)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            } else if (event.getBucket() == Material.LAVA_BUCKET && !this.coopManager.hasPermission(player, claim, Permission.TAKE_LAVA)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            }
        }
    }

    @EventHandler
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Claim claim = Claim.getClaim(block.getChunk());
        if (player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.interact")) {
            return;
        }
        if (claim != null) {
            if (event.getBucket() == Material.WATER_BUCKET && !this.coopManager.hasPermission(player, claim, Permission.PLACE_WATER)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            } else if (event.getBucket() == Material.LAVA_BUCKET && !this.coopManager.hasPermission(player, claim, Permission.PLACE_LAVA)) {
                event.setCancelled(true);
                this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            }
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block fromBlock = event.getBlock();
        Block toBlock = event.getToBlock();
        if (fromBlock.getType() != Material.WATER && fromBlock.getType() != Material.LAVA) {
            return;
        }
        Claim fromClaim = Claim.getClaim(fromBlock.getChunk());
        Claim toClaim = Claim.getClaim(toBlock.getChunk());
        if (fromClaim == null && toClaim != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRedstoneUpdate(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        Claim sourceClaim = Claim.getClaim(block.getChunk());
        for (BlockFace face : BlockFace.values()) {
            Block relative = block.getRelative(face);
            Claim targetClaim = Claim.getClaim(relative.getChunk());
            if (targetClaim == null || sourceClaim == null || targetClaim.getOwner().equals(sourceClaim.getOwner()) || targetClaim.getCoopPlayers().contains(sourceClaim.getOwner())) continue;
            event.setNewCurrent(event.getOldCurrent());
            return;
        }
    }

    @Generated
    public ClaimManager(NClaim plugin, ClaimCoopManager coopManager) {
        this.plugin = plugin;
        this.coopManager = coopManager;
    }
}

