/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.utils;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.libs.dapi.util.HexUtil;
import nesoi.aysihuniks.libs.dapi.util.Util;
import nesoi.aysihuniks.nclaim.NClaim;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LangManager {
    @NotNull
    private final NClaim plugin;
    private final File folder;
    public final List<String> REGISTERED_LANGUAGES = new ArrayList<String>();
    private final List<String> DEFAULT_LANGUAGES = Arrays.asList("en-US", "tr-TR", "fr-FR");
    private final String DEFAULT_LANGUAGE = "en-US";
    private FileConfiguration DEFAULT_LANGUAGE_CONFIG;
    private FileConfiguration SELECTED_LANGUAGE_CONFIG;

    public LangManager(@NotNull NClaim plugin, @NotNull String fileName) {
        this.plugin = plugin;
        this.folder = new File(plugin.getDataFolder(), "lang");
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        this.loadDefaultFiles();
        this.loadFiles(fileName);
    }

    private void loadFiles(@NotNull String searchingFor) {
        File[] files = this.folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName().substring(0, file.getName().length() - 4);
                this.REGISTERED_LANGUAGES.add(fileName);
                if (fileName.equals(searchingFor)) {
                    Object object = this.SELECTED_LANGUAGE_CONFIG = this.DEFAULT_LANGUAGES.contains(fileName) ? this.updateLanguage(fileName) : YamlConfiguration.loadConfiguration((File)file);
                }
                if (!fileName.equals("en-US")) continue;
                this.DEFAULT_LANGUAGE_CONFIG = this.updateLanguage(fileName);
            }
        }
        if (this.SELECTED_LANGUAGE_CONFIG == null) {
            this.SELECTED_LANGUAGE_CONFIG = this.DEFAULT_LANGUAGE_CONFIG;
            Util.log("&cLanguage " + searchingFor + " was not found. Using default language.");
        }
    }

    private void loadDefaultFiles() {
        for (String fileName : this.DEFAULT_LANGUAGES) {
            File file = new File(this.folder, fileName + ".yml");
            if (file.exists() || this.plugin.getResource("lang/" + fileName + ".yml") == null) continue;
            this.plugin.saveResource("lang/" + fileName + ".yml", false);
        }
    }

    public FileConfiguration updateLanguage(@NotNull String languageName) {
        File file = new File(this.folder, languageName + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (this.compareVersions((FileConfiguration)config)) {
            return config;
        }
        FileConfiguration defConfig = this.getSourceConfiguration(languageName);
        if (defConfig == null) {
            return config;
        }
        this.saveBackupConfig(languageName, (FileConfiguration)config);
        for (String key : defConfig.getKeys(true)) {
            if (defConfig.isConfigurationSection(key) || !config.contains(key)) continue;
            defConfig.set(key, config.get(key));
        }
        defConfig.set("lang_version", (Object)this.plugin.getDescription().getVersion());
        config = defConfig;
        try {
            config.save(new File(this.folder, languageName + ".yml"));
            Util.log("&aUpdated language file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save updated language file. " + e.getMessage());
        }
        return config;
    }

    private boolean compareVersions(@NotNull FileConfiguration config) {
        String version = this.plugin.getDescription().getVersion();
        String configVersion = config.getString("lang_version", "0");
        return version.equals(configVersion);
    }

    private FileConfiguration getSourceConfiguration(@NotNull String languageName) {
        InputStream defStream = this.plugin.getResource("lang/" + languageName + ".yml");
        if (defStream == null) {
            Util.log("&cDefault '" + languageName + ".yml' was not found in plugin resources.");
            return null;
        }
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
    }

    private void saveBackupConfig(@NotNull String languageName, @NotNull FileConfiguration config) {
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        File backupFile = new File(backupDir, "lang_" + languageName + "_" + date + ".yml");
        try {
            config.save(backupFile);
            Util.log("&aBacked up old language file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save old language backup file. ");
            e.printStackTrace();
        }
    }

    public static void sendSortedMessage(@NotNull Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String[] parts = msg.split("=");
        if (parts.length < 2) {
            ChannelType.CHAT.send((CommandSender)player, msg);
        }
        switch (parts[0]) {
            case "CHAT": {
                ChannelType.CHAT.send((CommandSender)player, parts[1]);
                break;
            }
            case "ACTION_BAR": {
                ChannelType.ACTION_BAR.send((CommandSender)player, parts[1]);
                break;
            }
            case "TITLE": {
                ChannelType.TITLE.send((CommandSender)player, parts[1]);
            }
        }
    }

    @Nullable
    public ConfigurationSection getSection(@NotNull String path) {
        ConfigurationSection section = this.SELECTED_LANGUAGE_CONFIG.getConfigurationSection(path);
        if (section != null) {
            return section;
        }
        return this.DEFAULT_LANGUAGE_CONFIG.getConfigurationSection(path);
    }

    @NotNull
    public String getString(@NotNull String path) {
        String str;
        String string = str = this.SELECTED_LANGUAGE_CONFIG.contains(path) ? this.SELECTED_LANGUAGE_CONFIG.getString(path) : this.DEFAULT_LANGUAGE_CONFIG.getString(path);
        if (str == null) {
            Util.log("&cNull message at path '" + path + "'");
            return "";
        }
        String prefix = NClaim.inst().getConfigManager().getString("prefix", "&8[<#fa8443>NClaim&8]&r");
        return HexUtil.parse(str.replace("{prefix}", prefix));
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        List list = this.SELECTED_LANGUAGE_CONFIG.contains(path) ? this.SELECTED_LANGUAGE_CONFIG.getStringList(path) : this.DEFAULT_LANGUAGE_CONFIG.getStringList(path);
        String prefix = NClaim.inst().getConfigManager().getString("prefix", "&8[<#fa8443>NClaim&8]&r");
        return list.stream().map(str -> HexUtil.parse(str.replace("{prefix}", prefix))).collect(Collectors.toList());
    }

    @NotNull
    public Boolean getBoolean(@NotNull String path) {
        return this.SELECTED_LANGUAGE_CONFIG.contains(path) ? this.SELECTED_LANGUAGE_CONFIG.getBoolean(path) : this.DEFAULT_LANGUAGE_CONFIG.getBoolean(path);
    }

    @NotNull
    public String getString(@Nullable ConfigurationSection section, @NotNull String subPath) {
        String currentPath = section == null ? "" : section.getCurrentPath();
        return this.getString(currentPath + "." + subPath);
    }

    @NotNull
    public List<String> getStringList(@Nullable ConfigurationSection section, @NotNull String subPath) {
        String currentPath = section == null ? "" : section.getCurrentPath();
        return this.getStringList(currentPath + "." + subPath);
    }

    @NotNull
    public Boolean getBoolean(@Nullable ConfigurationSection section, @NotNull String subPath) {
        String currentPath = section == null ? "" : section.getCurrentPath();
        return this.getBoolean(currentPath + "." + subPath);
    }
}

