/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.anvilmenu.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.jetbrains.annotations.NotNull;

public final class HexUtil {
    private static final Pattern COLORIZE_PATTERN = Pattern.compile("<(#[0-9A-F]{6}|aqua|black|blue|bold|dark_(aqua|blue|gray|green|purple|red)|gray|gold|green|italic|light_purple|obfuscated|red|reset|strikethrough|underline|white|yellow)>", 2);
    private static final Pattern LEGACY_COLOR_CODE_PATTERN = Pattern.compile("\u00a7([0-9A-FK-OR])", 2);
    private static final Pattern LEGACY_HEX_COLOR_PATTERN = Pattern.compile("\u00a7x(\u00a7[0-9A-F]){6}", 2);

    @NotNull
    public static String colorize(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Matcher matcher = COLORIZE_PATTERN.matcher(text);
        while (matcher.find()) {
            try {
                String original = matcher.group();
                String hex = matcher.group(1);
                ChatColor chatColor = ChatColor.of((String)hex);
                if (chatColor == null) continue;
                text = text.replace(original, chatColor.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    @NotNull
    public static String colorToMiniMessage(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        text = HexUtil.legacyHexToMiniMessage(text);
        text = HexUtil.legacyToMiniMessage(text);
        return text;
    }

    @NotNull
    public static String legacyHexToMiniMessage(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Matcher matcher = LEGACY_HEX_COLOR_PATTERN.matcher(text);
        while (matcher.find()) {
            String original = matcher.group();
            String hex = original.replace("\u00a7", "").substring(1);
            text = text.replace(original, "<#" + hex + ">");
        }
        return text;
    }

    @NotNull
    public static String legacyToMiniMessage(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        Matcher matcher = LEGACY_COLOR_CODE_PATTERN.matcher(text);
        while (matcher.find()) {
            String original = matcher.group();
            char code = matcher.group(1).charAt(0);
            ChatColor chatColor = ChatColor.getByChar((char)code);
            if (chatColor == null) continue;
            String name = chatColor.getName().equals("underline") ? "underlined" : chatColor.getName();
            text = text.replace(original, "<" + name + ">");
        }
        return text;
    }
}

