/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.Set;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.coop.CoopListMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimSettingsMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.LandExpansionMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ManageClaimBlockMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.TimeManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.object.DMaterial;

public class ClaimManagementMenu
extends BaseMenu {
    @NotNull
    private final Claim claim;
    private final Player player;

    public ClaimManagementMenu(Player player, @NotNull Claim claim) {
        super("claim_management_menu");
        this.claim = claim;
        this.player = player;
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_3_ROWS, this.getString("title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRASS_BLOCK).name(ClaimManagementMenu.this.getString("expand.display_name")).lore(ClaimManagementMenu.this.getStringList("expand.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new LandExpansionMenu(player, ClaimManagementMenu.this.claim, false);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{11});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name(ClaimManagementMenu.this.getString("time.display_name")).lore(ClaimManagementMenu.this.getStringList("time.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new TimeManagementMenu(player, 0, 0, 0, 0, ClaimManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(NClaim.inst().getHeadManager().createHead((OfflinePlayer)ClaimManagementMenu.this.player)).name(ClaimManagementMenu.this.getString("coop.display_name")).lore(ClaimManagementMenu.this.getStringList("coop.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new CoopListMenu(player, ClaimManagementMenu.this.claim, false);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.END_CRYSTAL).name(ClaimManagementMenu.this.getString("setting.display_name")).lore(ClaimManagementMenu.this.getStringList("setting.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new ClaimSettingsMenu(player, ClaimManagementMenu.this.claim, 0);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(NClaim.getMaterial(DMaterial.BUNDLE, DMaterial.SHULKER_BOX)).name(ClaimManagementMenu.this.getString("type.display_name")).lore(ClaimManagementMenu.this.getStringList("type.lore")).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new ManageClaimBlockMenu(ClaimManagementMenu.this.claim, player, 0);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.TNT).name(ClaimManagementMenu.this.getString("delete.display_name")).lore(ClaimManagementMenu.this.getStringList("delete.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.delete_claim.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.delete_claim.lore"), result -> {
                    if ("confirmed".equals(result)) {
                        ClaimManagementMenu.this.claim.remove(RemoveCause.UNCLAIM);
                        player.closeInventory();
                    } else if ("declined".equals(result)) {
                        new ClaimManagementMenu(player, ClaimManagementMenu.this.claim);
                    }
                });
            }
        });
    }
}

