/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.commands.BaseCommand;
import nesoi.aysihuniks.nclaim.commands.admin.AddCommand;
import nesoi.aysihuniks.nclaim.commands.admin.ChangeCommand;
import nesoi.aysihuniks.nclaim.commands.admin.HelpCommand;
import nesoi.aysihuniks.nclaim.commands.admin.MenuCommand;
import nesoi.aysihuniks.nclaim.commands.admin.ReloadCommand;
import nesoi.aysihuniks.nclaim.commands.admin.RemoveCommand;
import nesoi.aysihuniks.nclaim.commands.admin.SetCommand;
import nesoi.aysihuniks.nclaim.commands.root.AboutCommand;
import nesoi.aysihuniks.nclaim.commands.root.BalanceCommand;
import nesoi.aysihuniks.nclaim.commands.root.LevelCommand;
import nesoi.aysihuniks.nclaim.ui.claim.ClaimMainMenu;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllCommandExecutor
implements CommandExecutor,
TabCompleter {
    private final HashMap<String, BaseCommand> commands = new HashMap();
    private final HashMap<String, BaseCommand> adminCommands = new HashMap();

    public AllCommandExecutor() {
        this.commands.put("about", new AboutCommand());
        this.commands.put("balance", new BalanceCommand());
        this.commands.put("help", new nesoi.aysihuniks.nclaim.commands.root.HelpCommand());
        this.commands.put("level", new LevelCommand());
        this.adminCommands.put("add", new AddCommand());
        this.adminCommands.put("change", new ChangeCommand());
        this.adminCommands.put("menu", new MenuCommand());
        this.adminCommands.put("remove", new RemoveCommand());
        this.adminCommands.put("reload", new ReloadCommand());
        this.adminCommands.put("set", new SetCommand());
        this.adminCommands.put("help", new HelpCommand());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            ChannelType.CHAT.send(sender, NClaim.inst().getLangManager().getString("command.must_be_player"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            if (!player.hasPermission("nclaim.use")) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                return true;
            }
            new ClaimMainMenu(player);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("admin")) {
            if (!player.hasPermission("nclaim.admin")) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.permission_denied"));
                return true;
            }
            if (args.length == 1) {
                this.adminCommands.get("help").onCommand(sender, command, label, args);
                return true;
            }
            String adminSubCommand = args[1].toLowerCase();
            BaseCommand adminCmd = this.adminCommands.get(adminSubCommand);
            if (adminCmd != null) {
                return adminCmd.onCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
            }
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.wrong_usage"));
            return true;
        }
        BaseCommand cmd = this.commands.get(subCommand);
        if (cmd != null) {
            return cmd.onCommand(sender, command, label, args);
        }
        ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.wrong_usage"));
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        List<String> subCompletions;
        BaseCommand adminCmd;
        if (!(sender instanceof Player)) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(this.commands.keySet());
            if (sender.hasPermission("nclaim.admin")) {
                completions.add("admin");
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("admin")) {
            if (sender.hasPermission("nclaim.admin")) {
                completions.addAll(this.adminCommands.keySet());
            }
        } else if (args.length > 2 && args[0].equalsIgnoreCase("admin") && (adminCmd = this.adminCommands.get(args[1].toLowerCase())) != null && (subCompletions = adminCmd.onTabComplete(sender, command, label, Arrays.copyOfRange(args, 1, args.length))) != null) {
            completions.addAll(subCompletions);
        }
        return completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

