/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.commands.admin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.commands.BaseCommand;
import nesoi.aysihuniks.nclaim.enums.Balance;
import nesoi.aysihuniks.nclaim.model.User;
import nesoi.aysihuniks.nclaim.utils.LangManager;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SetCommand
extends BaseCommand {
    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        LangManager langManager = NClaim.inst().getLangManager();
        if (!(sender instanceof Player)) {
            ChannelType.CHAT.send(sender, langManager.getString("command.must_be_player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("nclaim.set") && !player.hasPermission("nclaim.admin")) {
            ChannelType.CHAT.send((CommandSender)player, langManager.getString("command.permission.denied"));
            return true;
        }
        if (args.length < 3) {
            ChannelType.CHAT.send((CommandSender)player, langManager.getString("command.wrong_usage"));
            return true;
        }
        switch (args[1].toLowerCase()) {
            case "balance": {
                this.handleBalanceSet(player, args);
                break;
            }
            case "blockvalue": {
                this.handleBlockValueSet(player, args);
                break;
            }
            default: {
                ChannelType.CHAT.send((CommandSender)player, langManager.getString("command.wrong_usage"));
            }
        }
        return true;
    }

    private void handleBalanceSet(Player player, String[] args) {
        if (args.length < 4) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.wrong_usage"));
            return;
        }
        try {
            double amount = Double.parseDouble(args[2]);
            String targetName = args[3];
            Player targetPlayer = NClaim.inst().getServer().getPlayer(targetName);
            if (targetPlayer == null) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.player.not_found").replace("{target}", targetName));
                return;
            }
            User user = User.getUser(targetPlayer.getUniqueId());
            if (user == null) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.player_data_not_found"));
                return;
            }
            if (NClaim.inst().getBalanceSystem() == Balance.VAULT) {
                double currentBalance = NClaim.inst().getEconomy().getBalance((OfflinePlayer)targetPlayer);
                NClaim.inst().getEconomy().withdrawPlayer((OfflinePlayer)targetPlayer, currentBalance);
                NClaim.inst().getEconomy().depositPlayer((OfflinePlayer)targetPlayer, amount);
            } else {
                user.setBalance(amount);
            }
            ChannelType.CHAT.send((CommandSender)targetPlayer, NClaim.inst().getLangManager().getString("command.set.target_balance_set").replace("{balance}", String.valueOf(amount)));
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.set.player_balance_set").replace("{amount}", String.valueOf(amount)).replace("{target}", targetName));
        }
        catch (NumberFormatException e) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.enter_a_valid_number"));
        }
    }

    private void handleBlockValueSet(Player player, String[] args) {
        if (args.length < 4) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.wrong_usage"));
            return;
        }
        try {
            Material material;
            String materialName = args[2].toUpperCase();
            int value = Integer.parseInt(args[3]);
            if (value <= 0) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.enter_a_valid_number"));
                return;
            }
            try {
                material = Material.valueOf((String)materialName);
            }
            catch (IllegalArgumentException e) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.invalid_material").replace("{material}", materialName));
                return;
            }
            if (!materialName.endsWith("_BLOCK") && !materialName.contains("ORE")) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.invalid_block_type").replace("{material}", materialName));
                return;
            }
            NClaim.inst().getBlockValueManager().setBlockValue(material, value);
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.set.block_value_set").replace("{block}", material.name()).replace("{value}", String.valueOf(value)));
        }
        catch (NumberFormatException e) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.enter_a_valid_number"));
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player) || !sender.hasPermission("nclaim.set") && !sender.hasPermission("nclaim.admin")) {
            return null;
        }
        if (args.length == 2) {
            return Arrays.asList("balance", "blockvalue");
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("blockvalue")) {
            return Arrays.stream(Material.values()).map(Enum::name).filter(name -> name.endsWith("_BLOCK") || name.contains("ORE")).collect(Collectors.toList());
        }
        if (args.length == 4 && args[1].equalsIgnoreCase("balance")) {
            return NClaim.inst().getServer().getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        }
        return null;
    }
}

