/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.User;
import nesoi.aysihuniks.nclaim.ui.claim.ClaimMainMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimListMenu
extends BaseMenu {
    @NotNull
    private static ListType currentListType = ListType.ALL;
    @NotNull
    private final Player player;
    private final int page;
    private static final int[] claimSlots = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};

    public ClaimListMenu(@NotNull Player player, int page) {
        super("claim_list_menu");
        this.player = player;
        this.page = page;
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title"));
        this.addNavigationButton();
        this.addListTypeButton();
        this.addClaimButtons();
        if (this.hasNextPage()) {
            this.addNextPageButton();
        }
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void addNavigationButton() {
        this.addButton(new Button(){
            final String buttonPath;
            {
                this.buttonPath = ClaimListMenu.this.page == 0 ? "back" : "previous_page";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimListMenu.this.page == 0 ? ClaimListMenu.this.getMaterialFullPath("back") : ClaimListMenu.this.getMaterialFullPath("previous_page")).name(NClaim.inst().getGuiLangManager().getString(this.buttonPath + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (ClaimListMenu.this.page == 0) {
                    new ClaimMainMenu(player);
                } else {
                    new ClaimListMenu(player, ClaimListMenu.this.page - 1);
                }
            }
        });
    }

    private void addListTypeButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(" ");
                lore.add(ClaimListMenu.this.formatListTypeEntry(ListType.ALL, "all"));
                lore.add(ClaimListMenu.this.formatListTypeEntry(ListType.PLAYER, "player"));
                lore.add(ClaimListMenu.this.formatListTypeEntry(ListType.COOP, "coop"));
                return ItemCreator.of(ClaimListMenu.this.getMaterial("list_type")).name(ClaimListMenu.this.getString("list_type.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                currentListType = ListType.values()[(currentListType.ordinal() + 1) % ListType.values().length];
                MessageType.MENU_REFRESH.playSound(player);
                new ClaimListMenu(player, 0);
            }
        });
    }

    private String formatListTypeEntry(ListType type, String configKey) {
        return (currentListType == type ? "&e- " : "&7- ") + this.getString("list_type." + configKey);
    }

    private void addNextPageButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimListMenu.this.getMaterialFullPath("next_page")).name(NClaim.inst().getGuiLangManager().getString("next_page.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new ClaimListMenu(player, ClaimListMenu.this.page + 1);
            }
        });
    }

    private void addClaimButtons() {
        List<Claim> claimsToShow = this.getClaimsToShow();
        int startIndex = this.page * claimSlots.length;
        int endIndex = Math.min(startIndex + claimSlots.length, claimsToShow.size());
        int i = startIndex;
        int slotIndex = 0;
        while (i < endIndex) {
            Claim claim = claimsToShow.get(i);
            boolean isOwner = User.getUser(this.player.getUniqueId()).getPlayerClaims().contains(claim);
            this.addClaimButton(claim, claimSlots[slotIndex], isOwner);
            ++i;
            ++slotIndex;
        }
    }

    private List<Claim> getClaimsToShow() {
        User.loadUser(this.player.getUniqueId());
        User user = User.getUser(this.player.getUniqueId());
        ArrayList<Claim> claims = new ArrayList<Claim>();
        switch (currentListType.ordinal()) {
            case 0: {
                claims.addAll(user.getPlayerClaims());
                claims.addAll(user.getCoopClaims());
                break;
            }
            case 1: {
                claims.addAll(user.getPlayerClaims());
                break;
            }
            case 2: {
                claims.addAll(user.getCoopClaims());
            }
        }
        return claims;
    }

    private void addClaimButton(final Claim claim, final int slot, final boolean isOwner) {
        String buttonPath = isOwner ? "own_claims" : "coop_claims";
        Chunk chunk = claim.getChunk();
        ArrayList<String> lore = new ArrayList<String>(this.getStringList(buttonPath + ".lore"));
        lore.replaceAll(s -> s.replace("{world}", chunk.getWorld().getName()).replace("{coordinates}", NClaim.getCoordinates(chunk)).replace("{owner}", Bukkit.getOfflinePlayer((UUID)claim.getOwner()).getName()));
        final ItemStack item = ItemCreator.of(isOwner ? this.getMaterial("own_claims") : this.getMaterial("coop_claims")).name(this.getString(buttonPath + ".display_name").replace("{claim_id}", claim.getClaimId())).lore(lore).get();
        this.addButton(new Button(this){
            final /* synthetic */ ClaimListMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{slot});
            }

            @Override
            public ItemStack getItem() {
                return item;
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (isOwner) {
                    new ClaimManagementMenu(player, claim, false);
                }
            }
        });
    }

    private boolean hasNextPage() {
        return (this.page + 1) * claimSlots.length < this.getClaimsToShow().size();
    }

    private static enum ListType {
        ALL,
        PLAYER,
        COOP;

    }
}

