/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.commands.admin;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.commands.BaseCommand;
import nesoi.aysihuniks.nclaim.enums.Balance;
import nesoi.aysihuniks.nclaim.model.User;
import nesoi.aysihuniks.nclaim.utils.LangManager;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.message.ChannelType;

public class AddCommand
extends BaseCommand {
    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        LangManager langManager = NClaim.inst().getLangManager();
        if (!(sender instanceof Player)) {
            ChannelType.CHAT.send(sender, langManager.getString("command.must_be_player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("nclaim.add") && !player.hasPermission("nclaim.admin")) {
            ChannelType.CHAT.send((CommandSender)player, langManager.getString("command.permission.denied"));
            return true;
        }
        if (args.length < 3) {
            ChannelType.CHAT.send((CommandSender)player, langManager.getString("command.wrong_usage"));
            return true;
        }
        switch (args[1].toLowerCase()) {
            case "balance": {
                this.handleBalanceAdd(player, args);
                break;
            }
            case "blacklisted_world": {
                this.handleBlacklistedWorldAdd(player, args[2]);
                break;
            }
            case "blacklisted_region": {
                this.handleBlacklistedRegionAdd(player, args[2]);
                break;
            }
            case "blockvalue": {
                this.handleBlockValueAdd(player, args);
                break;
            }
            default: {
                ChannelType.CHAT.send((CommandSender)player, langManager.getString("command.wrong_usage"));
            }
        }
        return true;
    }

    private void handleBalanceAdd(Player player, String[] args) {
        if (args.length < 4) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.wrong_usage"));
            return;
        }
        try {
            double amount = Double.parseDouble(args[2]);
            String targetName = args[3];
            Player targetPlayer = NClaim.inst().getServer().getPlayer(targetName);
            if (targetPlayer == null) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.player.not_found").replace("{target}", targetName));
                return;
            }
            User user = User.getUser(targetPlayer.getUniqueId());
            if (user == null) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.player_data_not_found"));
                return;
            }
            if (NClaim.inst().getBalanceSystem() == Balance.VAULT) {
                NClaim.inst().getEconomy().depositPlayer((OfflinePlayer)targetPlayer, amount);
                ChannelType.CHAT.send((CommandSender)targetPlayer, NClaim.inst().getLangManager().getString("command.add.target_added").replace("{amount}", String.valueOf(amount)).replace("{balance}", String.valueOf(NClaim.inst().getEconomy().getBalance((OfflinePlayer)targetPlayer))));
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.add.player_added").replace("{amount}", String.valueOf(amount)).replace("{target}", targetName));
            } else {
                user.addBalance(amount);
                ChannelType.CHAT.send((CommandSender)targetPlayer, NClaim.inst().getLangManager().getString("command.add.target_added").replace("{amount}", String.valueOf(amount)).replace("{balance}", String.valueOf(user.getBalance())));
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.add.player_added").replace("{amount}", String.valueOf(amount)).replace("{target}", targetName));
            }
        }
        catch (NumberFormatException e) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.enter_a_valid_number"));
        }
    }

    private void handleBlacklistedWorldAdd(Player player, String worldName) {
        List<String> blacklistedWorlds = NClaim.inst().getNconfig().getBlacklistedWorlds();
        if (blacklistedWorlds == null) {
            blacklistedWorlds = new ArrayList<String>();
        }
        if (blacklistedWorlds.contains(worldName)) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.add.world_already_in_blacklist").replace("{world}", worldName));
            return;
        }
        blacklistedWorlds.add(worldName);
        NClaim.inst().getNconfig().setBlacklistedWorlds(blacklistedWorlds);
        NClaim.inst().getNconfig().save();
        ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.add.world_added_to_blacklist").replace("{world}", worldName));
    }

    private void handleBlacklistedRegionAdd(Player player, String regionName) {
        if (!NClaim.inst().isWorldGuardEnabled()) {
            return;
        }
        List<String> blacklistedRegions = NClaim.inst().getNconfig().getBlacklistedRegions();
        if (blacklistedRegions == null) {
            blacklistedRegions = new ArrayList<String>();
        }
        if (blacklistedRegions.contains(regionName)) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.add.region_already_in_blacklist").replace("{region}", regionName));
            return;
        }
        blacklistedRegions.add(regionName);
        NClaim.inst().getNconfig().setBlacklistedRegions(blacklistedRegions);
        NClaim.inst().getNconfig().save();
        ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.add.region_added_to_blacklist").replace("{region}", regionName));
    }

    private void handleBlockValueAdd(Player player, String[] args) {
        if (args.length < 4) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.wrong_usage"));
            return;
        }
        try {
            Material material;
            String materialName = args[2].toUpperCase();
            int value = Integer.parseInt(args[3]);
            if (value <= 0) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.invalid_value"));
                return;
            }
            try {
                material = Material.valueOf((String)materialName);
            }
            catch (IllegalArgumentException e) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.invalid_material").replace("{material}", materialName));
                return;
            }
            if (NClaim.inst().getBlockValueManager().isValidBlock(material)) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.add.block_already_exists").replace("{block}", material.name()));
                return;
            }
            if (!materialName.endsWith("_BLOCK") && !materialName.contains("ORE")) {
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.invalid_block_type").replace("{material}", materialName));
                return;
            }
            NClaim.inst().getBlockValueManager().setBlockValue(material, value);
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.add.block_value_added").replace("{block}", material.name()).replace("{value}", String.valueOf(value)));
        }
        catch (NumberFormatException e) {
            ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString("command.enter_a_valid_number"));
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player && sender.hasPermission("nclaim.add") && sender.hasPermission("nclaim.admin"))) {
            return null;
        }
        if (args.length == 2) {
            ArrayList<String> options = new ArrayList<String>(Arrays.asList("balance", "blacklisted_world", "blockvalue"));
            if (NClaim.inst().isWorldGuardEnabled()) {
                options.add("blacklisted_region");
            }
            return options;
        }
        if (args.length == 3) {
            if (args[1].equalsIgnoreCase("blacklisted_world")) {
                return NClaim.inst().getServer().getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
            }
            if (args[1].equalsIgnoreCase("blockvalue")) {
                return Arrays.stream(Material.values()).map(Enum::name).filter(name -> name.endsWith("_BLOCK") || name.contains("ORE")).collect(Collectors.toList());
            }
            if (args[1].equalsIgnoreCase("blacklisted_region") && NClaim.inst().isWorldGuardEnabled()) {
                try {
                    WorldGuard worldGuard;
                    RegionContainer container;
                    RegionManager regionManager;
                    if (NClaim.inst().getServer().getPluginManager().getPlugin("WorldGuard") != null && (regionManager = (container = (worldGuard = WorldGuard.getInstance()).getPlatform().getRegionContainer()).get(BukkitAdapter.adapt((World)((Player)sender).getWorld()))) != null) {
                        return new ArrayList<String>(regionManager.getRegions().keySet());
                    }
                }
                catch (Exception e) {
                    return new ArrayList<String>();
                }
                return new ArrayList<String>();
            }
        }
        if (args.length == 4 && args[1].equalsIgnoreCase("balance")) {
            return NClaim.inst().getServer().getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        }
        return null;
    }
}

