/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.model;

import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.HologramManager;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.api.events.ClaimRemoveEvent;
import nesoi.aysihuniks.nclaim.enums.HoloEnum;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.model.ClaimSetting;
import nesoi.aysihuniks.nclaim.model.CoopPermission;
import nesoi.aysihuniks.nclaim.model.User;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.message.ChannelType;
import org.nandayo.dapi.object.DParticle;

public class Claim {
    private NClaim plugin;
    @NotNull
    private final String claimId;
    @NotNull
    private final Chunk chunk;
    @NotNull
    private final Date createdAt;
    @NotNull
    private Date expiredAt;
    @NotNull
    private UUID owner;
    @NotNull
    private final Location claimBlockLocation;
    private long claimValue;
    private Material claimBlockType;
    private final Collection<String> lands;
    private final Collection<UUID> coopPlayers;
    private final HashMap<UUID, Date> coopPlayerJoinDate;
    private final HashMap<UUID, CoopPermission> coopPermissions;
    private final ClaimSetting settings;
    private final Set<Material> purchasedBlockTypes = new HashSet<Material>();
    public static Collection<Claim> claims = new ArrayList<Claim>();
    private volatile boolean isBeingRemoved = false;

    public Claim(@NotNull String claimId, @NotNull Chunk chunk, @NotNull Date createdAt, @NotNull Date expiredAt, @NotNull UUID owner, @NotNull Location claimBlockLocation, long claimValue, Material claimBlockType, Collection<String> lands, Collection<UUID> coopPlayers, HashMap<UUID, Date> coopPlayerJoinDate, HashMap<UUID, CoopPermission> coopPermissions, ClaimSetting settings, Set<Material> purchasedBlockTypes) {
        this.plugin = NClaim.inst();
        this.claimId = claimId;
        this.chunk = chunk;
        this.createdAt = createdAt;
        this.expiredAt = expiredAt;
        this.owner = owner;
        this.claimBlockLocation = claimBlockLocation;
        this.claimBlockType = claimBlockType;
        this.claimValue = claimValue;
        this.lands = lands;
        this.coopPlayers = coopPlayers;
        this.coopPlayerJoinDate = coopPlayerJoinDate;
        this.coopPermissions = coopPermissions;
        this.settings = settings;
        if (purchasedBlockTypes != null) {
            this.purchasedBlockTypes.addAll(purchasedBlockTypes);
        }
        claims.removeIf(c -> c.getClaimId().equals(claimId));
        claims.add(this);
    }

    public Collection<Chunk> getAllChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        chunks.add(this.chunk);
        this.getLands().forEach(l -> chunks.add(NClaim.deserializeChunk(l)));
        return chunks;
    }

    public static Claim getClaim(@NotNull Chunk chunk) {
        return claims.stream().filter(c -> c.getChunk().equals((Object)chunk) || c.getLands().contains(chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ())).findFirst().orElse(null);
    }

    public void remove(RemoveCause cause) {
        if (this.isBeingRemoved) {
            return;
        }
        this.isBeingRemoved = true;
        ClaimRemoveEvent removeEvent = new ClaimRemoveEvent(this, cause);
        Bukkit.getPluginManager().callEvent((Event)removeEvent);
        if (removeEvent.isCancelled()) {
            Player owner = Bukkit.getPlayer((UUID)this.getOwner());
            if (owner != null) {
                ChannelType.CHAT.send((CommandSender)owner, this.plugin.getLangManager().getString("claim.remove_cancelled"));
            }
            return;
        }
        World world = this.getChunk().getWorld();
        Location claimBlock = this.getClaimBlockLocation();
        claimBlock.getBlock().setType(Material.AIR);
        String hologramId = "claim_" + world.getName() + "_" + this.getChunk().getX() + "_" + this.getChunk().getZ();
        if (HoloEnum.getActiveHologram() == HoloEnum.DECENT_HOLOGRAM) {
            Hologram hologram = DHAPI.getHologram((String)hologramId);
            if (hologram != null) {
                hologram.delete();
            }
        } else {
            HologramManager manager = FancyHologramsPlugin.get().getHologramManager();
            manager.getHologram(hologramId).ifPresent(arg_0 -> ((HologramManager)manager).removeHologram(arg_0));
        }
        int centerX = this.getChunk().getX() * 16 + 8;
        int centerZ = this.getChunk().getZ() * 16 + 8;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals((Object)claimBlock.getWorld())) continue;
            double distance = player.getLocation().distance(claimBlock);
            float volume = (float)Math.max(0.2, 1.0 - distance / 16.0);
            world.playSound(claimBlock, Sound.ENTITY_GENERIC_EXPLODE, volume, 1.0f);
            ChannelType.CHAT.send((CommandSender)player, this.plugin.getLangManager().getString("claim.expired").replace("{x}", String.valueOf(centerX)).replace("{z}", String.valueOf(centerZ)));
        }
        User ownerUser = User.getUser(this.getOwner());
        if (ownerUser == null) {
            User.loadUser(this.getOwner());
            ownerUser = User.getUser(this.getOwner());
        }
        if (ownerUser != null) {
            ownerUser.getPlayerClaims().remove(this);
            User.saveUser(this.getOwner());
        }
        this.getCoopPlayers().forEach(uuid -> {
            User coopUser = User.getUser(uuid);
            if (coopUser == null) {
                User.loadUser(uuid);
                coopUser = User.getUser(uuid);
            }
            if (coopUser != null) {
                coopUser.getCoopClaims().remove(this);
                User.saveUser(uuid);
            }
        });
        world.spawnParticle(NClaim.getParticle(DParticle.LARGE_SMOKE, DParticle.SMOKE_LARGE), claimBlock, 1);
        world.playSound(claimBlock, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getDatabaseManager().deleteClaim(this.getClaimId());
        }
        claims.remove(this);
    }

    public void setOwner(@NotNull UUID newOwner) {
        UUID oldOwner = this.getOwner();
        User oldOwnerUser = User.getUser(oldOwner);
        if (oldOwnerUser == null) {
            User.loadUser(oldOwner);
            oldOwnerUser = User.getUser(oldOwner);
        }
        if (oldOwnerUser != null) {
            oldOwnerUser.getPlayerClaims().remove(this);
            User.saveUser(oldOwner);
        }
        this.owner = newOwner;
        User newOwnerUser = User.getUser(newOwner);
        if (newOwnerUser == null) {
            User.loadUser(newOwner);
            newOwnerUser = User.getUser(newOwner);
        }
        if (newOwnerUser != null) {
            newOwnerUser.getPlayerClaims().add(this);
            User.saveUser(newOwner);
        }
        this.getCoopPlayers().remove(newOwner);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getDatabaseManager().saveClaim(this);
        }
    }

    @Generated
    public NClaim getPlugin() {
        return this.plugin;
    }

    @NotNull
    @Generated
    public String getClaimId() {
        return this.claimId;
    }

    @NotNull
    @Generated
    public Chunk getChunk() {
        return this.chunk;
    }

    @NotNull
    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    @Generated
    public Date getExpiredAt() {
        return this.expiredAt;
    }

    @NotNull
    @Generated
    public UUID getOwner() {
        return this.owner;
    }

    @NotNull
    @Generated
    public Location getClaimBlockLocation() {
        return this.claimBlockLocation;
    }

    @Generated
    public long getClaimValue() {
        return this.claimValue;
    }

    @Generated
    public Material getClaimBlockType() {
        return this.claimBlockType;
    }

    @Generated
    public Collection<String> getLands() {
        return this.lands;
    }

    @Generated
    public Collection<UUID> getCoopPlayers() {
        return this.coopPlayers;
    }

    @Generated
    public HashMap<UUID, Date> getCoopPlayerJoinDate() {
        return this.coopPlayerJoinDate;
    }

    @Generated
    public HashMap<UUID, CoopPermission> getCoopPermissions() {
        return this.coopPermissions;
    }

    @Generated
    public ClaimSetting getSettings() {
        return this.settings;
    }

    @Generated
    public Set<Material> getPurchasedBlockTypes() {
        return this.purchasedBlockTypes;
    }

    @Generated
    public boolean isBeingRemoved() {
        return this.isBeingRemoved;
    }

    @Generated
    public void setPlugin(NClaim plugin) {
        this.plugin = plugin;
    }

    @Generated
    public void setExpiredAt(@NotNull Date expiredAt) {
        if (expiredAt == null) {
            throw new NullPointerException("expiredAt is marked non-null but is null");
        }
        this.expiredAt = expiredAt;
    }

    @Generated
    public void setClaimValue(long claimValue) {
        this.claimValue = claimValue;
    }

    @Generated
    public void setClaimBlockType(Material claimBlockType) {
        this.claimBlockType = claimBlockType;
    }

    @Generated
    public void setBeingRemoved(boolean isBeingRemoved) {
        this.isBeingRemoved = isBeingRemoved;
    }

    @Generated
    public static Collection<Claim> getClaims() {
        return claims;
    }
}

