/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.admin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.message.ChannelType;
import org.nandayo.dapi.object.DMaterial;

public class AdminTimeManagementMenu
extends BaseMenu {
    private int days;
    private int hours;
    private int minutes;
    private int timeUnit;
    @NotNull
    private final Claim claim;

    public AdminTimeManagementMenu(@NotNull Player player, int days, int hours, int minutes, int timeUnit, @NotNull Claim claim) {
        super("admin_menu.time_management_menu");
        this.claim = claim;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.timeUnit = timeUnit;
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        String ownerName = Bukkit.getOfflinePlayer((UUID)this.claim.getOwner()).getName() != null ? Bukkit.getOfflinePlayer((UUID)this.claim.getOwner()).getName() : "Unknown";
        this.createInventory(MenuType.CHEST_5_ROWS, this.getString("title").replace("{owner}", ownerName));
        this.setBackgroundButton(BackgroundMenu::getButton);
        final OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)this.claim.getOwner());
        this.addButton(new Button(this){
            final /* synthetic */ AdminTimeManagementMenu this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(this.this$0.getStringList("claim_info.lore"));
                lore.replaceAll(s -> s.replace("{time_left}", NClaim.inst().getClaimExpirationManager().getFormattedTimeLeft(this.this$0.claim)).replace("{expires_at}", NClaim.serializeDate(this.this$0.claim.getExpiredAt())));
                return ItemCreator.of(NClaim.getMaterial(DMaterial.GLOW_ITEM_FRAME, DMaterial.ITEM_FRAME)).name(this.this$0.getString("claim_info.display_name").replace("{owner}", owner.getName() != null ? owner.getName() : "Unknown")).lore(lore).get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name(AdminTimeManagementMenu.this.getString("time_display.display_name").replace("{d}", String.valueOf(AdminTimeManagementMenu.this.days)).replace("{h}", String.valueOf(AdminTimeManagementMenu.this.hours)).replace("{m}", String.valueOf(AdminTimeManagementMenu.this.minutes))).get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{31});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(AdminTimeManagementMenu.this.getStringList("confirm.lore"));
                lore.replaceAll(s -> s.replace("{d}", String.valueOf(AdminTimeManagementMenu.this.days)).replace("{h}", String.valueOf(AdminTimeManagementMenu.this.hours)).replace("{m}", String.valueOf(AdminTimeManagementMenu.this.minutes)));
                return ItemCreator.of(Material.BLUE_ICE).name(AdminTimeManagementMenu.this.getString("confirm.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                NClaim.inst().getClaimExpirationManager().extendClaimExpiration(AdminTimeManagementMenu.this.claim, AdminTimeManagementMenu.this.days, AdminTimeManagementMenu.this.hours, AdminTimeManagementMenu.this.minutes);
                String messageKey = AdminTimeManagementMenu.this.days >= 0 && AdminTimeManagementMenu.this.hours >= 0 && AdminTimeManagementMenu.this.minutes >= 0 ? "command.add.expiration_extended" : "command.remove.expiration_subtracted";
                ChannelType.CHAT.send((CommandSender)player, NClaim.inst().getLangManager().getString(messageKey).replace("{d}", String.valueOf(Math.abs(AdminTimeManagementMenu.this.days))).replace("{h}", String.valueOf(Math.abs(AdminTimeManagementMenu.this.hours))).replace("{m}", String.valueOf(Math.abs(AdminTimeManagementMenu.this.minutes))));
                MessageType.CONFIRM.playSound(player);
                new AdminTimeManagementMenu(player, 0, 0, 0, AdminTimeManagementMenu.this.timeUnit, AdminTimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.OAK_DOOR).name(NClaim.inst().getGuiLangManager().getString("back.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                new AdminClaimManagementMenu(player, AdminTimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(AdminTimeManagementMenu.this.getStringList("select_time_unit.lore"));
                lore.replaceAll(s -> s.replace("{days_status}", AdminTimeManagementMenu.this.timeUnit == 0 ? "&e" + AdminTimeManagementMenu.this.getString("days_status") : "&7" + AdminTimeManagementMenu.this.getString("days_status")).replace("{hours_status}", AdminTimeManagementMenu.this.timeUnit == 1 ? "&e" + AdminTimeManagementMenu.this.getString("hours_status") : "&7" + AdminTimeManagementMenu.this.getString("hours_status")).replace("{minutes_status}", AdminTimeManagementMenu.this.timeUnit == 2 ? "&e" + AdminTimeManagementMenu.this.getString("minutes_status") : "&7" + AdminTimeManagementMenu.this.getString("minutes_status")));
                return ItemCreator.of(Material.CHAIN).name(AdminTimeManagementMenu.this.getString("select_time_unit.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                AdminTimeManagementMenu.this.timeUnit = (AdminTimeManagementMenu.this.timeUnit + 1) % 3;
                MessageType.MENU_REFRESH.playSound(player);
                new AdminTimeManagementMenu(player, AdminTimeManagementMenu.this.days, AdminTimeManagementMenu.this.hours, AdminTimeManagementMenu.this.minutes, AdminTimeManagementMenu.this.timeUnit, AdminTimeManagementMenu.this.claim);
            }
        });
        this.addTimeButtons();
    }

    private void addTimeButtons() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{28});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.LIME_CONCRETE).name(AdminTimeManagementMenu.this.getString("add_one.display_name").replace("{unit}", AdminTimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                AdminTimeManagementMenu.this.adjustTime(1);
                MessageType.VALUE_INCREASE.playSound(player);
                new AdminTimeManagementMenu(player, AdminTimeManagementMenu.this.days, AdminTimeManagementMenu.this.hours, AdminTimeManagementMenu.this.minutes, AdminTimeManagementMenu.this.timeUnit, AdminTimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{29});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GREEN_CONCRETE).name(AdminTimeManagementMenu.this.getString("add_six.display_name").replace("{unit}", AdminTimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                AdminTimeManagementMenu.this.adjustTime(6);
                MessageType.VALUE_INCREASE.playSound(player);
                new AdminTimeManagementMenu(player, AdminTimeManagementMenu.this.days, AdminTimeManagementMenu.this.hours, AdminTimeManagementMenu.this.minutes, AdminTimeManagementMenu.this.timeUnit, AdminTimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{33});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PINK_CONCRETE).name(AdminTimeManagementMenu.this.getString("subtract_one.display_name").replace("{unit}", AdminTimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                AdminTimeManagementMenu.this.adjustTime(-1);
                MessageType.VALUE_DECREASE.playSound(player);
                new AdminTimeManagementMenu(player, AdminTimeManagementMenu.this.days, AdminTimeManagementMenu.this.hours, AdminTimeManagementMenu.this.minutes, AdminTimeManagementMenu.this.timeUnit, AdminTimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{34});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.RED_CONCRETE).name(AdminTimeManagementMenu.this.getString("subtract_six.display_name").replace("{unit}", AdminTimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                AdminTimeManagementMenu.this.adjustTime(-6);
                MessageType.VALUE_DECREASE.playSound(player);
                new AdminTimeManagementMenu(player, AdminTimeManagementMenu.this.days, AdminTimeManagementMenu.this.hours, AdminTimeManagementMenu.this.minutes, AdminTimeManagementMenu.this.timeUnit, AdminTimeManagementMenu.this.claim);
            }
        });
    }

    private String getTimeUnitString() {
        switch (this.timeUnit) {
            case 1: {
                return this.getString("hours_status");
            }
            case 2: {
                return this.getString("minutes_status");
            }
        }
        return this.getString("days_status");
    }

    private void adjustTime(int amount) {
        switch (this.timeUnit) {
            case 0: {
                this.days += amount;
                break;
            }
            case 1: {
                this.hours += amount;
                break;
            }
            case 2: {
                this.minutes += amount;
            }
        }
    }
}

