/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.nandayo.dapi.Util;

public class Config {
    private final NClaim plugin;
    private static FileConfiguration config;
    public String defaultLanguage;
    public double claimBuyPrice;
    public double eachLandBuyPrice;
    public int claimExpiryDays;
    public int maxCoopPlayers;
    public int maxClaimCount;
    public int expandMenuHeight;
    public int expandMenuWidth;
    public List<String> blacklistedWorlds;
    public List<String> blacklistedRegions;
    public int autoSave;
    private boolean databaseEnabled;
    private String databaseType;
    private String sqliteFile;
    private String mysqlHost;
    private int mysqlPort;
    private String mysqlDatabase;
    private String mysqlUser;
    private String mysqlPassword;
    private int maximumPoolSize;
    private int minimumIdle;
    private long idleTimeout;
    private long maxLifetime;
    private long connectionTimeout;
    private double timeExtensionPricePerMinute;
    private double timeExtensionPricePerHour;
    private double timeExtensionPricePerDay;
    private double timeExtensionTaxRate;

    public Config(NClaim plugin) {
        this.plugin = plugin;
    }

    public FileConfiguration get() {
        return config;
    }

    public Config load() {
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        this.setDefaultLanguage(config.getString("lang_file", "en-US"));
        this.setBlacklistedWorlds(config.getStringList("blacklisted_worlds"));
        this.setBlacklistedRegions(config.getStringList("blacklisted_regions"));
        this.setMaxClaimCount(config.getInt("claim_settings.max_count", 3));
        this.setClaimBuyPrice(config.getDouble("claim_settings.buy_price", 1500.0));
        this.setEachLandBuyPrice(config.getDouble("claim_settings.expand_price", 2000.0));
        this.setMaxCoopPlayers(config.getInt("claim_settings.max_coop.default", 3));
        this.setClaimExpiryDays(config.getInt("claim_settings.expiry_days", 7));
        this.setExpandMenuHeight(config.getInt("claim_settings.expand_menu_height", 2));
        this.setExpandMenuWidth(config.getInt("claim_settings.expand_menu_width", 2));
        this.setTimeExtensionPricePerMinute(config.getDouble("time_extension.price_per_minute", 10.0));
        this.setTimeExtensionPricePerHour(config.getDouble("time_extension.price_per_hour", 500.0));
        this.setTimeExtensionPricePerDay(config.getDouble("time_extension.price_per_day", 10000.0));
        this.setTimeExtensionTaxRate(config.getDouble("time_extension.tax_rate", 0.1));
        this.setAutoSave(config.getInt("auto_save", 30));
        this.setDatabaseEnabled(config.getBoolean("database.enable", false));
        this.setDatabaseType(config.getString("database.type", "sqlite"));
        this.setSqliteFile(config.getString("database.sqlite.file", "database.db"));
        this.setMysqlHost(config.getString("database.mysql.host", "localhost"));
        this.setMysqlPort(config.getInt("database.mysql.port", 3306));
        this.setMysqlDatabase(config.getString("database.mysql.database", "nclaim"));
        this.setMysqlUser(config.getString("database.mysql.user", "root"));
        this.setMysqlPassword(config.getString("database.mysql.password", ""));
        this.setMaximumPoolSize(config.getInt("database.mysql.maximum_pool_size", 10));
        this.setMinimumIdle(config.getInt("database.mysql.minimum_idle", 5));
        this.setIdleTimeout(config.getLong("database.mysql.idle_timeout", 300000L));
        this.setMaxLifetime(config.getLong("database.mysql.max_lifetime", 1800000L));
        this.setConnectionTimeout(config.getLong("database.mysql.connection_timeout", 30000L));
        return this;
    }

    public synchronized void save() {
        try {
            config.set("lang_file", (Object)this.getDefaultLanguage());
            config.set("blacklisted_worlds", this.getBlacklistedWorlds());
            config.set("blacklisted_regions", this.getBlacklistedRegions());
            config.set("claim_settings.max_count", (Object)this.getMaxClaimCount());
            config.set("claim_settings.buy_price", (Object)this.getClaimBuyPrice());
            config.set("claim_settings.expand_price", (Object)this.getEachLandBuyPrice());
            config.set("claim_settings.max_coop.default", (Object)this.getMaxCoopPlayers());
            config.set("claim_settings.expiry_days", (Object)this.getClaimExpiryDays());
            config.set("claim_settings.expand_menu_height", (Object)this.getExpandMenuHeight());
            config.set("claim_settings.expand_menu_width", (Object)this.getExpandMenuWidth());
            config.set("time_extension.price_per_minute", (Object)this.getTimeExtensionPricePerMinute());
            config.set("time_extension.price_per_hour", (Object)this.getTimeExtensionPricePerHour());
            config.set("time_extension.price_per_day", (Object)this.getTimeExtensionPricePerDay());
            config.set("time_extension.tax_rate", (Object)this.getTimeExtensionTaxRate());
            config.set("auto_save", (Object)this.getAutoSave());
            config.set("database.enable", (Object)this.isDatabaseEnabled());
            config.set("database.type", (Object)this.getDatabaseType());
            config.set("database.sqlite.file", (Object)this.getSqliteFile());
            config.set("database.mysql.host", (Object)this.getMysqlHost());
            config.set("database.mysql.port", (Object)this.getMysqlPort());
            config.set("database.mysql.database", (Object)this.getMysqlDatabase());
            config.set("database.mysql.user", (Object)this.getMysqlUser());
            config.set("database.mysql.password", (Object)this.getMysqlPassword());
            config.set("database.mysql.maximum_pool_size", (Object)this.getMaximumPoolSize());
            config.set("database.mysql.minimum_idle", (Object)this.getMinimumIdle());
            config.set("database.mysql.idle_timeout", (Object)this.getIdleTimeout());
            config.set("database.mysql.max_lifetime", (Object)this.getMaxLifetime());
            config.set("database.mysql.connection_timeout", (Object)this.getConnectionTimeout());
            config.save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (Exception e) {
            Util.log("&cFailed to save config.yml! " + e.getMessage());
        }
    }

    public int getMaxCoopPlayers(Player player) {
        if (player.isOp() || player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.max_coop_count")) {
            return Integer.MAX_VALUE;
        }
        int maxCoop = config.getInt("claim_settings.max_coop_count.default", 3);
        if (config.isConfigurationSection("claim_settings.max_coop_count")) {
            for (String key : config.getConfigurationSection("claim_settings.max_coop_count").getKeys(false)) {
                int value;
                if (key.equals("default") || !player.hasPermission("nclaim.maxcoop." + key) || (value = config.getInt("claim_settings.max_coop_count." + key)) <= maxCoop) continue;
                maxCoop = value;
            }
        }
        return maxCoop;
    }

    public int getMaxClaimCount(Player player) {
        if (player.isOp() || player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass.max_claim_count")) {
            return Integer.MAX_VALUE;
        }
        int maxClaims = config.getInt("max_claim_count", 3);
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String perm = permInfo.getPermission();
            if (!perm.startsWith("nclaim.maxclaim.")) continue;
            try {
                int value = Integer.parseInt(perm.substring("nclaim.maxclaim.".length()));
                if (value <= maxClaims) continue;
                maxClaims = value;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxClaims;
    }

    public boolean isValidLanguage(String lang) {
        return lang.equals("en-US") || lang.equals("tr-TR");
    }

    public Config updateConfig() {
        String configVersion;
        String version = this.plugin.getDescription().getVersion();
        if (version.equals(configVersion = config.getString("config_version", "0"))) {
            return this;
        }
        InputStream defStream = this.plugin.getResource("config.yml");
        if (defStream == null) {
            Util.log("&cDefault config.yml not found in plugin resources.");
            return this;
        }
        this.saveBackupConfig();
        YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
        for (String key : defConfig.getKeys(true)) {
            if (defConfig.isConfigurationSection(key) || !config.contains(key)) continue;
            defConfig.set(key, config.get(key));
        }
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        try {
            defConfig.set("config_version", (Object)version);
            defConfig.save(file);
            config = defConfig;
            Util.log("&aUpdated config file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save updated config file.");
            e.printStackTrace();
        }
        return this;
    }

    private void saveBackupConfig() {
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = new SimpleDateFormat("dd-MM-yyyy-HH-mm-ss").format(new Date());
        File backupFile = new File(backupDir, "config_" + date + ".yml");
        try {
            config.save(backupFile);
            Util.log("&aBacked up old config file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save backup file.");
            e.printStackTrace();
        }
    }

    @Generated
    public NClaim getPlugin() {
        return this.plugin;
    }

    @Generated
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Generated
    public double getClaimBuyPrice() {
        return this.claimBuyPrice;
    }

    @Generated
    public double getEachLandBuyPrice() {
        return this.eachLandBuyPrice;
    }

    @Generated
    public int getClaimExpiryDays() {
        return this.claimExpiryDays;
    }

    @Generated
    public int getMaxCoopPlayers() {
        return this.maxCoopPlayers;
    }

    @Generated
    public int getMaxClaimCount() {
        return this.maxClaimCount;
    }

    @Generated
    public int getExpandMenuHeight() {
        return this.expandMenuHeight;
    }

    @Generated
    public int getExpandMenuWidth() {
        return this.expandMenuWidth;
    }

    @Generated
    public List<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }

    @Generated
    public List<String> getBlacklistedRegions() {
        return this.blacklistedRegions;
    }

    @Generated
    public int getAutoSave() {
        return this.autoSave;
    }

    @Generated
    public boolean isDatabaseEnabled() {
        return this.databaseEnabled;
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public String getSqliteFile() {
        return this.sqliteFile;
    }

    @Generated
    public String getMysqlHost() {
        return this.mysqlHost;
    }

    @Generated
    public int getMysqlPort() {
        return this.mysqlPort;
    }

    @Generated
    public String getMysqlDatabase() {
        return this.mysqlDatabase;
    }

    @Generated
    public String getMysqlUser() {
        return this.mysqlUser;
    }

    @Generated
    public String getMysqlPassword() {
        return this.mysqlPassword;
    }

    @Generated
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    @Generated
    public int getMinimumIdle() {
        return this.minimumIdle;
    }

    @Generated
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Generated
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Generated
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public double getTimeExtensionPricePerMinute() {
        return this.timeExtensionPricePerMinute;
    }

    @Generated
    public double getTimeExtensionPricePerHour() {
        return this.timeExtensionPricePerHour;
    }

    @Generated
    public double getTimeExtensionPricePerDay() {
        return this.timeExtensionPricePerDay;
    }

    @Generated
    public double getTimeExtensionTaxRate() {
        return this.timeExtensionTaxRate;
    }

    @Generated
    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @Generated
    public void setClaimBuyPrice(double claimBuyPrice) {
        this.claimBuyPrice = claimBuyPrice;
    }

    @Generated
    public void setEachLandBuyPrice(double eachLandBuyPrice) {
        this.eachLandBuyPrice = eachLandBuyPrice;
    }

    @Generated
    public void setClaimExpiryDays(int claimExpiryDays) {
        this.claimExpiryDays = claimExpiryDays;
    }

    @Generated
    public void setMaxCoopPlayers(int maxCoopPlayers) {
        this.maxCoopPlayers = maxCoopPlayers;
    }

    @Generated
    public void setMaxClaimCount(int maxClaimCount) {
        this.maxClaimCount = maxClaimCount;
    }

    @Generated
    public void setExpandMenuHeight(int expandMenuHeight) {
        this.expandMenuHeight = expandMenuHeight;
    }

    @Generated
    public void setExpandMenuWidth(int expandMenuWidth) {
        this.expandMenuWidth = expandMenuWidth;
    }

    @Generated
    public void setBlacklistedWorlds(List<String> blacklistedWorlds) {
        this.blacklistedWorlds = blacklistedWorlds;
    }

    @Generated
    public void setBlacklistedRegions(List<String> blacklistedRegions) {
        this.blacklistedRegions = blacklistedRegions;
    }

    @Generated
    public void setAutoSave(int autoSave) {
        this.autoSave = autoSave;
    }

    @Generated
    public void setDatabaseEnabled(boolean databaseEnabled) {
        this.databaseEnabled = databaseEnabled;
    }

    @Generated
    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    @Generated
    public void setSqliteFile(String sqliteFile) {
        this.sqliteFile = sqliteFile;
    }

    @Generated
    public void setMysqlHost(String mysqlHost) {
        this.mysqlHost = mysqlHost;
    }

    @Generated
    public void setMysqlPort(int mysqlPort) {
        this.mysqlPort = mysqlPort;
    }

    @Generated
    public void setMysqlDatabase(String mysqlDatabase) {
        this.mysqlDatabase = mysqlDatabase;
    }

    @Generated
    public void setMysqlUser(String mysqlUser) {
        this.mysqlUser = mysqlUser;
    }

    @Generated
    public void setMysqlPassword(String mysqlPassword) {
        this.mysqlPassword = mysqlPassword;
    }

    @Generated
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    @Generated
    public void setMinimumIdle(int minimumIdle) {
        this.minimumIdle = minimumIdle;
    }

    @Generated
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Generated
    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    @Generated
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setTimeExtensionPricePerMinute(double timeExtensionPricePerMinute) {
        this.timeExtensionPricePerMinute = timeExtensionPricePerMinute;
    }

    @Generated
    public void setTimeExtensionPricePerHour(double timeExtensionPricePerHour) {
        this.timeExtensionPricePerHour = timeExtensionPricePerHour;
    }

    @Generated
    public void setTimeExtensionPricePerDay(double timeExtensionPricePerDay) {
        this.timeExtensionPricePerDay = timeExtensionPricePerDay;
    }

    @Generated
    public void setTimeExtensionTaxRate(double timeExtensionTaxRate) {
        this.timeExtensionTaxRate = timeExtensionTaxRate;
    }
}

