/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;

public class LandExpansionMenu
extends BaseMenu {
    @NotNull
    private final Claim claim;
    @NotNull
    private final Collection<Chunk> allClaimChunks;
    private final boolean admin;
    private final int height;
    private final int width;
    private final int rows;

    public LandExpansionMenu(@NotNull Player player, @NotNull Claim claim, boolean admin) {
        super("claim_expand_menu");
        this.claim = claim;
        this.allClaimChunks = claim.getAllChunks();
        this.admin = admin;
        this.height = Math.max(1, Math.min(NClaim.inst().getNconfig().getExpandMenuHeight(), 3));
        this.width = Math.max(1, Math.min(NClaim.inst().getNconfig().getExpandMenuWidth(), 3));
        this.rows = Math.min(this.height * 2 + 1, 6);
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        MenuType menuType;
        switch (this.rows) {
            case 1: {
                menuType = MenuType.CHEST_1_ROW;
                break;
            }
            case 2: {
                menuType = MenuType.CHEST_2_ROWS;
                break;
            }
            case 3: {
                menuType = MenuType.CHEST_3_ROWS;
                break;
            }
            case 4: {
                menuType = MenuType.CHEST_4_ROWS;
                break;
            }
            case 5: {
                menuType = MenuType.CHEST_5_ROWS;
                break;
            }
            case 6: {
                menuType = MenuType.CHEST_6_ROWS;
                break;
            }
            default: {
                menuType = MenuType.CHEST_3_ROWS;
            }
        }
        this.createInventory(menuType, this.getString("title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{(LandExpansionMenu.this.rows * 9 - 1) / 2});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(LandExpansionMenu.this.claim.getClaimBlockType()).name(LandExpansionMenu.this.getString("center.display_name")).lore(LandExpansionMenu.this.getStringList("center.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (!LandExpansionMenu.this.admin) {
                    new ClaimManagementMenu(player, LandExpansionMenu.this.claim);
                } else {
                    new AdminClaimManagementMenu(player, LandExpansionMenu.this.claim);
                }
            }
        });
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                int slot = row * 9 + col;
                if (slot == (this.rows * 9 - 1) / 2 || !this.isWithinRange(row, col)) continue;
                this.addDirtButton(slot);
            }
        }
    }

    private boolean isWithinRange(int row, int col) {
        int centerRow = this.rows / 2;
        int centerCol = 4;
        int deltaX = Math.abs(col - centerCol);
        int deltaZ = Math.abs(row - centerRow);
        return deltaX <= this.width && deltaZ <= this.height;
    }

    private void addDirtButton(int slot) {
        Material material;
        String configPath;
        Chunk thatChunk = this.calculateNewChunk(slot);
        Claim thatClaim = Claim.getClaim(thatChunk);
        boolean clickable = false;
        if (this.admin) {
            if (thatClaim == null) {
                configPath = "expand";
                material = Material.BROWN_WOOL;
            } else {
                configPath = "claimed";
                material = Material.LIME_WOOL;
            }
            clickable = true;
        } else if (!this.isAdjacentToClaim(thatChunk)) {
            configPath = "not_adjacent";
            material = Material.BLACK_WOOL;
        } else if (thatClaim == null) {
            configPath = "expand";
            material = Material.BROWN_WOOL;
            clickable = true;
        } else if (this.claim.getLands().contains(NClaim.serializeChunk(thatChunk))) {
            configPath = "claimed";
            material = Material.LIME_WOOL;
            clickable = true;
        } else {
            configPath = "claimed_another_player";
            material = Material.RED_WOOL;
        }
        this.addButton(this.createButton(slot, configPath, material, thatChunk, clickable));
    }

    private Button createButton(final int slot, final String configPath, final Material material, final Chunk thatChunk, final boolean clickable) {
        return new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{slot});
            }

            @Override
            public ItemStack getItem() {
                double landPrice = NClaim.inst().getNconfig().getEachLandBuyPrice();
                String displayName = LandExpansionMenu.this.getString(configPath + ".display_name");
                ArrayList<String> lore = new ArrayList<String>(LandExpansionMenu.this.getStringList(configPath + ".lore"));
                if (configPath.equals("expand")) {
                    lore.replaceAll(s -> s.replace("{price}", String.valueOf(landPrice)));
                }
                return ItemCreator.of(material).name(displayName).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (!clickable) {
                    return;
                }
                if (clickType.isLeftClick() && LandExpansionMenu.this.getInvItem(slot).getType() == Material.BROWN_WOOL) {
                    Consumer<String> onFinish = result -> {
                        if ("confirmed".equals(result)) {
                            NClaim.inst().getClaimService().buyLand(LandExpansionMenu.this.claim, player, thatChunk);
                            new LandExpansionMenu(player, LandExpansionMenu.this.claim, LandExpansionMenu.this.admin);
                        } else if ("declined".equals(result)) {
                            new LandExpansionMenu(player, LandExpansionMenu.this.claim, LandExpansionMenu.this.admin);
                        }
                    };
                    new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu.children.claim_expand.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu.children.claim_expand.lore").stream().map(s -> s.replace("{price}", String.valueOf(NClaim.inst().getNconfig().getEachLandBuyPrice()))).collect(Collectors.toList()), onFinish);
                } else if (clickType.isRightClick() && LandExpansionMenu.this.getInvItem(slot).getType() == Material.LIME_WOOL || clickType.isRightClick() && LandExpansionMenu.this.getInvItem(slot).getType() == Material.BROWN_WOOL) {
                    player.closeInventory();
                    NClaim.inst().getClaimVisualizerService().showClaimBorders(player, thatChunk);
                }
            }
        };
    }

    private boolean isAdjacentToClaim(@NotNull Chunk thatChunk) {
        return this.allClaimChunks.stream().anyMatch(c -> c != null && NClaim.isChunkAdjacent(c, thatChunk, 2));
    }

    private Chunk calculateNewChunk(int slot) {
        int chunkX = this.claim.getChunk().getX();
        int chunkZ = this.claim.getChunk().getZ();
        int centerRow = this.rows / 2;
        int centerCol = 4;
        int row = slot / 9;
        int col = slot % 9;
        int deltaX = col - centerCol;
        int deltaZ = row - centerRow;
        return this.claim.getChunk().getWorld().getChunkAt(chunkX += deltaX, chunkZ += deltaZ);
    }
}

