/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.database;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nesoi.aysihuniks.nclaim.Config;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.database.DatabaseManager;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.ClaimSetting;
import nesoi.aysihuniks.nclaim.model.CoopData;
import nesoi.aysihuniks.nclaim.model.CoopPermission;
import nesoi.aysihuniks.nclaim.model.User;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.nandayo.dapi.Util;

public class SQLiteManager
implements DatabaseManager {
    private final HikariDataSource dataSource;
    private final Gson gson;

    public SQLiteManager(Config config) {
        this.dataSource = this.setupDataSource(config);
        this.gson = new Gson();
        this.initializeDatabase();
    }

    private HikariDataSource setupDataSource(Config config) {
        File databaseFile = new File(NClaim.inst().getDataFolder(), config.getSqliteFile());
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl("jdbc:sqlite:" + databaseFile.getAbsolutePath());
        hikariConfig.setMaximumPoolSize(config.getMaximumPoolSize());
        hikariConfig.setMinimumIdle(config.getMinimumIdle());
        hikariConfig.addDataSourceProperty("foreign_keys", "on");
        hikariConfig.addDataSourceProperty("journal_mode", "WAL");
        hikariConfig.addDataSourceProperty("synchronous", "NORMAL");
        return new HikariDataSource(hikariConfig);
    }

    private void initializeDatabase() {
        try (Connection conn = this.getConnection();){
            this.executeUpdate(conn, "CREATE TABLE IF NOT EXISTS users (uuid TEXT PRIMARY KEY, balance REAL DEFAULT 0, skinTexture TEXT)");
            this.executeUpdate(conn, "CREATE TABLE IF NOT EXISTS claims (claim_id TEXT PRIMARY KEY, chunk_world TEXT, chunk_x INTEGER, chunk_z INTEGER, created_at TEXT DEFAULT CURRENT_TIMESTAMP, expired_at TEXT NULL, owner TEXT, bedrock_location TEXT, lands TEXT, claim_value INTEGER DEFAULT 0)");
            this.executeUpdate(conn, "CREATE TABLE IF NOT EXISTS claim_coops (claim_id TEXT, player_uuid TEXT, joined_at TEXT, permissions TEXT, PRIMARY KEY (claim_id, player_uuid))");
            this.executeUpdate(conn, "CREATE TABLE IF NOT EXISTS claim_settings (claim_id TEXT PRIMARY KEY, settings TEXT)");
            Util.log("&aSQLite tables initialized successfully");
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initialize SQLite tables", e);
        }
    }

    private void executeUpdate(Connection conn, String sql) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.executeUpdate();
        }
    }

    protected Timestamp getTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getClaimCount() {
        String sql = "SELECT COUNT(*) FROM claims";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getUserCount() {
        String sql = "SELECT COUNT(*) FROM users";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public void saveUser(User user) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT OR REPLACE INTO users (uuid, balance, skinTexture) VALUES (?, ?, ?)");){
            stmt.setString(1, user.getUuid().toString());
            stmt.setDouble(2, user.getBalance());
            stmt.setString(3, user.getSkinTexture());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logError("save user data", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User loadUser(UUID uuid) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT balance, skinTexture FROM users WHERE uuid = ?");){
            stmt.setString(1, uuid.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            User user = this.createUserFromResultSet(uuid, rs);
            return user;
        }
        catch (SQLException e) {
            this.logError("load user data", e);
        }
        return null;
    }

    @Override
    public List<User> loadAllUsers() {
        ArrayList<User> users = new ArrayList<User>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT uuid, balance, skinTexture FROM users");){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                users.add(this.createUserFromResultSet(UUID.fromString(rs.getString("uuid")), rs));
            }
        }
        catch (SQLException e) {
            this.logError("load all users", e);
        }
        return users;
    }

    private User createUserFromResultSet(UUID uuid, ResultSet rs) throws SQLException {
        return new User(uuid, rs.getDouble("balance"), rs.getString("skinTexture"), new ArrayList<Claim>(), new ArrayList<Claim>());
    }

    @Override
    public void saveClaim(Claim claim) {
        try (Connection conn = this.getConnection();){
            this.saveClaimData(conn, claim);
            this.saveClaimCoops(conn, claim);
            this.saveClaimSettings(conn, claim);
        }
        catch (SQLException e) {
            this.logError("save claim data", e);
        }
    }

    @Override
    public void saveClaimsBatch(List<Claim> claims) {
        try (Connection conn = this.getConnection();){
            conn.setAutoCommit(false);
            try {
                for (Claim claim : claims) {
                    this.saveClaimData(conn, claim);
                    this.saveClaimCoops(conn, claim);
                    this.saveClaimSettings(conn, claim);
                }
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
            finally {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.logError("save claims batch", e);
        }
    }

    private void saveClaimData(Connection conn, Claim claim) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement("INSERT OR REPLACE INTO claims (claim_id, chunk_world, chunk_x, chunk_z, created_at, expired_at, owner, bedrock_location, lands, claim_value) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            this.prepareClaimStatement(stmt, claim);
            stmt.executeUpdate();
        }
    }

    private void prepareClaimStatement(PreparedStatement stmt, Claim claim) throws SQLException {
        stmt.setString(1, claim.getClaimId());
        stmt.setString(2, claim.getChunk().getWorld().getName());
        stmt.setInt(3, claim.getChunk().getX());
        stmt.setInt(4, claim.getChunk().getZ());
        stmt.setString(5, this.getTimestamp(claim.getCreatedAt()).toString());
        stmt.setString(6, this.getTimestamp(claim.getExpiredAt()).toString());
        stmt.setString(7, claim.getOwner().toString());
        stmt.setString(8, NClaim.serializeLocation(claim.getBedrockLocation()));
        stmt.setString(9, this.gson.toJson(claim.getLands()));
    }

    private void saveClaimCoops(Connection conn, Claim claim) throws SQLException {
        this.executeUpdate(conn, "DELETE FROM claim_coops WHERE claim_id = ?", claim.getClaimId());
        try (PreparedStatement stmt = conn.prepareStatement("INSERT OR REPLACE INTO claim_coops (claim_id, player_uuid, joined_at, permissions) VALUES (?, ?, ?, ?)");){
            for (UUID coopPlayer : claim.getCoopPlayers()) {
                Map<String, Boolean> permissions = this.serializePermissions(claim.getCoopPermissions().get(coopPlayer));
                stmt.setString(1, claim.getClaimId());
                stmt.setString(2, coopPlayer.toString());
                stmt.setString(3, this.getTimestamp(claim.getCoopPlayerJoinDate().get(coopPlayer)).toString());
                stmt.setString(4, this.gson.toJson(permissions));
                stmt.executeUpdate();
            }
        }
    }

    private Map<String, Boolean> serializePermissions(CoopPermission coopPerm) {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        for (Permission perm : Permission.values()) {
            permissions.put(perm.name(), coopPerm.isEnabled(perm));
        }
        return permissions;
    }

    private void saveClaimSettings(Connection conn, Claim claim) throws SQLException {
        HashMap<String, Boolean> settings = new HashMap<String, Boolean>();
        for (Setting setting : Setting.values()) {
            settings.put(setting.name(), claim.getSettings().isEnabled(setting));
        }
        try (PreparedStatement stmt = conn.prepareStatement("INSERT OR REPLACE INTO claim_settings (claim_id, settings) VALUES (?, ?)");){
            stmt.setString(1, claim.getClaimId());
            stmt.setString(2, this.gson.toJson(settings));
            stmt.executeUpdate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Claim loadClaim(String claimId) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM claims WHERE claim_id = ?");){
            stmt.setString(1, claimId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            Claim claim = this.createClaimFromResultSet(rs, conn);
            return claim;
        }
        catch (SQLException e) {
            this.logError("load claim", e);
        }
        return null;
    }

    @Override
    public List<Claim> loadAllClaims() {
        ArrayList<Claim> claims = new ArrayList<Claim>();
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT * FROM claims");){
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                Claim claim = this.createClaimFromResultSet(rs, conn);
                if (claim == null) continue;
                claims.add(claim);
            }
        }
        catch (SQLException e) {
            this.logError("load all claims", e);
        }
        return claims;
    }

    private Claim createClaimFromResultSet(ResultSet rs, Connection conn) throws SQLException {
        World world = Bukkit.getWorld((String)rs.getString("chunk_world"));
        if (world == null) {
            return null;
        }
        Chunk chunk = world.getChunkAt(rs.getInt("chunk_x"), rs.getInt("chunk_z"));
        String claimId = rs.getString("claim_id");
        Timestamp createdAt = Timestamp.valueOf(rs.getString("created_at"));
        Timestamp expiredAt = Timestamp.valueOf(rs.getString("expired_at"));
        UUID owner = UUID.fromString(rs.getString("owner"));
        Location bedrockLocation = NClaim.deserializeLocation(rs.getString("bedrock_location"));
        long claimValue = 0L;
        try {
            claimValue = rs.getLong("claim_value");
        }
        catch (SQLException e) {
            Util.log("&cFailed to read claim_value for claim " + claimId + ": " + e.getMessage());
        }
        Type landType = new TypeToken<Collection<String>>(){}.getType();
        Collection lands = (Collection)this.gson.fromJson(rs.getString("lands"), landType);
        CoopData coopData = this.loadClaimCoops(conn, claimId);
        ClaimSetting settings = this.loadClaimSettings(conn, claimId);
        return new Claim(claimId, chunk, createdAt, expiredAt, owner, bedrockLocation, claimValue, lands, coopData.getCoopPlayers(), coopData.getJoinDates(), coopData.getPermissions(), settings);
    }

    private CoopData loadClaimCoops(Connection conn, String claimId) throws SQLException {
        CoopData coopData = new CoopData();
        try (PreparedStatement stmt = conn.prepareStatement("SELECT * FROM claim_coops WHERE claim_id = ?");){
            stmt.setString(1, claimId);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                UUID playerUuid = UUID.fromString(rs.getString("player_uuid"));
                coopData.getCoopPlayers().add(playerUuid);
                coopData.getJoinDates().put(playerUuid, Timestamp.valueOf(rs.getString("joined_at")));
                Type permType = new TypeToken<Map<String, Boolean>>(){}.getType();
                Map permMap = (Map)this.gson.fromJson(rs.getString("permissions"), permType);
                CoopPermission coopPerm = new CoopPermission();
                for (Map.Entry entry : permMap.entrySet()) {
                    coopPerm.setEnabled(Permission.valueOf((String)entry.getKey()), (Boolean)entry.getValue());
                }
                coopData.getPermissions().put(playerUuid, coopPerm);
            }
        }
        return coopData;
    }

    private ClaimSetting loadClaimSettings(Connection conn, String claimId) throws SQLException {
        ClaimSetting settings = new ClaimSetting();
        try (PreparedStatement stmt = conn.prepareStatement("SELECT * FROM claim_settings WHERE claim_id = ?");){
            stmt.setString(1, claimId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                Type settingsType = new TypeToken<Map<String, Boolean>>(){}.getType();
                Map settingsMap = (Map)this.gson.fromJson(rs.getString("settings"), settingsType);
                for (Map.Entry entry : settingsMap.entrySet()) {
                    settings.set(Setting.valueOf((String)entry.getKey()), (Boolean)entry.getValue());
                }
            }
        }
        return settings;
    }

    @Override
    public void deleteClaim(String claimId) {
        try (Connection conn = this.getConnection();){
            this.executeUpdate(conn, "DELETE FROM claim_coops WHERE claim_id = ?", claimId);
            this.executeUpdate(conn, "DELETE FROM claim_settings WHERE claim_id = ?", claimId);
            this.executeUpdate(conn, "DELETE FROM claims WHERE claim_id = ?", claimId);
        }
        catch (SQLException e) {
            this.logError("delete claim", e);
        }
    }

    private void executeUpdate(Connection conn, String sql, String claimId) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, claimId);
            stmt.executeUpdate();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private void logError(String operation, SQLException e) {
        Util.log("&cFailed to " + operation + ": " + e.getMessage());
    }

    @Override
    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }

    private static final class SQLStatements {
        static final String CREATE_USERS_TABLE = "CREATE TABLE IF NOT EXISTS users (uuid TEXT PRIMARY KEY, balance REAL DEFAULT 0, skinTexture TEXT)";
        static final String CREATE_CLAIMS_TABLE = "CREATE TABLE IF NOT EXISTS claims (claim_id TEXT PRIMARY KEY, chunk_world TEXT, chunk_x INTEGER, chunk_z INTEGER, created_at TEXT DEFAULT CURRENT_TIMESTAMP, expired_at TEXT NULL, owner TEXT, bedrock_location TEXT, lands TEXT, claim_value INTEGER DEFAULT 0)";
        static final String CREATE_CLAIM_COOPS_TABLE = "CREATE TABLE IF NOT EXISTS claim_coops (claim_id TEXT, player_uuid TEXT, joined_at TEXT, permissions TEXT, PRIMARY KEY (claim_id, player_uuid))";
        static final String CREATE_CLAIM_SETTINGS_TABLE = "CREATE TABLE IF NOT EXISTS claim_settings (claim_id TEXT PRIMARY KEY, settings TEXT)";
        static final String SAVE_USER = "INSERT OR REPLACE INTO users (uuid, balance, skinTexture) VALUES (?, ?, ?)";
        static final String LOAD_USER = "SELECT balance, skinTexture FROM users WHERE uuid = ?";
        static final String LOAD_ALL_USERS = "SELECT uuid, balance, skinTexture FROM users";
        static final String SAVE_CLAIM = "INSERT OR REPLACE INTO claims (claim_id, chunk_world, chunk_x, chunk_z, created_at, expired_at, owner, bedrock_location, lands, claim_value) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        static final String LOAD_CLAIM = "SELECT * FROM claims WHERE claim_id = ?";
        static final String LOAD_ALL_CLAIMS = "SELECT * FROM claims";
        static final String DELETE_CLAIM = "DELETE FROM claims WHERE claim_id = ?";
        static final String SAVE_CLAIM_COOP = "INSERT OR REPLACE INTO claim_coops (claim_id, player_uuid, joined_at, permissions) VALUES (?, ?, ?, ?)";
        static final String LOAD_CLAIM_COOPS = "SELECT * FROM claim_coops WHERE claim_id = ?";
        static final String DELETE_CLAIM_COOPS = "DELETE FROM claim_coops WHERE claim_id = ?";
        static final String SAVE_CLAIM_SETTINGS = "INSERT OR REPLACE INTO claim_settings (claim_id, settings) VALUES (?, ?)";
        static final String LOAD_CLAIM_SETTINGS = "SELECT * FROM claim_settings WHERE claim_id = ?";
        static final String DELETE_CLAIM_SETTINGS = "DELETE FROM claim_settings WHERE claim_id = ?";

        private SQLStatements() {
        }
    }
}

