/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.hologram;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.HoloEnum;
import nesoi.aysihuniks.nclaim.hologram.DecentHologramHandler;
import nesoi.aysihuniks.nclaim.hologram.FancyHologramHandler;
import nesoi.aysihuniks.nclaim.hologram.HologramHandler;
import nesoi.aysihuniks.nclaim.model.Claim;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.Util;

public class HologramManager {
    private final NClaim plugin;
    private static final double DECENT_HOLO_OFFSET = 3.0;
    private static final double FANCY_HOLO_OFFSET = 1.5;
    private HologramHandler hologramHandler;
    private static final Pattern HOLOGRAM_ID_PATTERN = Pattern.compile("claim_(.+)_(-?\\d+)_(-?\\d+)");

    public HologramManager(NClaim plugin) {
        this.plugin = plugin;
        this.initializeHologramHandler();
        new BukkitRunnable(){

            public void run() {
                HologramManager.this.cleanupOrphanedHolograms();
            }
        }.runTaskLater((Plugin)plugin, 60L);
    }

    private void initializeHologramHandler() {
        if (HoloEnum.getActiveHologram() == HoloEnum.DECENT_HOLOGRAM) {
            this.hologramHandler = new DecentHologramHandler();
        } else if (HoloEnum.getActiveHologram() == HoloEnum.FANCY_HOLOGRAM) {
            this.hologramHandler = new FancyHologramHandler();
        } else {
            throw new IllegalStateException("No supported hologram plugin found!");
        }
    }

    public void cleanupOrphanedHolograms() {
        Util.log("&eStarting orphaned hologram cleanup... ");
        List<String> allHologramIds = this.hologramHandler.getHologramIds();
        int removedCount = 0;
        for (String hologramId : allHologramIds) {
            ChunkInfo chunkInfo;
            if (!hologramId.startsWith("claim_") || (chunkInfo = this.parseHologramId(hologramId)) == null) continue;
            World world = Bukkit.getWorld((String)chunkInfo.worldName);
            if (world == null) {
                Util.log("&cWorld not found, removing hologram: &f" + hologramId);
                this.hologramHandler.deleteHologram(hologramId);
                ++removedCount;
                continue;
            }
            Chunk chunk = world.getChunkAt(chunkInfo.x, chunkInfo.z);
            Claim claim = Claim.getClaim(chunk);
            if (claim != null) continue;
            Util.log("&aClaim not found, removing hologram: &f" + hologramId);
            this.hologramHandler.deleteHologram(hologramId);
            ++removedCount;
        }
        Util.log("&aOrphaned hologram cleanup completed. Removed &f" + removedCount + " &aholograms.");
    }

    private ChunkInfo parseHologramId(String hologramId) {
        Matcher matcher = HOLOGRAM_ID_PATTERN.matcher(hologramId);
        if (!matcher.matches()) {
            return null;
        }
        try {
            String worldName = matcher.group(1);
            int x = Integer.parseInt(matcher.group(2));
            int z = Integer.parseInt(matcher.group(3));
            return new ChunkInfo(worldName, x, z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void forceCleanup() {
        new BukkitRunnable(){

            public void run() {
                HologramManager.this.cleanupOrphanedHolograms();
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void createHologram(Location location) {
        Chunk chunk = location.getChunk();
        Claim claim = Claim.getClaim(chunk);
        if (claim == null) {
            return;
        }
        String hologramId = this.getHologramId(chunk);
        List<String> lines = this.generateHologramLines(claim);
        Location adjustedLocation = this.getAdjustedLocation(location.clone());
        this.deleteHologram(chunk);
        this.hologramHandler.createHologram(hologramId, adjustedLocation, lines);
    }

    public void deleteHologram(Chunk chunk) {
        String hologramId = this.getHologramId(chunk);
        this.hologramHandler.deleteHologram(hologramId);
    }

    private Location getAdjustedLocation(Location location) {
        double offset = HoloEnum.getActiveHologram() == HoloEnum.DECENT_HOLOGRAM ? 3.0 : 1.5;
        return location.add(0.5, offset, 0.5);
    }

    private String getHologramId(Chunk chunk) {
        return "claim_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ();
    }

    private List<String> generateHologramLines(Claim claim) {
        ArrayList<String> lines = new ArrayList<String>();
        Chunk chunk = claim.getChunk();
        lines.add(this.plugin.getLangManager().getString("hologram.title"));
        lines.add(this.plugin.getLangManager().getString("hologram.owner").replace("{owner}", "%nclaim_owner_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ() + "%"));
        lines.add(this.plugin.getLangManager().getString("hologram.time_left").replace("{time_left}", "%nclaim_expiration_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ() + "%"));
        int coopCount = claim.getCoopPlayers().size();
        if (coopCount > 0) {
            lines.add(this.plugin.getLangManager().getString("hologram.coop_count").replace("{coop_count}", "%nclaim_coop_count_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ() + "%"));
        }
        lines.add(this.plugin.getLangManager().getString("hologram.total_size").replace("{total_size}", "%nclaim_total_size_" + chunk.getWorld().getName() + "_" + chunk.getX() + "_" + chunk.getZ() + "%"));
        lines.add("");
        lines.add(this.plugin.getLangManager().getString("hologram.edit"));
        return lines.stream().map(HexUtil::parse).collect(Collectors.toList());
    }

    private static class ChunkInfo {
        final String worldName;
        final int x;
        final int z;

        ChunkInfo(String worldName, int x, int z) {
            this.worldName = worldName;
            this.x = x;
            this.z = z;
        }
    }
}

