/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.integrations;

import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Balance;
import nesoi.aysihuniks.nclaim.model.ChunkAndClaim;
import nesoi.aysihuniks.nclaim.model.ChunkValueResult;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.User;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Expansion
extends PlaceholderExpansion {
    private final NClaim plugin;

    public Expansion(NClaim plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getAuthor() {
        return "aysihuniks";
    }

    @NotNull
    public String getIdentifier() {
        return "nclaim";
    }

    @NotNull
    public String getVersion() {
        return "1.0";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (params.isEmpty()) {
            return null;
        }
        if (params.equals("player_balance")) {
            return this.handlePlayerBalance(player);
        }
        if (params.startsWith("get_")) {
            return this.handleConfigPlaceholder(params);
        }
        if (params.startsWith("claim_main_value_")) {
            return this.handleClaimMainValue(params);
        }
        if (params.startsWith("claim_total_value_")) {
            return this.handleClaimTotalValue(params);
        }
        if (params.startsWith("block_value_")) {
            return this.handleBlockValue(params);
        }
        if (params.startsWith("expiration_") || params.startsWith("owner_") || params.startsWith("coop_count_") || params.startsWith("total_size_")) {
            return this.handleClaimInfo(params);
        }
        return null;
    }

    @Nullable
    private String handlePlayerBalance(Player player) {
        if (player == null) {
            return null;
        }
        if (NClaim.inst().getBalanceSystem() == Balance.VAULT) {
            return String.valueOf(NClaim.inst().getEconomy().getBalance((OfflinePlayer)player));
        }
        return String.valueOf(User.getUser(player.getUniqueId()).getBalance());
    }

    @Nullable
    private String handleConfigPlaceholder(String params) {
        String[] parts = params.split("_");
        if (parts.length < 3) {
            return "Invalid config placeholder format";
        }
        String dataType = parts[1];
        String path = parts[2];
        if ("string".equals(dataType)) {
            return this.plugin.getConfigManager().getString(path, "Null");
        }
        if ("int".equals(dataType)) {
            return String.valueOf(this.plugin.getConfigManager().getInt(path, 0));
        }
        if ("boolean".equals(dataType)) {
            return String.valueOf(this.plugin.getConfigManager().getBoolean(path, false));
        }
        if ("list".equals(dataType)) {
            return this.handleListConfig(parts, path);
        }
        return "Unknown config data type: " + dataType;
    }

    private String handleListConfig(String[] parts, String path) {
        if (parts.length < 4) {
            return "Invalid list placeholder: Index required";
        }
        try {
            int index = Integer.parseInt(parts[3]);
            List<String> list = this.plugin.getConfigManager().getStringList(path);
            if (list == null || list.isEmpty()) {
                return "List Not Found";
            }
            if (index < 0 || index >= list.size()) {
                return "Invalid Index";
            }
            return list.get(index);
        }
        catch (NumberFormatException e) {
            return "Invalid Index Format";
        }
    }

    private ChunkValueResult getChunkValue(String params, boolean includeAllChunks) {
        String[] parts = params.split("_");
        if (parts.length < 5) {
            return new ChunkValueResult(0L, "Invalid format: Expected at least 5 parts");
        }
        ChunkAndClaim result = this.parseChunkAndClaim(parts[3], parts[4], parts[5]);
        if (result.getError() != null) {
            return new ChunkValueResult(0L, result.getError());
        }
        Chunk mainChunk = result.getChunk();
        Claim claim = result.getClaim();
        if (mainChunk == null || !includeAllChunks && claim == null) {
            return new ChunkValueResult(0L, "Chunk not found or not claimed");
        }
        if (includeAllChunks && claim != null) {
            return new ChunkValueResult(this.plugin.getBlockValueManager().calculateClaimValue(claim), null);
        }
        return new ChunkValueResult(this.plugin.getBlockValueManager().calculateChunkValue(mainChunk), null);
    }

    @NotNull
    private String handleClaimMainValue(String params) {
        ChunkValueResult result = this.getChunkValue(params, false);
        return result.getError() != null ? result.getError() : String.valueOf(result.getValue());
    }

    @NotNull
    private String handleClaimTotalValue(String params) {
        ChunkValueResult result = this.getChunkValue(params, true);
        return result.getError() != null ? result.getError() : String.valueOf(result.getValue());
    }

    @NotNull
    private String handleBlockValue(String params) {
        String materialName = params.substring("block_value_".length()).toUpperCase();
        try {
            Material material = Material.valueOf((String)materialName);
            return String.valueOf(this.plugin.getBlockValueManager().getBlockValue(material));
        }
        catch (IllegalArgumentException e) {
            return "Invalid material: " + materialName;
        }
    }

    @Nullable
    private String handleClaimInfo(String params) {
        int worldIndex;
        ChunkAndClaim result;
        String[] parts = params.split("_");
        if (parts.length < 4) {
            return "Invalid placeholder format";
        }
        String prefix = parts[0];
        if (prefix.equals("total") || prefix.equals("coop_count")) {
            if (parts.length < 5) {
                return "Invalid format for " + prefix;
            }
            prefix = prefix + "_" + parts[1];
        }
        if ((result = this.parseChunkAndClaim(parts[worldIndex = parts.length - 3], parts[worldIndex + 1], parts[worldIndex + 2])).getError() != null) {
            return result.getError();
        }
        Claim claim = result.getClaim();
        if (claim == null) {
            return "Claim not found";
        }
        if ("expiration".equals(prefix)) {
            return this.plugin.getClaimExpirationManager().getFormattedTimeLeft(claim);
        }
        if ("owner".equals(prefix)) {
            OfflinePlayer claimOwner = Bukkit.getOfflinePlayer((UUID)claim.getOwner());
            return claimOwner.getName() != null ? claimOwner.getName() : "Owner not found";
        }
        if ("coop_count".equals(prefix)) {
            return String.valueOf(claim.getCoopPlayers().size());
        }
        if ("total_size".equals(prefix)) {
            return String.valueOf(1 + claim.getLands().size());
        }
        return "Unknown placeholder prefix: " + prefix;
    }

    private ChunkAndClaim parseChunkAndClaim(String worldName, String chunkXStr, String chunkZStr) {
        try {
            int chunkX = Integer.parseInt(chunkXStr);
            int chunkZ = Integer.parseInt(chunkZStr);
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                return new ChunkAndClaim(null, null, "World not found: " + worldName);
            }
            Chunk chunk = world.getChunkAt(chunkX, chunkZ);
            return new ChunkAndClaim(chunk, Claim.getClaim(chunk), null);
        }
        catch (NumberFormatException e) {
            return new ChunkAndClaim(null, null, "Invalid coordinates");
        }
    }
}

