/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.model;

import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.HologramManager;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.api.events.ClaimRemoveEvent;
import nesoi.aysihuniks.nclaim.enums.HoloEnum;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.model.ClaimSetting;
import nesoi.aysihuniks.nclaim.model.CoopPermission;
import nesoi.aysihuniks.nclaim.model.User;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.object.DParticle;

public class Claim {
    private NClaim plugin = NClaim.inst();
    @NotNull
    private final String claimId;
    @NotNull
    private final Chunk chunk;
    @NotNull
    private final Date createdAt;
    @NotNull
    private Date expiredAt;
    @NotNull
    private final UUID owner;
    @NotNull
    private final Location bedrockLocation;
    private long claimValue;
    private final Collection<String> lands;
    private final Collection<UUID> coopPlayers;
    private final HashMap<UUID, Date> coopPlayerJoinDate;
    private final HashMap<UUID, CoopPermission> coopPermissions;
    private final ClaimSetting settings;
    public static Collection<Claim> claims = new ArrayList<Claim>();

    public Claim(@NotNull String claimId, @NotNull Chunk chunk, @NotNull Date createdAt, @NotNull Date expiredAt, @NotNull UUID owner, @NotNull Location bedrockLocation, long claimValue, Collection<String> lands, Collection<UUID> coopPlayers, HashMap<UUID, Date> coopPlayerJoinDate, HashMap<UUID, CoopPermission> coopPermissions, ClaimSetting settings) {
        this.claimId = claimId;
        this.chunk = chunk;
        this.createdAt = createdAt;
        this.expiredAt = expiredAt;
        this.owner = owner;
        this.bedrockLocation = bedrockLocation;
        this.claimValue = claimValue;
        this.lands = lands;
        this.coopPlayers = coopPlayers;
        this.coopPlayerJoinDate = coopPlayerJoinDate;
        this.coopPermissions = coopPermissions;
        this.settings = settings;
        claims.removeIf(c -> c.getClaimId().equals(claimId));
        claims.add(this);
    }

    public Collection<Chunk> getAllChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        chunks.add(this.chunk);
        this.getLands().forEach(l -> chunks.add(NClaim.deserializeChunk(l)));
        return chunks;
    }

    public static Claim getClaim(@NotNull Chunk chunk) {
        return claims.stream().filter(c -> c.getChunk().equals((Object)chunk) || c.getLands().contains(chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ())).findFirst().orElse(null);
    }

    public void remove(RemoveCause cause) {
        ClaimRemoveEvent removeEvent = new ClaimRemoveEvent(this, cause);
        Bukkit.getPluginManager().callEvent((Event)removeEvent);
        if (removeEvent.isCancelled()) {
            Player owner = Bukkit.getPlayer((UUID)this.getOwner());
            if (owner != null) {
                owner.sendMessage(this.plugin.getLangManager().getString("claim.remove_cancelled"));
            }
            return;
        }
        World world = this.getChunk().getWorld();
        Location bedrock = this.getBedrockLocation();
        bedrock.getBlock().setType(Material.AIR);
        String hologramId = "claim_" + world.getName() + "_" + this.getChunk().getX() + "_" + this.getChunk().getZ();
        if (HoloEnum.getActiveHologram() == HoloEnum.DECENT_HOLOGRAM) {
            Hologram hologram = DHAPI.getHologram((String)hologramId);
            if (hologram != null) {
                hologram.delete();
            }
        } else {
            HologramManager manager = FancyHologramsPlugin.get().getHologramManager();
            manager.getHologram(hologramId).ifPresent(arg_0 -> ((HologramManager)manager).removeHologram(arg_0));
        }
        int centerX = this.getChunk().getX() * 16 + 8;
        int centerZ = this.getChunk().getZ() * 16 + 8;
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            player2.sendMessage(this.plugin.getLangManager().getString("claim.expired").replace("{x}", String.valueOf(centerX)).replace("{z}", String.valueOf(centerZ)));
            double distance = player2.getLocation().distance(bedrock);
            float volume = (float)Math.max(0.2, 1.0 - distance / 16.0);
            world.playSound(bedrock, Sound.ENTITY_GENERIC_EXPLODE, volume, 1.0f);
        }
        User.getUser(this.getOwner()).getPlayerClaims().remove(this);
        User.saveUser(this.getOwner());
        this.getCoopPlayers().stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> {
            User user = User.getUser(player.getUniqueId());
            user.getCoopClaims().remove(this);
            User.saveUser(player.getUniqueId());
        });
        world.spawnParticle(NClaim.getParticle(DParticle.LARGE_SMOKE, DParticle.SMOKE_LARGE), bedrock, 1);
        world.playSound(bedrock, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            if ("mysql".equals(this.plugin.getNconfig().getDatabaseType())) {
                this.plugin.getMySQLManager().deleteClaim(this.getClaimId());
            } else {
                this.plugin.getSqLiteManager().deleteClaim(this.getClaimId());
            }
        }
        claims.remove(this);
    }

    @Generated
    public NClaim getPlugin() {
        return this.plugin;
    }

    @NotNull
    @Generated
    public String getClaimId() {
        return this.claimId;
    }

    @NotNull
    @Generated
    public Chunk getChunk() {
        return this.chunk;
    }

    @NotNull
    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    @Generated
    public Date getExpiredAt() {
        return this.expiredAt;
    }

    @NotNull
    @Generated
    public UUID getOwner() {
        return this.owner;
    }

    @NotNull
    @Generated
    public Location getBedrockLocation() {
        return this.bedrockLocation;
    }

    @Generated
    public long getClaimValue() {
        return this.claimValue;
    }

    @Generated
    public Collection<String> getLands() {
        return this.lands;
    }

    @Generated
    public Collection<UUID> getCoopPlayers() {
        return this.coopPlayers;
    }

    @Generated
    public HashMap<UUID, Date> getCoopPlayerJoinDate() {
        return this.coopPlayerJoinDate;
    }

    @Generated
    public HashMap<UUID, CoopPermission> getCoopPermissions() {
        return this.coopPermissions;
    }

    @Generated
    public ClaimSetting getSettings() {
        return this.settings;
    }

    @Generated
    public void setPlugin(NClaim plugin) {
        this.plugin = plugin;
    }

    @Generated
    public void setExpiredAt(@NotNull Date expiredAt) {
        if (expiredAt == null) {
            throw new NullPointerException("expiredAt is marked non-null but is null");
        }
        this.expiredAt = expiredAt;
    }

    @Generated
    public void setClaimValue(long claimValue) {
        this.claimValue = claimValue;
    }

    @Generated
    public static Collection<Claim> getClaims() {
        return claims;
    }
}

