/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.Claim;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.nandayo.dapi.Util;

public class User {
    private static final Collection<User> users = new ArrayList<User>();
    private final UUID uuid;
    private double balance;
    private String skinTexture;
    private final Collection<Claim> playerClaims;
    private final Collection<Claim> coopClaims;

    public User(UUID uuid, double balance, String skinTexture, Collection<Claim> playerClaims, Collection<Claim> coopClaims) {
        this.uuid = uuid;
        this.balance = balance;
        this.skinTexture = skinTexture;
        this.playerClaims = playerClaims;
        this.coopClaims = coopClaims;
        users.add(this);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public void addBalance(double amount) {
        this.balance += amount;
    }

    public static User getUser(UUID uuid) {
        return users.stream().filter(user -> user.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    public static void loadUser(UUID uuid) {
        if (User.getUser(uuid) != null) {
            return;
        }
        if (NClaim.inst().getNconfig().isDatabaseEnabled() && NClaim.inst().getMySQLManager() != null) {
            User.loadFromDatabase(uuid);
        } else {
            User.loadFromYaml(uuid);
        }
    }

    private static void loadFromDatabase(UUID uuid) {
        User user = NClaim.inst().getMySQLManager().loadUser(uuid);
        if (user == null) {
            user = User.createNewUser(uuid);
        }
        User.updateClaimCollections(user);
    }

    private static void loadFromYaml(UUID uuid) {
        File folder = new File(NClaim.inst().getDataFolder(), "players");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, uuid + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        double balance = config.getDouble("balance");
        String skinTexture = config.getString("skinTexture", null);
        User user = new User(uuid, balance, skinTexture, new ArrayList<Claim>(), new ArrayList<Claim>());
        User.updateClaimCollections(user);
    }

    private static User createNewUser(UUID uuid) {
        return new User(uuid, 0.0, null, new ArrayList<Claim>(), new ArrayList<Claim>());
    }

    private static void updateClaimCollections(User user) {
        user.getPlayerClaims().clear();
        user.getCoopClaims().clear();
        user.getPlayerClaims().addAll(Claim.getClaims().stream().filter(c -> c.getOwner().equals(user.getUuid())).collect(Collectors.toList()));
        user.getCoopClaims().addAll(Claim.getClaims().stream().filter(c -> c.getCoopPlayers().contains(user.getUuid())).collect(Collectors.toList()));
    }

    public static void saveUser(UUID uuid) {
        User user = User.getUser(uuid);
        if (user == null) {
            return;
        }
        if (NClaim.inst().getNconfig().isDatabaseEnabled()) {
            NClaim.inst().getMySQLManager().saveUser(user);
        } else {
            User.saveToYaml(user);
        }
    }

    private static void saveToYaml(User user) {
        File folder = new File(NClaim.inst().getDataFolder(), "players");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, user.getUuid() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("balance", (Object)user.getBalance());
        config.set("skinTexture", (Object)user.getSkinTexture());
        try {
            config.save(file);
        }
        catch (Exception e) {
            Util.log("&cFailed to save user data to YAML: " + e.getMessage());
        }
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public double getBalance() {
        return this.balance;
    }

    @Generated
    public String getSkinTexture() {
        return this.skinTexture;
    }

    @Generated
    public Collection<Claim> getPlayerClaims() {
        return this.playerClaims;
    }

    @Generated
    public Collection<Claim> getCoopClaims() {
        return this.coopClaims;
    }

    @Generated
    public void setBalance(double balance) {
        this.balance = balance;
    }

    @Generated
    public void setSkinTexture(String skinTexture) {
        this.skinTexture = skinTexture;
    }
}

