/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import java.util.Date;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.api.events.ClaimCoopAddEvent;
import nesoi.aysihuniks.nclaim.api.events.ClaimCoopPermissionCategoryToggleEvent;
import nesoi.aysihuniks.nclaim.api.events.ClaimCoopPermissionToggleEvent;
import nesoi.aysihuniks.nclaim.api.events.ClaimCoopRemoveEvent;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.PermissionCategory;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.CoopPermission;
import nesoi.aysihuniks.nclaim.model.User;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ClaimCoopManager {
    private final NClaim plugin;

    public boolean hasPermission(Player player, Claim claim, Permission permission) {
        if (player.hasPermission("nclaim.bypass") || this.isClaimOwner(claim, player)) {
            return true;
        }
        UUID playerUuid = player.getUniqueId();
        if (!claim.getCoopPlayers().contains(playerUuid)) {
            return false;
        }
        return claim.getCoopPermissions().get(playerUuid).isEnabled(permission);
    }

    public void addCoopPlayer(Claim claim, Player owner, Player coopPlayer) {
        if (!this.canAddCoop(claim, owner, coopPlayer)) {
            return;
        }
        UUID coopUUID = coopPlayer.getUniqueId();
        ClaimCoopAddEvent addEvent = new ClaimCoopAddEvent(owner, coopPlayer, claim);
        Bukkit.getPluginManager().callEvent((Event)addEvent);
        if (addEvent.isCancelled()) {
            owner.sendMessage(this.plugin.getLangManager().getString("claim.coop.add_cancelled"));
            return;
        }
        this.addCoopToClaimData(claim, coopUUID);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getMySQLManager().saveClaim(claim);
        }
        owner.sendMessage(this.plugin.getLangManager().getString("claim.coop.added").replace("{coop}", coopPlayer.getName()));
        coopPlayer.sendMessage(this.plugin.getLangManager().getString("claim.coop.joined").replace("{owner}", owner.getName()));
    }

    public void removeCoopPlayer(Claim claim, Player owner, UUID coopUUID) {
        Player coopPlayer;
        String coopName;
        if (!this.isClaimOwner(claim, owner)) {
            owner.sendMessage(this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        ClaimCoopRemoveEvent removeEvent = new ClaimCoopRemoveEvent(owner, coopUUID, claim);
        Bukkit.getPluginManager().callEvent((Event)removeEvent);
        if (removeEvent.isCancelled()) {
            owner.sendMessage(this.plugin.getLangManager().getString("claim.coop.remove_cancelled"));
            return;
        }
        this.removeCoopFromClaimData(claim, coopUUID);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getMySQLManager().saveClaim(claim);
        }
        String string = coopName = (coopPlayer = Bukkit.getPlayer((UUID)coopUUID)) != null ? coopPlayer.getName() : coopUUID.toString();
        if (coopPlayer != null) {
            coopPlayer.sendMessage(this.plugin.getLangManager().getString("claim.coop.kicked").replace("{owner}", owner.getName()));
        }
        owner.sendMessage(this.plugin.getLangManager().getString("claim.coop.removed").replace("{coop}", coopName));
    }

    public void toggleCoopPermission(@NotNull Claim claim, @NotNull UUID player, @NotNull Permission permission) {
        boolean newState = !claim.getCoopPermissions().get(player).isEnabled(permission);
        ClaimCoopPermissionToggleEvent toggleEvent = new ClaimCoopPermissionToggleEvent(Bukkit.getPlayer((UUID)claim.getOwner()), player, claim, permission, newState);
        Bukkit.getPluginManager().callEvent((Event)toggleEvent);
        if (toggleEvent.isCancelled()) {
            Player owner = Bukkit.getPlayer((UUID)claim.getOwner());
            if (owner != null) {
                owner.sendMessage(this.plugin.getLangManager().getString("claim.coop.permission_toggle_cancelled"));
            }
            return;
        }
        claim.getCoopPermissions().get(player).toggle(permission);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getMySQLManager().saveClaim(claim);
        }
    }

    public void toggleCoopPermissionCategory(Claim claim, @NotNull UUID player, @NotNull PermissionCategory category) {
        boolean currentState = claim.getCoopPermissions().get(player).hasAllPermissionsInCategory(category);
        boolean newState = !currentState;
        ClaimCoopPermissionCategoryToggleEvent toggleEvent = new ClaimCoopPermissionCategoryToggleEvent(Bukkit.getPlayer((UUID)claim.getOwner()), player, claim, category, newState);
        Bukkit.getPluginManager().callEvent((Event)toggleEvent);
        if (toggleEvent.isCancelled()) {
            Player owner = Bukkit.getPlayer((UUID)claim.getOwner());
            if (owner != null) {
                owner.sendMessage(this.plugin.getLangManager().getString("claim.coop.permission_category_toggle_cancelled"));
            }
            return;
        }
        claim.getCoopPermissions().get(player).setAllPermissionsInCategory(category, newState);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getMySQLManager().saveClaim(claim);
        }
    }

    private void addCoopToClaimData(Claim claim, UUID coopUUID) {
        claim.getCoopPlayers().add(coopUUID);
        claim.getCoopPlayerJoinDate().put(coopUUID, new Date());
        claim.getCoopPermissions().put(coopUUID, new CoopPermission());
        User.getUser(coopUUID).getCoopClaims().add(claim);
        User.saveUser(coopUUID);
    }

    private void removeCoopFromClaimData(Claim claim, UUID coopUUID) {
        claim.getCoopPlayers().remove(coopUUID);
        claim.getCoopPlayerJoinDate().remove(coopUUID);
        claim.getCoopPermissions().remove(coopUUID);
        User.getUser(coopUUID).getCoopClaims().remove(claim);
        User.saveUser(coopUUID);
    }

    private boolean canAddCoop(Claim claim, Player owner, Player coopPlayer) {
        if (!this.isClaimOwner(claim, owner)) {
            owner.sendMessage(this.plugin.getLangManager().getString("claim.not_yours"));
            return false;
        }
        UUID coopUUID = coopPlayer.getUniqueId();
        if (claim.getOwner().equals(coopUUID)) {
            owner.sendMessage(this.plugin.getLangManager().getString("command.player.cant_add_self"));
            return false;
        }
        if (this.isCoopPlayer(claim, coopUUID)) {
            owner.sendMessage(this.plugin.getLangManager().getString("claim.coop.already_added").replace("{coop}", coopPlayer.getName()));
            return false;
        }
        if (claim.getCoopPlayers().size() >= this.plugin.getNconfig().getMaxCoopPlayers()) {
            owner.sendMessage(this.plugin.getLangManager().getString("claim.coop.limit_reached"));
            return false;
        }
        return true;
    }

    public boolean isClaimOwner(Claim claim, Player player) {
        return claim.getOwner().equals(player.getUniqueId());
    }

    private boolean isCoopPlayer(Claim claim, UUID playerUUID) {
        return claim.getCoopPlayers().contains(playerUUID);
    }

    public boolean getCoopPermissionState(Claim claim, @NotNull UUID player, @NotNull Permission permission) {
        return claim.getCoopPermissions().get(player).isEnabled(permission);
    }

    @Generated
    public ClaimCoopManager(NClaim plugin) {
        this.plugin = plugin;
    }
}

