/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.api.events.ClaimSettingChangeEvent;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.model.Claim;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ClaimSettingsManager {
    private final NClaim plugin;

    public void toggleSetting(Claim claim, Player player, Setting setting) {
        if (!this.isAuthorized(claim, player)) {
            player.sendMessage(this.plugin.getLangManager().getString("command.permission_denied"));
            return;
        }
        boolean newState = !claim.getSettings().isEnabled(setting);
        ClaimSettingChangeEvent changeEvent = new ClaimSettingChangeEvent(claim, claim.getSettings(), player, newState);
        Bukkit.getPluginManager().callEvent((Event)changeEvent);
        if (changeEvent.isCancelled()) {
            player.sendMessage(this.plugin.getLangManager().getString("claim.setting_change_cancelled"));
            return;
        }
        claim.getSettings().set(setting, newState);
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            this.plugin.getMySQLManager().saveClaim(claim);
        }
    }

    public boolean isSettingEnabled(Claim claim, Setting setting) {
        return claim.getSettings().isEnabled(setting);
    }

    private boolean isAuthorized(Claim claim, Player player) {
        return claim.getOwner().equals(player.getUniqueId()) || player.hasPermission("nclaim.admin");
    }

    @Generated
    public ClaimSettingsManager(NClaim plugin) {
        this.plugin = plugin;
    }
}

