/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.ClaimSetting;
import nesoi.aysihuniks.nclaim.model.CoopData;
import nesoi.aysihuniks.nclaim.model.CoopPermission;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.nandayo.dapi.Util;

public class ClaimStorageManager {
    private final NClaim plugin;
    private volatile boolean isLoading = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadClaims() {
        if (this.isLoading) {
            Util.log("&cClaims are already being loaded, skipping duplicate call.");
            return;
        }
        this.isLoading = true;
        try {
            if (this.plugin.getNconfig().isDatabaseEnabled()) {
                Claim.claims.clear();
                List<Claim> loadedClaims = this.plugin.getDatabaseManager().loadAllClaims();
                Claim.claims.addAll(loadedClaims);
                for (Claim claim : Claim.claims) {
                    long value = this.plugin.getBlockValueManager().calculateClaimValue(claim);
                    claim.setClaimValue(value);
                }
                Util.log("&eLoaded " + Claim.claims.size() + " claims from database.");
                return;
            }
            Claim.claims.clear();
            File file = new File(this.plugin.getDataFolder(), "claims.yml");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            ConfigurationSection section = config.getConfigurationSection("chunks_claimed");
            if (section == null) {
                return;
            }
            int loadedCount = 0;
            for (String claimId : section.getKeys(false)) {
                Claim claim = this.loadClaim(section, claimId);
                if (claim == null) continue;
                long value = this.plugin.getBlockValueManager().calculateClaimValue(claim);
                claim.setClaimValue(value);
                ++loadedCount;
            }
            Util.log("&eLoaded " + loadedCount + " claims from file.");
        }
        finally {
            this.isLoading = false;
        }
    }

    public void saveClaims() {
        if (this.plugin.getNconfig().isDatabaseEnabled()) {
            try {
                this.plugin.getMySQLManager().saveClaimsBatch(new ArrayList<Claim>(Claim.claims));
                Util.log("&eSaved " + Claim.claims.size() + " claims to database.");
            }
            catch (Exception e) {
                Util.log("&cFailed to save claims to database: " + e.getMessage());
            }
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        for (Claim claim : Claim.claims) {
            this.saveClaim((FileConfiguration)config, claim);
        }
        try {
            File file = new File(this.plugin.getDataFolder(), "claims.yml");
            config.save(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Claim loadClaim(ConfigurationSection section, String claimId) {
        String[] chunkParts = claimId.split("_");
        if (chunkParts.length != 3) {
            return null;
        }
        World world = Bukkit.getWorld((String)chunkParts[0]);
        if (world == null) {
            return null;
        }
        try {
            int x = Integer.parseInt(chunkParts[1]);
            int z = Integer.parseInt(chunkParts[2]);
            Date createdAt = NClaim.deserializeDate(section.getString(claimId + ".created_at"));
            Date expiredAt = NClaim.deserializeDate(section.getString(claimId + ".expired_at"));
            UUID owner = UUID.fromString(section.getString(claimId + ".owner", ""));
            Location bedrockLocation = NClaim.deserializeLocation(section.getString(claimId + ".bedrock_location"));
            long claimValue = section.getLong(claimId + ".value", 0L);
            if (createdAt == null || expiredAt == null || bedrockLocation == null) {
                return null;
            }
            List lands = section.getStringList(claimId + ".lands");
            CoopData coopData = this.loadCoopData(section.getConfigurationSection(claimId + ".coops"));
            ClaimSetting settings = this.loadClaimSettings(section.getConfigurationSection(claimId + ".settings"));
            return new Claim(claimId, world.getChunkAt(x, z), createdAt, expiredAt, owner, bedrockLocation, claimValue, lands, coopData.getCoopPlayers(), coopData.getJoinDates(), coopData.getPermissions(), settings);
        }
        catch (Exception e) {
            Util.log("&cError loading claim " + claimId + ": " + e.getMessage());
            return null;
        }
    }

    private CoopData loadCoopData(ConfigurationSection coopSection) {
        ArrayList<UUID> coopPlayers = new ArrayList<UUID>();
        HashMap<UUID, Date> joinDates = new HashMap<UUID, Date>();
        HashMap<UUID, CoopPermission> permissions = new HashMap<UUID, CoopPermission>();
        if (coopSection != null) {
            for (String coopPlayer : coopSection.getKeys(false)) {
                UUID coopPlayerUUID = UUID.fromString(coopPlayer);
                coopPlayers.add(coopPlayerUUID);
                Date joinDate = NClaim.deserializeDate(coopSection.getString(coopPlayerUUID + ".joined_at"));
                joinDates.put(coopPlayerUUID, joinDate);
                CoopPermission permission = this.loadCoopPermissions(coopSection.getConfigurationSection(coopPlayerUUID + ".permissions"));
                permissions.put(coopPlayerUUID, permission);
            }
        }
        return new CoopData(coopPlayers, joinDates, permissions);
    }

    private CoopPermission loadCoopPermissions(ConfigurationSection permissionSection) {
        CoopPermission permission = new CoopPermission();
        if (permissionSection != null) {
            for (String permissionName : permissionSection.getKeys(false)) {
                try {
                    Permission perm = Permission.valueOf(permissionName);
                    permission.setEnabled(perm, permissionSection.getBoolean(permissionName));
                }
                catch (IllegalArgumentException e) {
                    Util.log("&cInvalid permission: " + permissionName);
                }
            }
        }
        return permission;
    }

    private ClaimSetting loadClaimSettings(ConfigurationSection settingSection) {
        ClaimSetting settings = new ClaimSetting();
        if (settingSection != null) {
            for (String settingName : settingSection.getKeys(false)) {
                try {
                    Setting setting = Setting.valueOf(settingName.toUpperCase(Locale.ENGLISH).replace("-", "_"));
                    settings.set(setting, settingSection.getBoolean(settingName));
                }
                catch (IllegalArgumentException e) {
                    Util.log("&cInvalid setting: " + settingName);
                }
            }
        }
        return settings;
    }

    private void saveClaim(FileConfiguration config, Claim claim) {
        String ns = "chunks_claimed." + claim.getClaimId();
        config.set(ns + ".created_at", (Object)NClaim.serializeDate(claim.getCreatedAt()));
        config.set(ns + ".expired_at", (Object)NClaim.serializeDate(claim.getExpiredAt()));
        config.set(ns + ".owner", (Object)claim.getOwner().toString());
        config.set(ns + ".bedrock_location", (Object)NClaim.serializeLocation(claim.getBedrockLocation()));
        config.set(ns + ".lands", claim.getLands());
        config.set(ns + ".value", (Object)claim.getClaimValue());
        for (UUID coopPlayerUUID : claim.getCoopPlayers()) {
            String coopPath = ns + ".coops." + coopPlayerUUID;
            config.set(coopPath + ".joined_at", (Object)NClaim.serializeDate(claim.getCoopPlayerJoinDate().get(coopPlayerUUID)));
            CoopPermission coopPermission = claim.getCoopPermissions().getOrDefault(coopPlayerUUID, new CoopPermission());
            for (Permission permission : Permission.values()) {
                config.set(coopPath + ".permissions." + (Object)((Object)permission), (Object)coopPermission.isEnabled(permission));
            }
        }
        for (Setting setting : Setting.values()) {
            config.set(ns + ".settings." + (Object)((Object)setting), (Object)claim.getSettings().isEnabled(setting));
        }
    }

    @Generated
    public ClaimStorageManager(NClaim plugin) {
        this.plugin = plugin;
    }
}

