/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.User;
import nesoi.aysihuniks.nclaim.ui.claim.ClaimListMenu;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminDashboardMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;

public class ClaimMainMenu
extends BaseMenu {
    public ClaimMainMenu(Player player) {
        super("menu.main_menu");
        this.setupMenu(player);
        this.displayTo(player);
    }

    private void setupMenu(Player player) {
        this.createInventory(MenuType.CHEST_3_ROWS, this.getString("title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addBuyClaimButton();
        this.addManageClaimsButton();
        if (player.hasPermission("nclaim.admin")) {
            this.addAdminButton();
        }
    }

    private void addBuyClaimButton() {
        this.addButton(new Button(){
            final String buttonPath = "buy_claim";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{11});
            }

            @Override
            public ItemStack getItem() {
                List lore = ClaimMainMenu.this.getStringList("buy_claim.lore");
                lore.replaceAll(l -> l.replace("{price}", String.valueOf(NClaim.inst().getNconfig().getClaimBuyPrice())));
                return ItemCreator.of(Material.EMERALD).name(ClaimMainMenu.this.getString("buy_claim.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (clickType == ClickType.LEFT) {
                    ClaimMainMenu.this.handleBuyClaimClick(player);
                } else if (clickType == ClickType.RIGHT) {
                    NClaim.inst().getClaimVisualizerService().showClaimBorders(player);
                }
            }
        });
    }

    private void handleBuyClaimClick(Player player) {
        Consumer<String> onFinish = result -> {
            if ("confirmed".equals(result)) {
                player.closeInventory();
                NClaim.inst().getClaimService().buyNewClaim(player);
            } else if ("declined".equals(result)) {
                new ClaimMainMenu(player);
            }
        };
        new ConfirmMenu(player, this.langManager.getString("menu.confirm_menu.buy_claim.display_name"), this.langManager.getStringList("menu.confirm_menu.buy_claim.lore").stream().map(s -> s.replace("{price}", String.valueOf(NClaim.inst().getNconfig().getClaimBuyPrice()))).collect(Collectors.toList()), onFinish);
    }

    private void addManageClaimsButton() {
        this.addButton(new Button(){
            final String buttonPath = "manage_claims";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{15});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CHEST).name(ClaimMainMenu.this.getString("manage_claims.display_name")).lore(ClaimMainMenu.this.getStringList("manage_claims.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                ClaimMainMenu.this.handleManageClaimsClick(player);
            }
        });
    }

    private void handleManageClaimsClick(Player player) {
        User user = User.getUser(player.getUniqueId());
        if (!user.getPlayerClaims().isEmpty() || !user.getCoopClaims().isEmpty()) {
            new ClaimListMenu(player, 0);
        } else {
            player.closeInventory();
            player.sendMessage(this.langManager.getString("claim.not_found"));
            MessageType.WARN.playSound(player);
        }
    }

    private void addAdminButton() {
        this.addButton(new Button(){
            final String buttonPath = "admin";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMMAND_BLOCK).name(ClaimMainMenu.this.getString("admin.display_name")).lore(ClaimMainMenu.this.getStringList("admin.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new AdminDashboardMenu(player);
            }
        });
    }
}

