/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.admin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.integrations.AnvilManager;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.ClaimSetting;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminDashboardMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;

public class AdminAllClaimMenu
extends BaseMenu {
    private static final int CLAIMS_PER_PAGE = 28;
    private static final int[] CLAIM_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43, 46, 47, 48, 49, 50, 51, 52, 19, 20, 21, 22, 23, 24, 25};
    private final OfflinePlayer target;
    private final boolean sortByNewest;
    private final int page;
    private final List<Claim> selectedClaims;

    public AdminAllClaimMenu(Player player, OfflinePlayer target, boolean sortByNewest, int page, List<Claim> selectedClaims) {
        super("menu.admin.all_claims_menu");
        this.target = target;
        this.sortByNewest = sortByNewest;
        this.page = page;
        this.selectedClaims = new ArrayList<Claim>(selectedClaims);
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addNavigationButton();
        this.addSortButton();
        this.addSearchButton();
        this.addResetButton();
        this.addDeleteButton();
        this.addClaimButtons();
        if (this.hasNextPage()) {
            this.addNextPageButton();
        }
    }

    private void addNavigationButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                String navPath = AdminAllClaimMenu.this.page == 0 ? "menu.back" : "menu.previous_page";
                return ItemCreator.of(AdminAllClaimMenu.this.page == 0 ? Material.OAK_DOOR : Material.FEATHER).name(AdminAllClaimMenu.this.langManager.getString(navPath + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (AdminAllClaimMenu.this.page == 0) {
                    new AdminDashboardMenu(player);
                } else {
                    new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page - 1, AdminAllClaimMenu.this.selectedClaims);
                }
            }
        });
    }

    private void addSortButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{11});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(AdminAllClaimMenu.this.getStringList("sort_by_date.lore"));
                lore.replaceAll(s -> s.replace("{newest_status}", AdminAllClaimMenu.this.sortByNewest ? "&eNewest First" : "&7Newest First").replace("{oldest_status}", !AdminAllClaimMenu.this.sortByNewest ? "&eOldest First" : "&7Oldest First"));
                return ItemCreator.of(Material.GOLD_BLOCK).name(AdminAllClaimMenu.this.getString("sort_by_date.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, !AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page, AdminAllClaimMenu.this.selectedClaims);
            }
        });
    }

    private void addSearchButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.NETHER_STAR).name(AdminAllClaimMenu.this.getString("search_player.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                AdminAllClaimMenu.this.handleSearch(player);
            }
        });
    }

    private void addResetButton() {
        if (this.target != null || this.page > 0 || !this.selectedClaims.isEmpty()) {
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{14});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.BOOK).name(AdminAllClaimMenu.this.getString("reset_settings.display_name")).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    new AdminAllClaimMenu(player, null, true, 0, new ArrayList<Claim>());
                }
            });
        }
    }

    private void addDeleteButton() {
        if (!this.selectedClaims.isEmpty()) {
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{15});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.BARRIER).name(AdminAllClaimMenu.this.getString("delete_selected.display_name")).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    AdminAllClaimMenu.this.selectedClaims.forEach(claim -> claim.remove(RemoveCause.REMOVED_BY_ADMIN));
                    AdminAllClaimMenu.this.selectedClaims.clear();
                    MessageType.CONFIRM.playSound(player);
                    new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page, AdminAllClaimMenu.this.selectedClaims);
                }
            });
        }
    }

    private void addNextPageButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name(AdminAllClaimMenu.this.langManager.getString("menu.next_page.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new AdminAllClaimMenu(player, AdminAllClaimMenu.this.target, AdminAllClaimMenu.this.sortByNewest, AdminAllClaimMenu.this.page + 1, AdminAllClaimMenu.this.selectedClaims);
            }
        });
    }

    private void addClaimButtons() {
        List<Claim> filteredClaims = this.getFilteredClaims();
        int startIndex = this.page * 28;
        int endIndex = Math.min(startIndex + 28, filteredClaims.size());
        for (int i = startIndex; i < endIndex; ++i) {
            this.addClaimButton(filteredClaims.get(i), i - startIndex);
        }
    }

    private List<Claim> getFilteredClaims() {
        return Claim.getClaims().stream().filter(claim -> claim != null && claim.getClaimId() != null).collect(Collectors.toMap(Claim::getClaimId, claim -> claim, (existing, replacement) -> existing)).values().stream().filter(claim -> this.target == null || claim.getOwner().equals(this.target.getUniqueId())).sorted((c1, c2) -> this.sortByNewest ? Long.compare(c2.getCreatedAt().getTime(), c1.getCreatedAt().getTime()) : Long.compare(c1.getCreatedAt().getTime(), c2.getCreatedAt().getTime())).collect(Collectors.toList());
    }

    private void addClaimButton(final Claim claim, final int index) {
        final Chunk chunk = claim.getChunk();
        final OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)claim.getOwner());
        ClaimSetting settings = claim.getSettings();
        final int enabledSettings = (int)Arrays.stream(Setting.values()).filter(settings::isEnabled).count();
        final int disabledSettings = Setting.values().length - enabledSettings;
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{CLAIM_SLOTS[index]});
            }

            @Override
            public ItemStack getItem() {
                String section = AdminAllClaimMenu.this.selectedClaims.contains(claim) ? "claim_items.selected" : "claim_items.unselected";
                ArrayList<String> lore = new ArrayList<String>(AdminAllClaimMenu.this.getStringList(section + ".lore"));
                lore.replaceAll(s -> s.replace("{created_at}", NClaim.serializeDate(claim.getCreatedAt())).replace("{world}", chunk.getWorld().getName()).replace("{coordinates}", NClaim.getCoordinates(chunk)).replace("{land_size}", String.valueOf(claim.getLands().size())).replace("{coop_count}", String.valueOf(claim.getCoopPlayers().size())).replace("{yes}", String.valueOf(enabledSettings)).replace("{no}", String.valueOf(disabledSettings)));
                return ItemCreator.of(AdminAllClaimMenu.this.selectedClaims.contains(claim) ? Material.YELLOW_STAINED_GLASS_PANE : Material.WHITE_STAINED_GLASS_PANE).name(AdminAllClaimMenu.this.getString(section + ".display_name").replace("{owner}", owner.getName() != null ? owner.getName() : "Unknown")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                AdminAllClaimMenu.this.handleClaimClick(player, claim, clickType);
            }
        });
    }

    private void handleClaimClick(Player player, Claim claim, ClickType clickType) {
        if (clickType == ClickType.RIGHT) {
            if (this.selectedClaims.contains(claim)) {
                this.selectedClaims.remove(claim);
                MessageType.MENU_DESELECT.playSound(player);
            } else {
                this.selectedClaims.add(claim);
                MessageType.MENU_SELECT.playSound(player);
            }
            new AdminAllClaimMenu(player, this.target, this.sortByNewest, this.page, this.selectedClaims);
        } else if (clickType == ClickType.LEFT) {
            new AdminClaimManagementMenu(player, claim);
        } else if (clickType == ClickType.SHIFT_LEFT) {
            player.closeInventory();
            this.teleportToClaimSafely(player, claim);
        }
    }

    private void handleSearch(Player player) {
        MessageType.SEARCH_OPEN.playSound(player);
        new AnvilManager(NClaim.inst(), player, "Enter a player name", text -> {
            if (text == null || text.isEmpty()) {
                player.sendMessage(this.langManager.getString("command.enter_a_player"));
                MessageType.FAIL.playSound(player);
                player.closeInventory();
                return;
            }
            Player onlinePlayer = Bukkit.getPlayerExact((String)text);
            if (onlinePlayer != null) {
                MessageType.FAIL.playSound(player);
                new AdminAllClaimMenu(player, (OfflinePlayer)onlinePlayer, this.sortByNewest, 0, this.selectedClaims);
                return;
            }
            OfflinePlayer searchedPlayer = Arrays.stream(Bukkit.getOfflinePlayers()).filter(op -> op.getName() != null && op.getName().equalsIgnoreCase((String)text)).findFirst().orElse(null);
            new AdminAllClaimMenu(player, searchedPlayer, this.sortByNewest, 0, this.selectedClaims);
        });
    }

    private void teleportToClaimSafely(Player player, Claim claim) {
        Location bedrockLoc = claim.getBedrockLocation();
        World world = bedrockLoc.getWorld();
        if (world == null) {
            return;
        }
        Location safeLoc = new Location(world, bedrockLoc.getX() + 0.5, bedrockLoc.getY() + 1.0, bedrockLoc.getZ() + 0.5);
        while (safeLoc.getY() < (double)world.getMaxHeight() && !safeLoc.getBlock().getType().isSolid()) {
            safeLoc.setY(safeLoc.getY() + 1.0);
        }
        if (!safeLoc.getBlock().getType().isSolid()) {
            safeLoc.setY((double)(world.getHighestBlockYAt(safeLoc) + 1));
        }
        if (safeLoc.getY() < bedrockLoc.getY()) {
            safeLoc.setY(bedrockLoc.getY() + 1.0);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)NClaim.inst(), () -> {
            MessageType.TELEPORT.playSound(player);
            player.teleport(safeLoc);
        }, 1L);
    }

    private boolean hasNextPage() {
        return this.getFilteredClaims().size() > (this.page + 1) * 28;
    }
}

