/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.coop;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.integrations.AnvilManager;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.CoopPermission;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.claim.coop.CoopPermissionsMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;

public class CoopListMenu
extends BaseMenu {
    @NotNull
    private final Claim claim;
    private final boolean admin;
    private final int page;
    private static final int[] coopSlots = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};

    public CoopListMenu(Player player, @NotNull Claim claim, Boolean admin, int page) {
        super("menu.manage_coop_menu");
        this.claim = claim;
        this.admin = admin;
        this.page = page;
        ArrayList<UUID> coopPlayers = new ArrayList<UUID>(claim.getCoopPlayers());
        int startIndex = page * coopSlots.length;
        int endIndex = Math.min(startIndex + coopSlots.length, coopPlayers.size());
        List<UUID> uuidsToLoad = coopPlayers.subList(startIndex, endIndex);
        NClaim.inst().getHeadManager().preloadTexturesAsync(uuidsToLoad);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)NClaim.inst(), () -> {
            this.setupMenu();
            Bukkit.getScheduler().runTask((Plugin)NClaim.inst(), () -> this.displayTo(player));
        });
    }

    public CoopListMenu(Player player, @NotNull Claim claim, Boolean admin) {
        this(player, claim, admin, 0);
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addNavigationButton();
        this.addAddMemberButton();
        this.addMemberButtons();
        if (this.hasNextPage()) {
            this.addNextPageButton();
        }
    }

    private void addNavigationButton() {
        this.addButton(new Button(){
            final String buttonPath;
            {
                this.buttonPath = CoopListMenu.this.page == 0 ? "menu.back" : "menu.previous_page";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(CoopListMenu.this.page == 0 ? Material.OAK_DOOR : Material.FEATHER).name(CoopListMenu.this.langManager.getString(this.buttonPath + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (CoopListMenu.this.page == 0) {
                    if (!CoopListMenu.this.admin) {
                        new ClaimManagementMenu(player, CoopListMenu.this.claim);
                    } else {
                        new AdminClaimManagementMenu(player, CoopListMenu.this.claim);
                    }
                } else {
                    new CoopListMenu(player, CoopListMenu.this.claim, CoopListMenu.this.admin, CoopListMenu.this.page - 1);
                }
            }
        });
    }

    private void addAddMemberButton() {
        this.addButton(new Button(){
            final String buttonPath = "add_coop";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.NETHER_STAR).name(CoopListMenu.this.getString("add_coop.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                CoopListMenu.this.handleAddMember(player);
            }
        });
    }

    private void handleAddMember(Player player) {
        MessageType.SEARCH_OPEN.playSound(player);
        new AnvilManager(NClaim.inst(), player, "Enter a player name", text -> {
            if (text == null || text.isEmpty()) {
                player.sendMessage(this.langManager.getString("command.enter_a_player"));
                MessageType.FAIL.playSound(player);
                player.closeInventory();
                return;
            }
            if (text.equalsIgnoreCase(player.getName())) {
                player.sendMessage(this.langManager.getString("command.player.cant_add_self"));
                MessageType.FAIL.playSound(player);
                player.closeInventory();
                return;
            }
            Player target = Bukkit.getPlayerExact((String)text);
            if (target == null) {
                player.sendMessage(this.langManager.getString("command.player.not_found").replace("{target}", (CharSequence)text));
                MessageType.FAIL.playSound(player);
                player.closeInventory();
                return;
            }
            this.showAddMemberConfirmation(player, (String)text, target);
        });
    }

    private void showAddMemberConfirmation(Player player, String targetName, Player target) {
        Consumer<String> onFinish = result -> {
            if ("confirmed".equals(result)) {
                player.closeInventory();
                NClaim.inst().getClaimCoopManager().addCoopPlayer(this.claim, player, target);
            } else if ("declined".equals(result)) {
                new CoopListMenu(player, this.claim, this.admin, this.page);
            }
        };
        new ConfirmMenu(player, this.langManager.getString("menu.confirm_menu.add_coop.display_name"), this.langManager.getStringList("menu.confirm_menu.add_coop.lore").stream().map(s -> s.replace("{player}", targetName)).collect(Collectors.toList()), onFinish);
    }

    private void addNextPageButton() {
        this.addButton(new Button(){
            final String buttonPath = "menu.next_page";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name(CoopListMenu.this.langManager.getString("menu.next_page.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new CoopListMenu(player, CoopListMenu.this.claim, CoopListMenu.this.admin, CoopListMenu.this.page + 1);
            }
        });
    }

    private void addMemberButtons() {
        ArrayList<UUID> coopPlayers = new ArrayList<UUID>(this.claim.getCoopPlayers());
        int startIndex = this.page * coopSlots.length;
        int endIndex = Math.min(startIndex + coopSlots.length, coopPlayers.size());
        int i = startIndex;
        int slotIndex = 0;
        while (i < endIndex) {
            this.addMemberButton((UUID)coopPlayers.get(i), slotIndex);
            ++i;
            ++slotIndex;
        }
    }

    private void addMemberButton(UUID coopPlayerUUID, final int slotIndex) {
        final OfflinePlayer coopPlayer = Bukkit.getOfflinePlayer((UUID)coopPlayerUUID);
        final String playerName = coopPlayer.getName() != null ? coopPlayer.getName() : "Unknown";
        String buttonPath = "coop_info";
        CoopPermission cp = this.claim.getCoopPermissions().get(coopPlayerUUID);
        int enabledPerms = (int)Arrays.stream(Permission.values()).filter(cp::isEnabled).count();
        int disabledPerms = Permission.values().length - enabledPerms;
        final ArrayList<String> lore = new ArrayList<String>(this.getStringList("coop_info.lore"));
        lore.replaceAll(s -> s.replace("{date}", NClaim.serializeDate(this.claim.getCoopPlayerJoinDate().get(coopPlayerUUID))));
        if (this.admin) {
            ArrayList<String> adminLore = new ArrayList<String>(this.getStringList("coop_info.admin_lore"));
            adminLore.replaceAll(s -> s.replace("{yes}", String.valueOf(enabledPerms)).replace("{no}", String.valueOf(disabledPerms)));
            lore.addAll(adminLore);
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{coopSlots[slotIndex]});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(NClaim.inst().getHeadManager().createHead(coopPlayer)).name(CoopListMenu.this.getString("coop_info.display_name").replace("{player}", coopPlayer.isOnline() ? "&a" + playerName : "&7" + playerName + " (Offline)")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new CoopPermissionsMenu(player, coopPlayer, CoopListMenu.this.claim, CoopListMenu.this.admin, null);
            }
        });
    }

    private boolean hasNextPage() {
        return (this.page + 1) * coopSlots.length < this.claim.getCoopPlayers().size();
    }
}

