/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.coop;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.PermissionCategory;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.coop.CoopListMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;

public class CoopPermissionsMenu
extends BaseMenu {
    @NotNull
    private final OfflinePlayer coopPlayer;
    @NotNull
    private final Claim claim;
    private final boolean admin;
    @Nullable
    private final PermissionCategory currentCategory;
    private static final int[] CATEGORY_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final int[] PERMISSION_SLOTS = new int[]{28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private static final Map<PermissionCategory, Material> CATEGORY_ICONS;

    public CoopPermissionsMenu(@NotNull Player player, @NotNull OfflinePlayer coopPlayer, @NotNull Claim claim, boolean admin, @Nullable PermissionCategory category) {
        super("menu.permission_menu");
        this.coopPlayer = coopPlayer;
        this.claim = claim;
        this.admin = admin;
        this.currentCategory = category;
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_6_ROWS, this.getString("title").replace("{player}", this.coopPlayer.getName()));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addBackButton();
        this.addPlayerInfoButton();
        this.addCategoryButtons();
        this.addPermissionButtons();
        this.addKickButton();
    }

    private void addBackButton() {
        this.addButton(new Button(){
            final String buttonPath;
            {
                this.buttonPath = CoopPermissionsMenu.this.currentCategory == null ? "menu.back" : "menu.previous_page";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(CoopPermissionsMenu.this.currentCategory == null ? Material.OAK_DOOR : Material.FEATHER).name(CoopPermissionsMenu.this.langManager.getString(this.buttonPath + ".display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                if (CoopPermissionsMenu.this.currentCategory == null) {
                    new CoopListMenu(player, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, 0);
                } else {
                    new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, null);
                }
            }
        });
    }

    private void addPlayerInfoButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                String playerName = CoopPermissionsMenu.this.coopPlayer.isOnline() ? "&a" + CoopPermissionsMenu.this.coopPlayer.getName() : "&7" + CoopPermissionsMenu.this.coopPlayer.getName() + CoopPermissionsMenu.this.getString("offline");
                ArrayList<String> lore = new ArrayList<String>(CoopPermissionsMenu.this.getStringList("player_info.lore"));
                lore.replaceAll(s -> s.replace("{date}", NClaim.serializeDate(CoopPermissionsMenu.this.claim.getCoopPlayerJoinDate().get(CoopPermissionsMenu.this.coopPlayer.getUniqueId()))));
                return ItemCreator.of(NClaim.inst().getHeadManager().createHead(CoopPermissionsMenu.this.coopPlayer)).name(CoopPermissionsMenu.this.getString("player_info.display_name").replace("{player}", playerName)).lore(lore).get();
            }
        });
    }

    private void addCategoryButtons() {
        if (this.currentCategory != null) {
            return;
        }
        int slot = 0;
        for (final PermissionCategory category : PermissionCategory.values()) {
            if (slot >= CATEGORY_SLOTS.length) break;
            final int currentSlot = slot++;
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{CATEGORY_SLOTS[currentSlot]});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of((Material)CATEGORY_ICONS.get((Object)category)).name(CoopPermissionsMenu.this.langManager.getString("menu.permission_menu.categories." + category.name().toLowerCase() + ".display_name")).lore(Arrays.asList("", CoopPermissionsMenu.this.langManager.getString("menu.permission_menu.click_to_view"), CoopPermissionsMenu.this.langManager.getString("menu.permission_menu.right_click_toggle"))).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    if (clickType == ClickType.RIGHT) {
                        MessageType.CONFIRM.playSound(player);
                        NClaim.inst().getClaimCoopManager().toggleCoopPermissionCategory(CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.coopPlayer.getUniqueId(), category);
                    }
                    MessageType.MENU_FORWARD.playSound(player);
                    new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, category);
                }
            });
        }
    }

    private void addPermissionButtons() {
        if (this.currentCategory == null) {
            return;
        }
        Permission[] permissions = this.claim.getCoopPermissions().get(this.coopPlayer.getUniqueId()).getPermissionsByCategory().get((Object)this.currentCategory);
        int slot = 0;
        for (final Permission permission : permissions) {
            if (slot >= PERMISSION_SLOTS.length) break;
            final int currentSlot = slot++;
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{PERMISSION_SLOTS[currentSlot]});
                }

                @Override
                public ItemStack getItem() {
                    boolean isEnabled = CoopPermissionsMenu.this.claim.getCoopPermissions().get(CoopPermissionsMenu.this.coopPlayer.getUniqueId()).isEnabled(permission);
                    return ItemCreator.of(CoopPermissionsMenu.this.getPermissionIcon(permission)).name((isEnabled ? "&a" : "&c") + CoopPermissionsMenu.this.getString("permissions." + permission.name().toLowerCase() + ".display_name")).lore(Arrays.asList("", CoopPermissionsMenu.this.langManager.getString(isEnabled ? "menu.enabled" : "menu.disabled"))).hideFlag(ItemFlag.values()).get();
                }

                @Override
                public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                    NClaim.inst().getClaimCoopManager().toggleCoopPermission(CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.coopPlayer.getUniqueId(), permission);
                    MessageType.CONFIRM.playSound(player);
                    new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, CoopPermissionsMenu.this.currentCategory);
                }
            });
        }
    }

    private Material getPermissionIcon(Permission permission) {
        switch (permission) {
            case BREAK_BLOCKS: {
                return Material.DIAMOND_PICKAXE;
            }
            case BREAK_SPAWNER: 
            case PLACE_SPAWNER: {
                return Material.SPAWNER;
            }
            case PLACE_BLOCKS: {
                return Material.GRASS_BLOCK;
            }
            case USE_CHEST: {
                return Material.CHEST;
            }
            case USE_FURNACE: {
                return Material.FURNACE;
            }
            case USE_BARREL: {
                return Material.BARREL;
            }
            case USE_SHULKER: {
                return Material.SHULKER_BOX;
            }
            case USE_HOPPER: {
                return Material.HOPPER;
            }
            case USE_DISPENSER: {
                return Material.DISPENSER;
            }
            case USE_REDSTONE: {
                return Material.REDSTONE;
            }
            case USE_BUTTONS: {
                return Material.STONE_BUTTON;
            }
            case USE_PRESSURE_PLATES: {
                return Material.STONE_PRESSURE_PLATE;
            }
            case USE_LEVERS: {
                return Material.LEVER;
            }
            case USE_DOORS: {
                return Material.OAK_DOOR;
            }
            case USE_TRAPDOORS: {
                return Material.OAK_TRAPDOOR;
            }
            case USE_GATES: {
                return Material.OAK_FENCE_GATE;
            }
            case USE_CRAFTING: {
                return Material.CRAFTING_TABLE;
            }
            case USE_ENCHANTING: {
                return Material.ENCHANTING_TABLE;
            }
            case USE_ANVIL: {
                return Material.ANVIL;
            }
            case USE_GRINDSTONE: {
                return Material.GRINDSTONE;
            }
            case USE_STONECUTTER: {
                return Material.STONECUTTER;
            }
            case USE_LOOM: {
                return Material.LOOM;
            }
            case USE_SMITHING: {
                return Material.SMITHING_TABLE;
            }
            case USE_CARTOGRAPHY: {
                return Material.CARTOGRAPHY_TABLE;
            }
            case USE_BREWING: {
                return Material.BREWING_STAND;
            }
            case USE_BELL: {
                return Material.BELL;
            }
            case USE_BEACON: {
                return Material.BEACON;
            }
            case USE_JUKEBOX: {
                return Material.JUKEBOX;
            }
            case USE_NOTEBLOCK: {
                return Material.NOTE_BLOCK;
            }
            case USE_CAMPFIRE: {
                return Material.CAMPFIRE;
            }
            case USE_BED: {
                return Material.RED_BED;
            }
            case INTERACT_ARMOR_STAND: {
                return Material.ARMOR_STAND;
            }
            case INTERACT_ITEM_FRAME: {
                return Material.ITEM_FRAME;
            }
            case PLACE_WATER: {
                return Material.WATER_BUCKET;
            }
            case PLACE_LAVA: {
                return Material.LAVA_BUCKET;
            }
            case TAKE_WATER: 
            case TAKE_LAVA: {
                return Material.BUCKET;
            }
            case INTERACT_VILLAGER: {
                return Material.EMERALD;
            }
            case LEASH_MOBS: {
                return Material.LEAD;
            }
            case RIDE_ENTITIES: {
                return Material.SADDLE;
            }
        }
        return Material.BARRIER;
    }

    private void addKickButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BARRIER).name(CoopPermissionsMenu.this.getString("kick.display_name")).lore(CoopPermissionsMenu.this.getStringList("kick.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new ConfirmMenu(player, CoopPermissionsMenu.this.langManager.getString("menu.confirm_menu.kick_coop.display_name"), CoopPermissionsMenu.this.langManager.getStringList("menu.confirm_menu.kick_coop.lore").stream().map(s -> s.replace("{player}", CoopPermissionsMenu.this.coopPlayer.getName())).collect(Collectors.toList()), result -> {
                    if ("confirmed".equals(result)) {
                        player.closeInventory();
                        NClaim.inst().getClaimCoopManager().removeCoopPlayer(CoopPermissionsMenu.this.claim, player, CoopPermissionsMenu.this.coopPlayer.getUniqueId());
                    } else if ("declined".equals(result)) {
                        new CoopPermissionsMenu(player, CoopPermissionsMenu.this.coopPlayer, CoopPermissionsMenu.this.claim, CoopPermissionsMenu.this.admin, CoopPermissionsMenu.this.currentCategory);
                    }
                });
            }
        });
    }

    static {
        HashMap<PermissionCategory, Material> map = new HashMap<PermissionCategory, Material>();
        map.put(PermissionCategory.BLOCKS, Material.GRASS_BLOCK);
        map.put(PermissionCategory.CONTAINERS, Material.CHEST);
        map.put(PermissionCategory.REDSTONE, Material.REDSTONE);
        map.put(PermissionCategory.DOORS, Material.OAK_DOOR);
        map.put(PermissionCategory.WORKSTATIONS, Material.CRAFTING_TABLE);
        map.put(PermissionCategory.INTERACTIONS, Material.LEVER);
        map.put(PermissionCategory.LIQUIDS, Material.WATER_BUCKET);
        map.put(PermissionCategory.ENTITIES, Material.VILLAGER_SPAWN_EGG);
        CATEGORY_ICONS = Collections.unmodifiableMap(map);
    }
}

