/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.Set;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.RemoveCause;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.coop.CoopListMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimSettingsMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.LandExpansionMenu;
import nesoi.aysihuniks.nclaim.ui.claim.management.TimeManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import nesoi.aysihuniks.nclaim.utils.LangManager;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dapi.guimanager.MenuType;

public class ClaimManagementMenu
extends Menu {
    @NotNull
    private final Claim claim;
    private final LangManager langManager;
    private final ConfigurationSection menuSection;
    private Player player;

    public ClaimManagementMenu(Player player, @NotNull Claim claim) {
        this.claim = claim;
        this.player = player;
        this.langManager = NClaim.inst().getLangManager();
        this.menuSection = this.langManager.getSection("menu.claim_menu");
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_3_ROWS, this.langManager.getString(this.menuSection, "title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{11});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRASS_BLOCK).name(ClaimManagementMenu.this.langManager.getString(ClaimManagementMenu.this.menuSection, "manage_chunks.display_name")).lore(ClaimManagementMenu.this.langManager.getStringList(ClaimManagementMenu.this.menuSection, "manage_chunks.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new LandExpansionMenu(player, ClaimManagementMenu.this.claim, false);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name(ClaimManagementMenu.this.langManager.getString(ClaimManagementMenu.this.menuSection, "manage_expiry.display_name")).lore(ClaimManagementMenu.this.langManager.getStringList(ClaimManagementMenu.this.menuSection, "manage_expiry.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new TimeManagementMenu(player, 0, 0, 0, 0, ClaimManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(NClaim.inst().getHeadManager().createHead((OfflinePlayer)ClaimManagementMenu.this.player)).name(ClaimManagementMenu.this.langManager.getString(ClaimManagementMenu.this.menuSection, "manage_members.display_name")).lore(ClaimManagementMenu.this.langManager.getStringList(ClaimManagementMenu.this.menuSection, "manage_members.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new CoopListMenu(player, ClaimManagementMenu.this.claim, false);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.END_CRYSTAL).name(ClaimManagementMenu.this.langManager.getString(ClaimManagementMenu.this.menuSection, "manage_settings.display_name")).lore(ClaimManagementMenu.this.langManager.getStringList(ClaimManagementMenu.this.menuSection, "manage_settings.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_FORWARD.playSound(player);
                new ClaimSettingsMenu(player, ClaimManagementMenu.this.claim, 0);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{15});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.TNT).name(ClaimManagementMenu.this.langManager.getString(ClaimManagementMenu.this.menuSection, "delete.display_name")).lore(ClaimManagementMenu.this.langManager.getStringList(ClaimManagementMenu.this.menuSection, "delete.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new ConfirmMenu(player, ClaimManagementMenu.this.langManager.getString("menu.confirm_menu.delete_claim.display_name"), ClaimManagementMenu.this.langManager.getStringList("menu.confirm_menu.delete_claim.lore"), result -> {
                    if ("confirmed".equals(result)) {
                        ClaimManagementMenu.this.claim.remove(RemoveCause.UNCLAIM);
                        player.closeInventory();
                    } else if ("declined".equals(result)) {
                        new ClaimManagementMenu(player, ClaimManagementMenu.this.claim);
                    }
                });
            }
        });
    }
}

