/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim.management;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.enums.Balance;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.User;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.utils.MessageType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.object.DMaterial;

public class TimeManagementMenu
extends BaseMenu {
    private int days;
    private int hours;
    private int minutes;
    private int timeUnit;
    @NotNull
    private final Claim claim;

    public TimeManagementMenu(@NotNull Player player, int days, int hours, int minutes, int timeUnit, @NotNull Claim claim) {
        super("menu.manage_time_menu");
        this.claim = claim;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.timeUnit = timeUnit;
        this.setupMenu();
        this.displayTo(player);
    }

    private void setupMenu() {
        this.createInventory(MenuType.CHEST_5_ROWS, this.getString("title"));
        this.setBackgroundButton(BackgroundMenu::getButton);
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(TimeManagementMenu.this.getStringList("claim_info.lore"));
                lore.replaceAll(s -> s.replace("{time_left}", NClaim.inst().getClaimExpirationManager().getFormattedTimeLeft(TimeManagementMenu.this.claim)).replace("{expires_at}", NClaim.serializeDate(TimeManagementMenu.this.claim.getExpiredAt())));
                return ItemCreator.of(NClaim.getMaterial(DMaterial.GLOW_ITEM_FRAME, DMaterial.ITEM_FRAME)).name(TimeManagementMenu.this.getString("claim_info.display_name")).lore(lore).get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{31});
            }

            @Override
            public ItemStack getItem() {
                double totalPrice = TimeManagementMenu.this.calculateTotalPrice();
                double tax = totalPrice * NClaim.inst().getNconfig().getTimeExtensionTaxRate();
                double finalPrice = totalPrice + tax;
                ArrayList<String> lore = new ArrayList<String>(TimeManagementMenu.this.getStringList("confirm.lore"));
                lore.replaceAll(s -> s.replace("{price}", String.format("%.2f", finalPrice)).replace("{d}", String.valueOf(TimeManagementMenu.this.days)).replace("{h}", String.valueOf(TimeManagementMenu.this.hours)).replace("{m}", String.valueOf(TimeManagementMenu.this.minutes)));
                return ItemCreator.of(Material.BLUE_ICE).name(TimeManagementMenu.this.getString("confirm.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (TimeManagementMenu.this.days == 0 && TimeManagementMenu.this.hours == 0 && TimeManagementMenu.this.minutes == 0) {
                    player.sendMessage(TimeManagementMenu.this.langManager.getString("error.no_time_selected"));
                    MessageType.FAIL.playSound(player);
                    return;
                }
                double totalPrice = TimeManagementMenu.this.calculateTotalPrice();
                double tax = totalPrice * NClaim.inst().getNconfig().getTimeExtensionTaxRate();
                double finalPrice = totalPrice + tax;
                if (NClaim.inst().getBalanceSystem() == Balance.PLAYERDATA) {
                    User user = User.getUser(player.getUniqueId());
                    if (user == null) {
                        player.sendMessage(TimeManagementMenu.this.langManager.getString("command.player_data_not_found"));
                        MessageType.FAIL.playSound(player);
                        return;
                    }
                    if (user.getBalance() < finalPrice) {
                        player.sendMessage(TimeManagementMenu.this.langManager.getString("command.balance.not_enough"));
                        MessageType.FAIL.playSound(player);
                        return;
                    }
                    user.addBalance(-finalPrice);
                } else {
                    if (NClaim.inst().getEconomy().getBalance((OfflinePlayer)player) < finalPrice) {
                        player.sendMessage(TimeManagementMenu.this.langManager.getString("command.balance.not_enough"));
                        MessageType.FAIL.playSound(player);
                        return;
                    }
                    NClaim.inst().getEconomy().withdrawPlayer((OfflinePlayer)player, finalPrice);
                }
                NClaim.inst().getClaimExpirationManager().extendClaimExpiration(TimeManagementMenu.this.claim, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes);
                player.sendMessage(TimeManagementMenu.this.langManager.getString("command.expiration_extended").replace("{d}", String.valueOf(TimeManagementMenu.this.days)).replace("{h}", String.valueOf(TimeManagementMenu.this.hours)).replace("{m}", String.valueOf(TimeManagementMenu.this.minutes)).replace("{price}", String.format("%.2f", finalPrice)));
                MessageType.CONFIRM.playSound(player);
                player.closeInventory();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{10});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.OAK_DOOR).name(TimeManagementMenu.this.langManager.getString("menu.back.display_name")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                MessageType.MENU_BACK.playSound(player);
                new ClaimManagementMenu(player, TimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                ArrayList<String> lore = new ArrayList<String>(TimeManagementMenu.this.getStringList("select_time_unit.lore"));
                lore.replaceAll(s -> s.replace("{days_status}", TimeManagementMenu.this.timeUnit == 0 ? "&eDays" : "&7Days").replace("{hours_status}", TimeManagementMenu.this.timeUnit == 1 ? "&eHours" : "&7Hours").replace("{minutes_status}", TimeManagementMenu.this.timeUnit == 2 ? "&eMinutes" : "&7Minutes"));
                return ItemCreator.of(Material.CHAIN).name(TimeManagementMenu.this.getString("select_time_unit.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.timeUnit = (TimeManagementMenu.this.timeUnit + 1) % 3;
                MessageType.MENU_REFRESH.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim);
            }
        });
        this.addTimeButtons();
    }

    private double calculateTotalPrice() {
        return (double)this.days * NClaim.inst().getNconfig().getTimeExtensionPricePerDay() + (double)this.hours * NClaim.inst().getNconfig().getTimeExtensionPricePerHour() + (double)this.minutes * NClaim.inst().getNconfig().getTimeExtensionPricePerMinute();
    }

    private void addTimeButtons() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{28});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.LIME_CONCRETE).name(TimeManagementMenu.this.getString("add_one.display_name").replace("{unit}", TimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.adjustTime(1);
                MessageType.VALUE_INCREASE.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{29});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GREEN_CONCRETE).name(TimeManagementMenu.this.getString("add_six.display_name").replace("{unit}", TimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.adjustTime(6);
                MessageType.VALUE_INCREASE.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{33});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PINK_CONCRETE).name(TimeManagementMenu.this.getString("subtract_one.display_name").replace("{unit}", TimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.adjustTime(-1);
                MessageType.VALUE_DECREASE.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{34});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.RED_CONCRETE).name(TimeManagementMenu.this.getString("subtract_six.display_name").replace("{unit}", TimeManagementMenu.this.getTimeUnitString())).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                TimeManagementMenu.this.adjustTime(-6);
                MessageType.VALUE_DECREASE.playSound(player);
                new TimeManagementMenu(player, TimeManagementMenu.this.days, TimeManagementMenu.this.hours, TimeManagementMenu.this.minutes, TimeManagementMenu.this.timeUnit, TimeManagementMenu.this.claim);
            }
        });
    }

    private String getTimeUnitString() {
        switch (this.timeUnit) {
            case 1: {
                return "Hours";
            }
            case 2: {
                return "Minutes";
            }
        }
        return "Days";
    }

    private void adjustTime(int amount) {
        switch (this.timeUnit) {
            case 0: {
                this.days = Math.max(0, this.days + amount);
                break;
            }
            case 1: {
                this.hours = Math.max(0, this.hours + amount);
                break;
            }
            case 2: {
                this.minutes = Math.max(0, this.minutes + amount);
            }
        }
    }
}

