/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import nesoi.aysihuniks.libs.morepaperlib.morepaperlib.MorePaperLib;
import nesoi.aysihuniks.libs.nbtapi.NBT;
import nesoi.aysihuniks.nclaim.Config;
import nesoi.aysihuniks.nclaim.commands.AllCommandExecutor;
import nesoi.aysihuniks.nclaim.database.DatabaseManager;
import nesoi.aysihuniks.nclaim.database.MySQLManager;
import nesoi.aysihuniks.nclaim.database.SQLiteManager;
import nesoi.aysihuniks.nclaim.enums.Balance;
import nesoi.aysihuniks.nclaim.enums.HoloEnum;
import nesoi.aysihuniks.nclaim.hologram.HologramManager;
import nesoi.aysihuniks.nclaim.integrations.Expansion;
import nesoi.aysihuniks.nclaim.integrations.GeikFarmer;
import nesoi.aysihuniks.nclaim.integrations.Metrics;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.model.User;
import nesoi.aysihuniks.nclaim.model.UserManager;
import nesoi.aysihuniks.nclaim.service.ClaimBlockManager;
import nesoi.aysihuniks.nclaim.service.ClaimCoopManager;
import nesoi.aysihuniks.nclaim.service.ClaimExpirationManager;
import nesoi.aysihuniks.nclaim.service.ClaimLevelManager;
import nesoi.aysihuniks.nclaim.service.ClaimManager;
import nesoi.aysihuniks.nclaim.service.ClaimService;
import nesoi.aysihuniks.nclaim.service.ClaimSettingsManager;
import nesoi.aysihuniks.nclaim.service.ClaimStorageManager;
import nesoi.aysihuniks.nclaim.service.ClaimVisualizerService;
import nesoi.aysihuniks.nclaim.utils.ConfigManager;
import nesoi.aysihuniks.nclaim.utils.GuiLangManager;
import nesoi.aysihuniks.nclaim.utils.HeadManager;
import nesoi.aysihuniks.nclaim.utils.LangManager;
import nesoi.aysihuniks.nclaim.utils.UpdateChecker;
import nesoi.aysihuniks.nclaim.utils.Wrapper;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.object.DMaterial;
import org.nandayo.dapi.object.DParticle;
import org.nandayo.dapi.object.DSound;

public final class NClaim
extends JavaPlugin {
    private static NClaim instance;
    private Wrapper wrapper;
    private ClaimService claimService;
    private ClaimStorageManager claimStorageManager;
    private ClaimExpirationManager claimExpirationManager;
    private ClaimCoopManager claimCoopManager;
    private ClaimBlockManager claimBlockManager;
    private GuiLangManager guiLangManager;
    private HologramManager hologramManager;
    private ClaimVisualizerService claimVisualizerService;
    private ClaimSettingsManager claimSettingsManager;
    private ClaimLevelManager blockValueManager;
    private HeadManager headManager;
    private MorePaperLib morePaperLib;
    private MySQLManager mySQLManager;
    private SQLiteManager sqLiteManager;
    private DatabaseManager databaseManager;
    private static Economy econ;
    private LangManager langManager;
    private ConfigManager configManager;
    private Config nconfig;
    private Balance balanceSystem;
    private static Economy economy;
    private DAPI dapi;
    private BukkitTask autoSaveTask;
    private boolean worldGuardEnabled;

    public static NClaim inst() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.initializeDAPI();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.nconfig = new Config(this).load().updateConfig();
        this.configManager = new ConfigManager(this.nconfig.get());
        this.initializeManagers();
        this.setupDatabase();
        this.loadConfigurations();
        this.registerEventHandlers();
        this.registerCommands();
        this.setupIntegrations();
        if (!NBT.preloadApi()) {
            Util.log("&cNBT-API wasn't initialized properly, disabling the plugin");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        this.initializeHologramManager();
        this.setupHeadManager();
        this.startTasks();
        this.loadData();
        this.setupMetrics();
    }

    private void initializeDAPI() {
        this.dapi = new DAPI((Plugin)this);
        this.dapi.registerMenuListener();
        this.setupHexColors();
    }

    private void loadConfigurations() {
        File blocksFile = new File(this.getDataFolder(), "block_levels.yml");
        if (!blocksFile.exists()) {
            this.saveResource("block_levels.yml", false);
        }
        this.blockValueManager.loadBlockValues();
    }

    public void reloadPlugin() {
        String oldDatabaseType;
        this.stopTasks();
        String string = oldDatabaseType = this.nconfig.isDatabaseEnabled() ? this.nconfig.getDatabaseType().toLowerCase() : "yaml";
        if (this.nconfig.isDatabaseEnabled() && this.databaseManager != null) {
            for (Claim claim : Claim.claims) {
                try {
                    this.databaseManager.saveClaim(claim);
                }
                catch (Exception e) {
                    Util.log("&cError saving claim during reload: " + e.getMessage());
                }
            }
        } else if (this.claimStorageManager != null) {
            this.claimStorageManager.saveClaims();
        }
        this.nconfig = new Config(this).load().updateConfig();
        this.configManager = new ConfigManager(this.nconfig.get());
        this.langManager = new LangManager(this, this.configManager.getString("lang_file", "en-US"));
        this.guiLangManager = new GuiLangManager();
        if (this.nconfig.isDatabaseEnabled()) {
            if (this.mySQLManager != null) {
                this.mySQLManager.close();
            }
            if (this.sqLiteManager != null) {
                this.sqLiteManager.close();
            }
            String dbType = this.nconfig.getDatabaseType().toLowerCase();
            try {
                if ("mysql".equals(dbType)) {
                    this.mySQLManager = new MySQLManager(this.nconfig);
                    this.databaseManager = this.mySQLManager;
                    Util.log("&aMySQL connection reestablished.");
                } else if ("sqlite".equals(dbType)) {
                    this.sqLiteManager = new SQLiteManager(this.nconfig);
                    this.databaseManager = this.sqLiteManager;
                    Util.log("&aSQLite connection reestablished.");
                }
            }
            catch (Exception e) {
                Util.log("&cDatabase reconnection failed: " + e.getMessage());
                this.databaseManager = null;
            }
        }
        this.claimSettingsManager = new ClaimSettingsManager(this);
        if (this.nconfig.isDatabaseEnabled() && this.databaseManager != null) {
            try {
                List<Claim> claims = this.databaseManager.loadAllClaims();
                String newDatabaseType = this.nconfig.getDatabaseType().toLowerCase();
                if (claims.isEmpty() && !oldDatabaseType.equals(newDatabaseType) && !Claim.claims.isEmpty()) {
                    Util.log("&eDatabase type changed from " + oldDatabaseType + " to " + newDatabaseType + ", migrating " + Claim.claims.size() + " claims...");
                    for (Claim claim : Claim.claims) {
                        try {
                            this.databaseManager.saveClaim(claim);
                        }
                        catch (Exception e) {
                            Util.log("&cError migrating claim: " + e.getMessage());
                        }
                    }
                    Util.log("&aMigration completed! " + Claim.claims.size() + " claims migrated to " + newDatabaseType);
                } else {
                    Claim.claims.clear();
                    Claim.claims.addAll(claims);
                }
                Util.log("&aReloaded " + Claim.claims.size() + " claims from database.");
            }
            catch (Exception e) {
                Util.log("&cFailed to reload from database: " + e.getMessage());
                if (this.claimStorageManager != null) {
                    this.claimStorageManager.loadClaims();
                }
            }
        } else if (this.claimStorageManager != null) {
            this.claimStorageManager.loadClaims();
        }
        for (Player player : this.getServer().getOnlinePlayers()) {
            try {
                User.saveUser(player.getUniqueId());
                User.loadUser(player.getUniqueId());
            }
            catch (Exception e) {
                Util.log("&cError reloading user " + player.getName() + ": " + e.getMessage());
            }
        }
        this.claimBlockManager = new ClaimBlockManager();
        this.blockValueManager.reloadBlockValues();
        this.hologramManager.forceCleanup();
        this.startTasks();
        Util.log("&aPlugin reload completed!");
    }

    private void stopTasks() {
        if (this.autoSaveTask != null && !this.autoSaveTask.isCancelled()) {
            this.autoSaveTask.cancel();
            this.autoSaveTask = null;
        }
        this.claimExpirationManager.stopExpirationChecker();
    }

    private void initializeManagers() {
        this.wrapper = new Wrapper(this);
        this.morePaperLib = new MorePaperLib((Plugin)this);
        if (NClaim.inst().getServer().getPluginManager().getPlugin("Farmer") != null) {
            GeikFarmer.registerIntegration();
        }
        this.blockValueManager = new ClaimLevelManager(this);
        this.claimService = new ClaimService(this);
        this.claimStorageManager = new ClaimStorageManager(this);
        this.claimExpirationManager = new ClaimExpirationManager(this);
        this.claimCoopManager = new ClaimCoopManager(this);
        this.claimVisualizerService = new ClaimVisualizerService(this);
        this.claimSettingsManager = new ClaimSettingsManager(this);
        this.claimBlockManager = new ClaimBlockManager();
        this.guiLangManager = new GuiLangManager();
        this.langManager = new LangManager(this, this.configManager.getString("lang_file", "en-US"));
    }

    private void initializeHologramManager() {
        if (HoloEnum.getActiveHologram() == null) {
            Util.log("&cNo supported hologram plugin found (DecentHolograms or FancyHolograms). Disabling hologram functionality.");
            return;
        }
        try {
            this.hologramManager = new HologramManager(this);
            Util.log("&aHologramManager initialized successfully!");
        }
        catch (Exception e) {
            Util.log("&cFailed to initialize HologramManager: " + e.getMessage());
        }
        this.hologramManager.cleanupOrphanedHolograms();
    }

    private void registerEventHandlers() {
        this.getServer().getPluginManager().registerEvents((Listener)new UserManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClaimManager(this, this.claimCoopManager), (Plugin)this);
    }

    private void registerCommands() {
        PluginCommand command = this.getCommand("nclaim");
        if (command != null) {
            command.setExecutor((CommandExecutor)new AllCommandExecutor());
            command.setTabCompleter((TabCompleter)new AllCommandExecutor());
        }
    }

    private void setupIntegrations() {
        this.setupHologramPlugin();
        this.setupWorldGuard();
        this.setupPlaceholderAPI();
        this.setupVault();
        this.checkForUpdates();
    }

    private void setupHologramPlugin() {
        if (!HoloEnum.isHologramPluginEnabled()) {
            Util.log("&cYou need to have one of the &rDecentHolograms &cor &rFancyHolograms &cplugins installed!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void setupHeadManager() {
        try {
            this.headManager = new HeadManager();
            Util.log("&aHeadManager initialized successfully!");
        }
        catch (Exception e) {
            Util.log("&cFailed to initialize HeadManager: " + e.getMessage());
        }
    }

    private void setupWorldGuard() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuardEnabled = true;
            Util.log("&aWorldGuard integration enabled successfully!");
        } else {
            this.worldGuardEnabled = false;
            Util.log("&eWorldGuard not found! Region protection features will be disabled.");
        }
    }

    private void setupPlaceholderAPI() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new Expansion(this).register();
        }
    }

    private void setupVault() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            Util.log("&cVault plugin not found! Using PlayerData balance system.");
            this.balanceSystem = Balance.PLAYERDATA;
            return;
        }
        try {
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                Util.log("&cVault plugin found but no economy provider found! Using playerdata balance system.");
                this.balanceSystem = Balance.PLAYERDATA;
                return;
            }
            econ = (Economy)rsp.getProvider();
            this.balanceSystem = Balance.VAULT;
            Util.log("&aSuccessfully hooked into Vault economy!");
        }
        catch (Exception e) {
            Util.log("&cError setting up Vault economy: " + e.getMessage());
            this.balanceSystem = Balance.PLAYERDATA;
        }
    }

    private void setupMetrics() {
        new Metrics((Plugin)this, 24693);
    }

    private void startTasks() {
        this.claimExpirationManager.startExpirationChecker();
        long MINUTES = (long)(this.getNconfig().getAutoSave() * 60) * 20L;
        if (this.autoSaveTask != null && !this.autoSaveTask.isCancelled()) {
            this.autoSaveTask.cancel();
        }
        this.autoSaveTask = new BukkitRunnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                for (Claim claim : Claim.claims) {
                    long claimValue = NClaim.this.blockValueManager.calculateClaimValue(claim);
                    claim.setClaimValue(claimValue);
                }
                if (NClaim.this.nconfig.isDatabaseEnabled() && NClaim.this.databaseManager != null) {
                    try {
                        NClaim.this.databaseManager.saveClaimsBatch(new ArrayList<Claim>(Claim.claims));
                    }
                    catch (Exception e) {
                        Util.log("&cFailed to save claims to database: " + e.getMessage());
                    }
                } else if (NClaim.this.claimStorageManager != null) {
                    NClaim.this.claimStorageManager.saveClaims();
                }
                int claimCount = Claim.claims.size();
                Collection onlinePlayers = NClaim.this.getServer().getOnlinePlayers();
                for (Player player : onlinePlayers) {
                    User.saveUser(player.getUniqueId());
                }
                long duration = System.currentTimeMillis() - startTime;
                Util.log(String.format("&aAuto-save completed! &7(Saved &f%d claims &7and calculated values &7in &f%dms&7)", claimCount, duration));
            }
        }.runTaskTimer((Plugin)this, MINUTES, MINUTES);
    }

    private void loadData() {
        if (this.nconfig.isDatabaseEnabled() && this.databaseManager != null) {
            try {
                List<Claim> claims = this.databaseManager.loadAllClaims();
                Claim.claims.clear();
                Claim.claims.addAll(claims);
                Util.log("&aLoaded " + claims.size() + " claims from database.");
                if (claims.isEmpty()) {
                    this.checkForMigrationOpportunity();
                }
            }
            catch (Exception e) {
                Util.log("&cFailed to load from database: " + e.getMessage());
                this.claimStorageManager.loadClaims();
            }
        } else {
            this.claimStorageManager.loadClaims();
        }
        for (Player player : this.getServer().getOnlinePlayers()) {
            User.loadUser(player.getUniqueId());
        }
    }

    private void setupHexColors() {
        HashMap<String, String> colors = new HashMap<String, String>();
        colors.put("{WHITE}", "<#FFF8E8>");
        colors.put("{DARKGREEN}", "<#0A6847>");
        colors.put("{GREEN}", "<#7ABA78>");
        colors.put("{DARKRED}", "<#6D2323>");
        colors.put("{RED}", "<#cf2525>");
        colors.put("{YELLOW}", "<#FFEC9E>");
        colors.put("{ORANGE}", "<#fa8443>");
        colors.put("{GRAY}", "<#ababab>");
        colors.put("{BROWN}", "<#825B32>");
        colors.put("{PURPLE}", "<#8D77AB>");
        colors.put("{prefix}", "&8[<#fa8443>NClaim&8]&r");
        HexUtil.placeholders.putAll(colors);
        Util.PREFIX = "&8[<#fa8443>NClaim&8]&r ";
    }

    public void onDisable() {
        this.stopTasks();
        if (this.claimStorageManager != null) {
            this.claimStorageManager.saveClaims();
        }
        for (Player player : this.getServer().getOnlinePlayers()) {
            User.saveUser(player.getUniqueId());
        }
        if (this.mySQLManager != null) {
            this.mySQLManager.close();
        }
        if (this.sqLiteManager != null) {
            this.sqLiteManager.close();
        }
        instance = null;
    }

    public static boolean isChunkAdjacent(@NotNull Chunk chunk, @NotNull Chunk thatChunk, int radius) {
        return Math.abs(chunk.getX() - thatChunk.getX()) <= radius && Math.abs(chunk.getZ() - thatChunk.getZ()) <= radius;
    }

    public static Material getMaterial(DMaterial dMaterial, DMaterial def) {
        Material mat = dMaterial.parseMaterial();
        return mat != null ? mat : (def != null ? def.parseMaterial() : Material.AIR);
    }

    public static Particle getParticle(@NotNull DParticle dParticle, @NotNull DParticle def) {
        Particle particle = dParticle.get();
        return particle != null ? particle : def.get();
    }

    public static Sound getSound(@NotNull DSound dSound, @NotNull DSound def) {
        Sound sound = dSound.parseSound();
        return sound != null ? sound : def.parseSound();
    }

    public static String serializeDate(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(date);
    }

    public static Date deserializeDate(String date) {
        if (date == null || date.isEmpty()) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        try {
            return format.parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String serializeLocation(Location location) {
        if (location == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        return world.getName() + "," + x + "," + y + "," + z;
    }

    public static Location deserializeLocation(String location) {
        if (location == null || location.isEmpty()) {
            return null;
        }
        String[] split = location.split(",");
        World world = Bukkit.getWorld((String)split[0]);
        if (world == null) {
            return null;
        }
        double x = Double.parseDouble(split[1]);
        double y = Double.parseDouble(split[2]);
        double z = Double.parseDouble(split[3]);
        return new Location(world, x, y, z);
    }

    public static String getCoordinates(@NotNull Chunk chunk) {
        int centerX = chunk.getX() * 16 + 8;
        int centerZ = chunk.getZ() * 16 + 8;
        return centerX + "," + centerZ;
    }

    public static String serializeChunk(@NotNull Chunk chunk) {
        return chunk.getWorld().getName() + "," + chunk.getX() + "," + chunk.getZ();
    }

    public static Chunk deserializeChunk(@NotNull String chunk) {
        String[] chunkParts = chunk.split(",");
        if (chunkParts.length != 3) {
            return null;
        }
        World world = Bukkit.getWorld((String)chunkParts[0]);
        if (world == null) {
            return null;
        }
        return world.getChunkAt(Integer.parseInt(chunkParts[1]), Integer.parseInt(chunkParts[2]));
    }

    private void setupDatabase() {
        if (this.nconfig.isDatabaseEnabled()) {
            try {
                String dbType = this.nconfig.getDatabaseType().toLowerCase();
                if ("mysql".equals(dbType)) {
                    this.mySQLManager = new MySQLManager(this.nconfig);
                    this.databaseManager = this.mySQLManager;
                    Util.log("&aInitializing MySQL connection...");
                } else if ("sqlite".equals(dbType)) {
                    this.sqLiteManager = new SQLiteManager(this.nconfig);
                    this.databaseManager = this.sqLiteManager;
                    Util.log("&aInitializing SQLite connection...");
                } else {
                    throw new IllegalArgumentException("Unsupported database type: " + dbType);
                }
                int claimCount = this.databaseManager.getClaimCount();
                int userCount = this.databaseManager.getUserCount();
                Util.log("&aFound " + claimCount + " claims and " + userCount + " users in database");
                Util.log("&a" + dbType.toUpperCase() + " connection established successfully!");
            }
            catch (Exception e) {
                this.nconfig.setDatabaseEnabled(false);
                this.nconfig.save();
                Util.log("&cDatabase connection failed (Falling back to YAML): " + e.getMessage());
            }
        }
    }

    private void checkForMigrationOpportunity() {
        boolean hasUserData;
        File claimsFile = new File(this.getDataFolder(), "claims.yml");
        File playersFolder = new File(this.getDataFolder(), "players");
        boolean hasClaimData = claimsFile.exists();
        boolean bl = hasUserData = playersFolder.exists() && playersFolder.listFiles() != null && playersFolder.listFiles().length > 0;
        if (hasClaimData || hasUserData) {
            String dbType = this.nconfig.getDatabaseType().toUpperCase();
            Util.log("&eEmpty " + dbType + " database detected but YAML data exists.");
            Util.log("&eYou can use '/nclaim migrate' command to migrate your data to database.");
        }
    }

    public Economy getEconomy() {
        return econ;
    }

    public void checkForUpdates() {
        if (this.configManager.getBoolean("check_for_updates", true)) {
            int resourceId = 122527;
            new UpdateChecker((Plugin)this, resourceId).getVersion(version -> {
                if (this.getDescription().getVersion().equals(version)) {
                    Util.log("&aPlugin is up-to-date.");
                } else {
                    Util.log("&fThere is a new version update. (&e" + version + "&f)");
                }
            });
        }
    }

    @Generated
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Generated
    public ClaimService getClaimService() {
        return this.claimService;
    }

    @Generated
    public ClaimStorageManager getClaimStorageManager() {
        return this.claimStorageManager;
    }

    @Generated
    public ClaimExpirationManager getClaimExpirationManager() {
        return this.claimExpirationManager;
    }

    @Generated
    public ClaimCoopManager getClaimCoopManager() {
        return this.claimCoopManager;
    }

    @Generated
    public ClaimBlockManager getClaimBlockManager() {
        return this.claimBlockManager;
    }

    @Generated
    public GuiLangManager getGuiLangManager() {
        return this.guiLangManager;
    }

    @Generated
    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    @Generated
    public ClaimVisualizerService getClaimVisualizerService() {
        return this.claimVisualizerService;
    }

    @Generated
    public ClaimSettingsManager getClaimSettingsManager() {
        return this.claimSettingsManager;
    }

    @Generated
    public ClaimLevelManager getBlockValueManager() {
        return this.blockValueManager;
    }

    @Generated
    public HeadManager getHeadManager() {
        return this.headManager;
    }

    @Generated
    public MorePaperLib getMorePaperLib() {
        return this.morePaperLib;
    }

    @Generated
    public MySQLManager getMySQLManager() {
        return this.mySQLManager;
    }

    @Generated
    public SQLiteManager getSqLiteManager() {
        return this.sqLiteManager;
    }

    @Generated
    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    @Generated
    public LangManager getLangManager() {
        return this.langManager;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public Config getNconfig() {
        return this.nconfig;
    }

    @Generated
    public Balance getBalanceSystem() {
        return this.balanceSystem;
    }

    @Generated
    public DAPI getDapi() {
        return this.dapi;
    }

    @Generated
    public BukkitTask getAutoSaveTask() {
        return this.autoSaveTask;
    }

    @Generated
    public boolean isWorldGuardEnabled() {
        return this.worldGuardEnabled;
    }

    @Generated
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Generated
    public void setClaimService(ClaimService claimService) {
        this.claimService = claimService;
    }

    @Generated
    public void setClaimStorageManager(ClaimStorageManager claimStorageManager) {
        this.claimStorageManager = claimStorageManager;
    }

    @Generated
    public void setClaimExpirationManager(ClaimExpirationManager claimExpirationManager) {
        this.claimExpirationManager = claimExpirationManager;
    }

    @Generated
    public void setClaimCoopManager(ClaimCoopManager claimCoopManager) {
        this.claimCoopManager = claimCoopManager;
    }

    @Generated
    public void setClaimBlockManager(ClaimBlockManager claimBlockManager) {
        this.claimBlockManager = claimBlockManager;
    }

    @Generated
    public void setGuiLangManager(GuiLangManager guiLangManager) {
        this.guiLangManager = guiLangManager;
    }

    @Generated
    public void setHologramManager(HologramManager hologramManager) {
        this.hologramManager = hologramManager;
    }

    @Generated
    public void setClaimVisualizerService(ClaimVisualizerService claimVisualizerService) {
        this.claimVisualizerService = claimVisualizerService;
    }

    @Generated
    public void setClaimSettingsManager(ClaimSettingsManager claimSettingsManager) {
        this.claimSettingsManager = claimSettingsManager;
    }

    @Generated
    public void setBlockValueManager(ClaimLevelManager blockValueManager) {
        this.blockValueManager = blockValueManager;
    }

    @Generated
    public void setHeadManager(HeadManager headManager) {
        this.headManager = headManager;
    }

    @Generated
    public void setMorePaperLib(MorePaperLib morePaperLib) {
        this.morePaperLib = morePaperLib;
    }

    @Generated
    public void setMySQLManager(MySQLManager mySQLManager) {
        this.mySQLManager = mySQLManager;
    }

    @Generated
    public void setSqLiteManager(SQLiteManager sqLiteManager) {
        this.sqLiteManager = sqLiteManager;
    }

    @Generated
    public void setDatabaseManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    @Generated
    public void setLangManager(LangManager langManager) {
        this.langManager = langManager;
    }

    @Generated
    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    @Generated
    public void setNconfig(Config nconfig) {
        this.nconfig = nconfig;
    }

    @Generated
    public void setBalanceSystem(Balance balanceSystem) {
        this.balanceSystem = balanceSystem;
    }

    @Generated
    public void setDapi(DAPI dapi) {
        this.dapi = dapi;
    }

    @Generated
    public void setAutoSaveTask(BukkitTask autoSaveTask) {
        this.autoSaveTask = autoSaveTask;
    }

    @Generated
    public void setWorldGuardEnabled(boolean worldGuardEnabled) {
        this.worldGuardEnabled = worldGuardEnabled;
    }

    @Generated
    public static Economy getEcon() {
        return econ;
    }

    static {
        econ = null;
    }
}

