/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.libs.dapi.service;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import nesoi.aysihuniks.libs.dapi.DAPI;
import nesoi.aysihuniks.libs.dapi.message.ChannelBossBarMessage;
import nesoi.aysihuniks.libs.dapi.message.ChannelMessage;
import nesoi.aysihuniks.libs.dapi.message.ChannelTitleMessage;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.libs.dapi.util.ColorizeType;
import nesoi.aysihuniks.libs.dapi.util.Util;
import nesoi.aysihuniks.libs.dapi.util.Validate;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class AdventureService {
    private static Boolean miniMessageSupported;
    private static Object miniMessage;

    public static boolean isMiniMessageSupported() {
        if (miniMessageSupported != null) {
            return miniMessageSupported;
        }
        try {
            Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
            miniMessageSupported = true;
            return miniMessageSupported;
        }
        catch (ClassNotFoundException e) {
            miniMessageSupported = false;
            return miniMessageSupported;
        }
    }

    public static void validateMiniMessage() {
        Validate.validate(AdventureService.isMiniMessageSupported(), "MiniMessage is not supported on this server.");
    }

    public static MiniMessage getMiniMessage() {
        if (miniMessage == null) {
            miniMessage = MiniMessage.miniMessage();
        }
        return (MiniMessage)miniMessage;
    }

    public static void sendMessage(@NotNull CommandSender receiver, @NotNull ChannelMessage message) {
        if (AdventureService.isMiniMessageSupported()) {
            receiver.sendMessage(message.colorize(ColorizeType.MINI_MESSAGE).getMessage());
        } else {
            receiver.sendMessage(message.colorize(ColorizeType.LEGACY).getRawMessage());
        }
    }

    public static void sendActionBar(@NotNull Player player, @NotNull ChannelMessage message) {
        if (AdventureService.isMiniMessageSupported()) {
            player.sendActionBar(message.colorize(ColorizeType.MINI_MESSAGE).getMessage());
        } else {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message.colorize(ColorizeType.LEGACY).getRawMessage()));
        }
    }

    public static void sendTitle(@NotNull Player player, @NotNull ChannelTitleMessage titleMessage, @NotNull ChannelType type) {
        if (AdventureService.isMiniMessageSupported()) {
            player.showTitle(AdventureService.createTitle(titleMessage.colorize(ColorizeType.MINI_MESSAGE), type));
        } else {
            ChannelTitleMessage ttMessage = titleMessage.colorize(ColorizeType.LEGACY);
            player.sendTitle(ttMessage.getRawMessage(), ttMessage.getRawSecondaryMessage(), ttMessage.getFadeInTicks(), ttMessage.getStayTicks(), ttMessage.getFadeOutTicks());
        }
    }

    private static Title createTitle(@NotNull ChannelTitleMessage titleMessage, @NotNull ChannelType type) {
        Component titleComponent = type == ChannelType.TITLE || type == ChannelType.TITLE_AND_SUBTITLE ? titleMessage.getMessage() : Component.empty();
        Component subtitleComponent = type == ChannelType.SUBTITLE || type == ChannelType.TITLE_AND_SUBTITLE ? titleMessage.getSecondaryMessage() : Component.empty();
        return Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Ticks.duration((long)titleMessage.getFadeInTicks()), (Duration)Ticks.duration((long)titleMessage.getStayTicks()), (Duration)Ticks.duration((long)titleMessage.getFadeOutTicks())));
    }

    public static void showBossBar(@NotNull Player player, @NotNull ChannelBossBarMessage bossBarMessage) {
        if (AdventureService.isMiniMessageSupported()) {
            AdventureService.showAdventureBossBar(player, bossBarMessage);
        } else {
            AdventureService.showBukkitBossBar(player, bossBarMessage);
        }
    }

    private static void showAdventureBossBar(@NotNull Player player, @NotNull ChannelBossBarMessage bossBarMessage) {
        ChannelBossBarMessage bbMessage = bossBarMessage.colorize(ColorizeType.MINI_MESSAGE);
        BossBar adventureBossBar = BossBar.bossBar((Component)bbMessage.getMessage(), (float)((float)bbMessage.getProgress()), (BossBar.Color)Parser.parseBarColor(bbMessage.getColor()), (BossBar.Overlay)Parser.parseBarStyle(bbMessage.getStyle()), Parser.parseBarFlags(bbMessage.getFlags()));
        player.showBossBar(adventureBossBar);
        Bukkit.getScheduler().runTaskLater(DAPI.getPlugin(), () -> player.hideBossBar(adventureBossBar), (long)bbMessage.getStayTicks());
    }

    private static void showBukkitBossBar(@NotNull Player player, @NotNull ChannelBossBarMessage bossBarMessage) {
        ChannelBossBarMessage bbMessage = bossBarMessage.colorize(ColorizeType.LEGACY);
        NamespacedKey key = new NamespacedKey("dapi", "boss_bar_" + Util.generateRandomLowerCaseString(8));
        KeyedBossBar bb = Bukkit.createBossBar((NamespacedKey)key, (String)bbMessage.getRawMessage(), (BarColor)bbMessage.getColor(), (BarStyle)bbMessage.getStyle(), (BarFlag[])bbMessage.getFlags());
        bb.addPlayer(player);
        Bukkit.getScheduler().runTaskLater(DAPI.getPlugin(), () -> {
            bb.removePlayer(player);
            Bukkit.removeBossBar((NamespacedKey)key);
        }, (long)bbMessage.getStayTicks());
    }

    public static final class Parser {
        public static BossBar.Color parseBarColor(BarColor color) {
            try {
                return BossBar.Color.valueOf((String)color.name());
            }
            catch (IllegalArgumentException e) {
                return BossBar.Color.BLUE;
            }
        }

        public static BossBar.Overlay parseBarStyle(@NotNull BarStyle style) {
            switch (style) {
                case SEGMENTED_6: {
                    return BossBar.Overlay.NOTCHED_6;
                }
                case SEGMENTED_10: {
                    return BossBar.Overlay.NOTCHED_10;
                }
                case SEGMENTED_12: {
                    return BossBar.Overlay.NOTCHED_12;
                }
                case SEGMENTED_20: {
                    return BossBar.Overlay.NOTCHED_20;
                }
            }
            return BossBar.Overlay.PROGRESS;
        }

        public static Set<BossBar.Flag> parseBarFlags(BarFlag ... flags) {
            HashSet<BossBar.Flag> set = new HashSet<BossBar.Flag>();
            for (BarFlag flag : flags) {
                set.add(Parser.parseBarFlag(flag));
            }
            return set;
        }

        public static BossBar.Flag parseBarFlag(@NotNull BarFlag flag) {
            switch (flag) {
                case PLAY_BOSS_MUSIC: {
                    return BossBar.Flag.PLAY_BOSS_MUSIC;
                }
                case CREATE_FOG: {
                    return BossBar.Flag.CREATE_WORLD_FOG;
                }
            }
            return BossBar.Flag.DARKEN_SCREEN;
        }
    }
}

