/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.service;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import nesoi.aysihuniks.libs.dapi.message.ChannelType;
import nesoi.aysihuniks.libs.dapi.object.DEntityType;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.api.events.ClaimEnterEvent;
import nesoi.aysihuniks.nclaim.api.events.ClaimLeaveEvent;
import nesoi.aysihuniks.nclaim.enums.Permission;
import nesoi.aysihuniks.nclaim.enums.Setting;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.service.ClaimCoopManager;
import nesoi.aysihuniks.nclaim.ui.claim.management.ClaimManagementMenu;
import nesoi.aysihuniks.nclaim.utils.LangManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Shearable;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;

public class ClaimManager
implements Listener {
    private final NClaim plugin;
    private final ClaimCoopManager coopManager;
    private final Map<UUID, Long> messageCooldown = new HashMap<UUID, Long>();

    private void sendCooldownMessage(Player player, String message) {
        long lastMessageTime;
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastMessageTime = this.messageCooldown.getOrDefault(playerUUID, 0L).longValue()) >= 15000L) {
            ChannelType.CHAT.send((CommandSender)player, message);
            this.messageCooldown.put(playerUUID, currentTime);
        }
    }

    private boolean hasClaimBypass(Player player, String specificBypass) {
        return player.hasPermission("nclaim.bypass.*") || player.hasPermission("nclaim.bypass." + specificBypass);
    }

    private boolean isClaimMember(Player player, Claim claim) {
        if (claim == null) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        return !claim.getOwner().equals(uuid) && !claim.getCoopPlayers().contains(uuid);
    }

    private boolean cancelIfNotClaimMember(Player player, Claim claim, Cancellable event) {
        if (claim == null) {
            return false;
        }
        if (this.hasClaimBypass(player, "")) {
            return false;
        }
        if (this.isClaimMember(player, claim)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
            return true;
        }
        return false;
    }

    private void cancelIfNoPermission(Player player, Claim claim, Permission permission, Cancellable event, String bypassType) {
        if (claim == null) {
            return;
        }
        if (this.hasClaimBypass(player, bypassType)) {
            return;
        }
        if (!this.coopManager.hasPermission(player, claim, permission)) {
            event.setCancelled(true);
            this.sendCooldownMessage(player, this.plugin.getLangManager().getString("command.permission_denied"));
        }
    }

    private Player getPlayerFromEntity(Entity entity) {
        Projectile projectile;
        if (entity instanceof Player) {
            return (Player)entity;
        }
        if (entity instanceof Projectile && (projectile = (Projectile)entity).getShooter() instanceof Player) {
            return (Player)projectile.getShooter();
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Chunk fromChunk = event.getFrom().getChunk();
        if (event.getTo() == null) {
            return;
        }
        Chunk toChunk = event.getTo().getChunk();
        if (fromChunk.equals((Object)toChunk)) {
            return;
        }
        if (NClaim.inst().getNconfig().getBlacklistedWorlds().contains(player.getWorld().getName())) {
            return;
        }
        if (NClaim.inst().isWorldGuardEnabled()) {
            RegionManager regions;
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            World world = event.getTo().getWorld();
            if (world != null && (regions = container.get(BukkitAdapter.adapt((World)world))) != null) {
                ApplicableRegionSet regionSet = regions.getApplicableRegions(BukkitAdapter.asBlockVector((Location)event.getTo()));
                for (ProtectedRegion region : regionSet) {
                    if (!NClaim.inst().getNconfig().getBlacklistedRegions().contains(region.getId())) continue;
                    return;
                }
            }
        }
        Claim fromClaim = Claim.getClaim(fromChunk);
        Claim toClaim = Claim.getClaim(toChunk);
        if (fromClaim != null && !fromClaim.equals(toClaim)) {
            ClaimLeaveEvent leaveEvent = new ClaimLeaveEvent(player, fromClaim);
            Bukkit.getPluginManager().callEvent((Event)leaveEvent);
            LangManager.sendSortedMessage(player, this.plugin.getLangManager().getString("move.unclaimed_chunk"));
        }
        if (!(toClaim == null || fromClaim != null && fromClaim.equals(toClaim))) {
            ClaimEnterEvent enterEvent = new ClaimEnterEvent(toClaim, player);
            Bukkit.getPluginManager().callEvent((Event)enterEvent);
            boolean isPvpEnabled = NClaim.inst().getClaimSettingsManager().isSettingEnabled(toClaim, Setting.CLAIM_PVP);
            String pvpStatus = this.plugin.getLangManager().getString(isPvpEnabled ? "move.pvp_enabled" : "move.pvp_disabled");
            OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)toClaim.getOwner());
            LangManager.sendSortedMessage(player, this.plugin.getLangManager().getString("move.claimed_chunk").replace("{owner}", owner.getName() != null ? owner.getName() : "Unknown").replace("{pvp_status}", pvpStatus));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Location explodeLocation = event.getLocation();
        Claim explodeClaim = Claim.getClaim(explodeLocation.getChunk());
        Entity explodingEntity = event.getEntity();
        boolean isTNT = explodingEntity.getType() == NClaim.getEntityType(DEntityType.TNT, DEntityType.PRIMED_TNT) || explodingEntity.getType() == NClaim.getEntityType(DEntityType.MINECART_TNT, DEntityType.TNT_MINECART);
        boolean isCreeper = explodingEntity.getType() == EntityType.CREEPER;
        ArrayList<Block> blocksToRemove = new ArrayList<Block>();
        for (Block block : event.blockList()) {
            Claim blockClaim = Claim.getClaim(block.getChunk());
            if (blockClaim == null || (!isTNT || this.plugin.getClaimSettingsManager().isSettingEnabled(blockClaim, Setting.TNT_DAMAGE)) && (!isCreeper || this.plugin.getClaimSettingsManager().isSettingEnabled(blockClaim, Setting.CREEPER_DAMAGE))) continue;
            blocksToRemove.add(block);
        }
        event.blockList().removeAll(blocksToRemove);
        if (explodeClaim != null && (isTNT && !this.plugin.getClaimSettingsManager().isSettingEnabled(explodeClaim, Setting.TNT_DAMAGE) || isCreeper && !this.plugin.getClaimSettingsManager().isSettingEnabled(explodeClaim, Setting.CREEPER_DAMAGE))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        Player player = event.getPlayer();
        Location location = event.getTo();
        if (location == null) {
            return;
        }
        Chunk chunk = location.getChunk();
        Claim targetClaim = Claim.getClaim(chunk);
        this.cancelIfNotClaimMember(player, targetClaim, (Cancellable)event);
        this.cancelIfNoPermission(player, targetClaim, Permission.USE_ENDER_PEARL, (Cancellable)event, "teleport");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Entity remover = event.getRemover();
        Hanging hanging = event.getEntity();
        if (!(hanging instanceof ItemFrame) && !(hanging instanceof Painting)) {
            return;
        }
        Player player = this.getPlayerFromEntity(remover);
        if (player == null) {
            return;
        }
        Claim claim = Claim.getClaim(hanging.getLocation().getChunk());
        if (this.cancelIfNotClaimMember(player, claim, (Cancellable)event)) {
            return;
        }
        Permission perm = hanging instanceof Painting ? Permission.PLACE_BLOCKS : Permission.INTERACT_ITEM_FRAME;
        this.cancelIfNoPermission(player, claim, perm, (Cancellable)event, "interact");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player damager;
        boolean mobAttackingEnabled;
        Claim claim;
        Player player;
        if (event.getEntity() instanceof Player) {
            Player damaged = (Player)event.getEntity();
            Player damager2 = this.getPlayerFromEntity(event.getDamager());
            if (damager2 != null && !this.hasClaimBypass(damager2, "pvp")) {
                Claim damagedClaim = Claim.getClaim(damaged.getLocation().getChunk());
                Claim damagerClaim = Claim.getClaim(damager2.getLocation().getChunk());
                if (damagedClaim != null && !this.plugin.getClaimSettingsManager().isSettingEnabled(damagedClaim, Setting.CLAIM_PVP) || damagerClaim != null && !this.plugin.getClaimSettingsManager().isSettingEnabled(damagerClaim, Setting.CLAIM_PVP)) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (event.getEntity() instanceof ItemFrame || event.getEntity() instanceof Painting || event.getEntity() instanceof ArmorStand) {
            player = this.getPlayerFromEntity(event.getDamager());
            if (player == null) {
                return;
            }
            claim = Claim.getClaim(event.getEntity().getLocation().getChunk());
            if (this.cancelIfNotClaimMember(player, claim, (Cancellable)event)) {
                return;
            }
            Permission perm = Permission.INTERACT_ITEM_FRAME;
            if (event.getEntity() instanceof Painting) {
                perm = Permission.PLACE_BLOCKS;
            } else if (event.getEntity() instanceof ArmorStand) {
                perm = Permission.INTERACT_ARMOR_STAND;
            }
            this.cancelIfNoPermission(player, claim, perm, (Cancellable)event, "interact");
            return;
        }
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Monster && (claim = Claim.getClaim((player = (Player)event.getEntity()).getLocation().getChunk())) != null && !(mobAttackingEnabled = this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.MOB_ATTACKING)) && this.isClaimMember(player, claim)) {
            event.setCancelled(true);
            return;
        }
        if (event.getEntity() instanceof Monster && event.getDamager() instanceof Player) {
            damager = (Player)event.getDamager();
            claim = Claim.getClaim(event.getEntity().getLocation().getChunk());
            if (claim != null && !this.hasClaimBypass(damager, "mob_attacking") && !(mobAttackingEnabled = this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.MOB_ATTACKING)) && this.isClaimMember(damager, claim)) {
                event.setCancelled(true);
                return;
            }
        }
        if (event.getEntity() instanceof Villager) {
            damager = this.getPlayerFromEntity(event.getDamager());
            if (damager == null) {
                return;
            }
            claim = Claim.getClaim(event.getEntity().getLocation().getChunk());
            if (this.cancelIfNotClaimMember(damager, claim, (Cancellable)event)) {
                return;
            }
            this.cancelIfNoPermission(damager, claim, Permission.INTERACT_VILLAGER, (Cancellable)event, "interact");
            return;
        }
        if (event.getEntity() instanceof LivingEntity) {
            damager = event.getDamager();
            claim = Claim.getClaim(event.getEntity().getLocation().getChunk());
            if (claim != null) {
                if ((damager instanceof TNTPrimed || damager instanceof ExplosiveMinecart) && !this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.TNT_DAMAGE)) {
                    event.setCancelled(true);
                } else if (damager instanceof Creeper && !this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.CREEPER_DAMAGE)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void windCharge(ExplosionPrimeEvent event) {
        Projectile projectile;
        Claim claim;
        EntityType type = event.getEntity().getType();
        if ((type == EntityType.WIND_CHARGE || type == EntityType.BREEZE_WIND_CHARGE) && (claim = Claim.getClaim(event.getEntity().getLocation().getChunk())) != null && event.getEntity() instanceof Projectile && (projectile = (Projectile)event.getEntity()).getShooter() instanceof Player) {
            Player player = (Player)projectile.getShooter();
            if (this.cancelIfNotClaimMember(player, claim, (Cancellable)event)) {
                return;
            }
            this.cancelIfNoPermission(player, claim, Permission.PLACE_BLOCKS, (Cancellable)event, "place");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileHit(ProjectileHitEvent event) {
        Claim claim;
        Projectile projectile = event.getEntity();
        if (!projectile.getType().name().equalsIgnoreCase("WIND_CHARGE")) {
            return;
        }
        Block hitBlock = event.getHitBlock();
        if (hitBlock == null || !(projectile.getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)projectile.getShooter();
        if (this.cancelIfNotClaimMember(player, claim = Claim.getClaim(hitBlock.getChunk()), (Cancellable)event)) {
            return;
        }
        Material type = hitBlock.getType();
        if (Tag.BUTTONS.isTagged((Keyed)type) || Tag.PRESSURE_PLATES.isTagged((Keyed)type) || Tag.DOORS.isTagged((Keyed)type) || Tag.TRAPDOORS.isTagged((Keyed)type) || Tag.FENCE_GATES.isTagged((Keyed)type)) {
            this.cancelIfNoPermission(player, claim, Permission.USE_DOORS, (Cancellable)event, "interact");
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.NATURAL) {
            return;
        }
        Claim claim = Claim.getClaim(event.getLocation().getChunk());
        if (claim == null) {
            return;
        }
        if (event.getEntity() instanceof Monster) {
            if (!this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.MONSTER_SPAWNING)) {
                event.setCancelled(true);
            }
        } else if (!this.plugin.getClaimSettingsManager().isSettingEnabled(claim, Setting.ANIMAL_SPAWNING)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Claim claim = Claim.getClaim(block.getChunk());
        if (claim != null && block.getType() == claim.getClaimBlockType() && block.getLocation().equals((Object)claim.getClaimBlockLocation()) && !player.isSneaking()) {
            event.setCancelled(true);
            return;
        }
        if (this.cancelIfNotClaimMember(player, claim, (Cancellable)event)) {
            return;
        }
        Permission permission = Permission.BREAK_BLOCKS;
        if (block.getType() == Material.SPAWNER) {
            permission = Permission.BREAK_SPAWNER;
        } else if (block.getType() == Material.ITEM_FRAME || block.getType() == Material.GLOW_ITEM_FRAME) {
            permission = Permission.INTERACT_ITEM_FRAME;
        } else if (block.getType() == Material.PAINTING) {
            permission = Permission.PLACE_BLOCKS;
        }
        this.cancelIfNoPermission(player, claim, permission, (Cancellable)event, "break");
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block;
        Claim claim;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.cancelIfNotClaimMember(player, claim = Claim.getClaim((block = event.getBlock()).getChunk()), (Cancellable)event)) {
            return;
        }
        Permission permission = block.getType() == Material.SPAWNER ? Permission.PLACE_SPAWNER : Permission.PLACE_BLOCKS;
        this.cancelIfNoPermission(player, claim, permission, (Cancellable)event, "place");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Claim claim = Claim.getClaim(block.getChunk());
        if (claim == null) {
            return;
        }
        if (block.getType() == claim.getClaimBlockType() && claim.getClaimBlockLocation().equals((Object)block.getLocation())) {
            if (player.hasPermission("nclaim.admin") && player.isSneaking() && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                new ClaimManagementMenu(player, claim, true);
            } else if ((player.hasPermission("nclaim.admin") || this.coopManager.isClaimOwner(claim, player) || this.coopManager.hasPermission(player, claim, Permission.OPEN_CLAIM_MENU)) && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                new ClaimManagementMenu(player, claim, false);
            }
            return;
        }
        if (this.hasClaimBypass(player, "interact")) {
            return;
        }
        if (this.cancelIfNotClaimMember(player, claim, (Cancellable)event)) {
            return;
        }
        Permission permission = this.getInteractPermission(block.getType());
        if (permission == null) {
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Material handType = player.getInventory().getItemInMainHand().getType();
                if (handType == Material.ITEM_FRAME || handType == Material.GLOW_ITEM_FRAME) {
                    permission = Permission.INTERACT_ITEM_FRAME;
                } else if (handType == Material.PAINTING) {
                    permission = Permission.PLACE_BLOCKS;
                } else if (handType == Material.ARMOR_STAND) {
                    permission = Permission.INTERACT_ARMOR_STAND;
                }
            }
            if (permission == null) {
                return;
            }
        }
        this.cancelIfNoPermission(player, claim, permission, (Cancellable)event, "interact");
    }

    private Permission getInteractPermission(Material type) {
        if (type == Material.SPAWNER) {
            return Permission.PLACE_SPAWNER;
        }
        if (type == Material.CHEST) {
            return Permission.USE_CHEST;
        }
        if (type == Material.FURNACE || type == Material.BLAST_FURNACE || type == Material.SMOKER) {
            return Permission.USE_FURNACE;
        }
        if (type == Material.TRAPPED_CHEST) {
            return Permission.USE_TRAPPED_CHEST;
        }
        if (type == Material.SWEET_BERRY_BUSH) {
            return Permission.PLACE_BLOCKS;
        }
        if (type == Material.BARREL) {
            return Permission.USE_BARREL;
        }
        if (Tag.SHULKER_BOXES.isTagged((Keyed)type)) {
            return Permission.USE_SHULKER;
        }
        if (type == Material.HOPPER) {
            return Permission.USE_HOPPER;
        }
        if (type == Material.DISPENSER) {
            return Permission.USE_DISPENSER;
        }
        if (type == Material.DROPPER) {
            return Permission.USE_DROPPER;
        }
        if (type == Material.REPEATER) {
            return Permission.USE_REPEATER;
        }
        if (type == Material.COMPARATOR) {
            return Permission.USE_COMPARATOR;
        }
        if (Tag.BUTTONS.isTagged((Keyed)type)) {
            return Permission.USE_BUTTONS;
        }
        if (Tag.PRESSURE_PLATES.isTagged((Keyed)type)) {
            return Permission.USE_PRESSURE_PLATES;
        }
        if (type == Material.LEVER) {
            return Permission.USE_LEVERS;
        }
        if (Tag.DOORS.isTagged((Keyed)type)) {
            return Permission.USE_DOORS;
        }
        if (Tag.TRAPDOORS.isTagged((Keyed)type)) {
            return Permission.USE_TRAPDOORS;
        }
        if (Tag.FENCE_GATES.isTagged((Keyed)type)) {
            return Permission.USE_GATES;
        }
        if (type == Material.CRAFTING_TABLE) {
            return Permission.USE_CRAFTING;
        }
        if (type == Material.ENCHANTING_TABLE) {
            return Permission.USE_ENCHANTING;
        }
        if (Tag.ANVIL.isTagged((Keyed)type)) {
            return Permission.USE_ANVIL;
        }
        if (type == Material.GRINDSTONE) {
            return Permission.USE_GRINDSTONE;
        }
        if (type == Material.STONECUTTER) {
            return Permission.USE_STONECUTTER;
        }
        if (type == Material.LOOM) {
            return Permission.USE_LOOM;
        }
        if (type == Material.SMITHING_TABLE) {
            return Permission.USE_SMITHING;
        }
        if (type == Material.CARTOGRAPHY_TABLE) {
            return Permission.USE_CARTOGRAPHY;
        }
        if (type == Material.BREWING_STAND) {
            return Permission.USE_BREWING;
        }
        if (type == Material.BELL) {
            return Permission.USE_BELL;
        }
        if (type == Material.BEACON) {
            return Permission.USE_BEACON;
        }
        if (type == Material.JUKEBOX) {
            return Permission.USE_JUKEBOX;
        }
        if (type == Material.NOTE_BLOCK) {
            return Permission.USE_NOTEBLOCK;
        }
        if (type == Material.CAMPFIRE) {
            return Permission.USE_CAMPFIRE;
        }
        if (type == Material.SOUL_CAMPFIRE) {
            return Permission.USE_SOUL_CAMPFIRE;
        }
        if (Tag.BEDS.isTagged((Keyed)type)) {
            return Permission.USE_BED;
        }
        return null;
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity;
        Claim claim;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.cancelIfNotClaimMember(player, claim = Claim.getClaim((entity = event.getRightClicked()).getLocation().getChunk()), (Cancellable)event)) {
            return;
        }
        Permission permission = null;
        if (entity instanceof Villager) {
            permission = Permission.INTERACT_VILLAGER;
        } else if (entity instanceof ItemFrame) {
            permission = Permission.INTERACT_ITEM_FRAME;
        } else if (player.getInventory().getItemInMainHand().getType() == Material.SHEARS && entity instanceof Shearable) {
            permission = Permission.BREAK_BLOCKS;
        }
        if (permission != null) {
            this.cancelIfNoPermission(player, claim, permission, (Cancellable)event, "interact");
        }
    }

    @EventHandler
    public void onArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        ArmorStand armorStand;
        Claim claim;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.cancelIfNotClaimMember(player, claim = Claim.getClaim((armorStand = event.getRightClicked()).getLocation().getChunk()), (Cancellable)event)) {
            return;
        }
        this.cancelIfNoPermission(player, claim, Permission.INTERACT_ARMOR_STAND, (Cancellable)event, "interact");
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent event) {
        Vehicle vehicle;
        Claim claim;
        if (!(event.getEntered() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntered();
        if (this.cancelIfNotClaimMember(player, claim = Claim.getClaim((vehicle = event.getVehicle()).getLocation().getChunk()), (Cancellable)event)) {
            return;
        }
        this.cancelIfNoPermission(player, claim, Permission.RIDE_ENTITIES, (Cancellable)event, "interact");
    }

    @EventHandler
    public void onPlayerLeashEntity(PlayerLeashEntityEvent event) {
        Entity entity;
        Claim claim;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.cancelIfNotClaimMember(player, claim = Claim.getClaim((entity = event.getEntity()).getLocation().getChunk()), (Cancellable)event)) {
            return;
        }
        this.cancelIfNoPermission(player, claim, Permission.LEASH_MOBS, (Cancellable)event, "interact");
    }

    @EventHandler
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Claim claim = Claim.getClaim(block.getChunk());
        if (this.hasClaimBypass(player, "interact")) {
            return;
        }
        if (this.cancelIfNotClaimMember(player, claim, (Cancellable)event)) {
            return;
        }
        Permission permission = null;
        if (event.getBucket() == Material.WATER_BUCKET) {
            permission = Permission.TAKE_WATER;
        } else if (event.getBucket() == Material.LAVA_BUCKET) {
            permission = Permission.TAKE_LAVA;
        }
        if (permission != null) {
            this.cancelIfNoPermission(player, claim, permission, (Cancellable)event, "interact");
        }
    }

    @EventHandler
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Claim claim = Claim.getClaim(block.getChunk());
        if (this.hasClaimBypass(player, "interact")) {
            return;
        }
        if (this.cancelIfNotClaimMember(player, claim, (Cancellable)event)) {
            return;
        }
        Permission permission = null;
        if (event.getBucket() == Material.WATER_BUCKET) {
            permission = Permission.PLACE_WATER;
        } else if (event.getBucket() == Material.LAVA_BUCKET) {
            permission = Permission.PLACE_LAVA;
        }
        if (permission != null) {
            this.cancelIfNoPermission(player, claim, permission, (Cancellable)event, "interact");
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block fromBlock = event.getBlock();
        Block toBlock = event.getToBlock();
        if (fromBlock.getType() != Material.WATER && fromBlock.getType() != Material.LAVA) {
            return;
        }
        Claim fromClaim = Claim.getClaim(fromBlock.getChunk());
        Claim toClaim = Claim.getClaim(toBlock.getChunk());
        if (fromClaim == null && toClaim != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Claim claim;
        Player player;
        if (event.getBlock().getType() == Material.FARMLAND && event.getEntity() instanceof Player && this.cancelIfNotClaimMember(player = (Player)event.getEntity(), claim = Claim.getClaim(event.getBlock().getChunk()), (Cancellable)event)) {
            return;
        }
    }

    @EventHandler
    public void onRedstoneUpdate(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        Claim sourceClaim = Claim.getClaim(block.getChunk());
        for (BlockFace face : BlockFace.values()) {
            Block relative = block.getRelative(face);
            Claim targetClaim = Claim.getClaim(relative.getChunk());
            if (targetClaim == null || sourceClaim == null || targetClaim.getOwner().equals(sourceClaim.getOwner()) || targetClaim.getCoopPlayers().contains(sourceClaim.getOwner())) continue;
            event.setNewCurrent(event.getOldCurrent());
            return;
        }
    }

    @Generated
    public ClaimManager(NClaim plugin, ClaimCoopManager coopManager) {
        this.plugin = plugin;
        this.coopManager = coopManager;
    }
}

