/*
 * Decompiled with CFR 0.152.
 */
package nesoi.aysihuniks.nclaim.ui.claim;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import nesoi.aysihuniks.libs.dapi.guimanager.MenuType;
import nesoi.aysihuniks.libs.dapi.guimanager.button.Button;
import nesoi.aysihuniks.libs.dapi.guimanager.button.SingleSlotButton;
import nesoi.aysihuniks.libs.dapi.util.ItemCreator;
import nesoi.aysihuniks.nclaim.NClaim;
import nesoi.aysihuniks.nclaim.model.Claim;
import nesoi.aysihuniks.nclaim.ui.claim.ClaimListMenu;
import nesoi.aysihuniks.nclaim.ui.claim.admin.AdminAllClaimMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BackgroundMenu;
import nesoi.aysihuniks.nclaim.ui.shared.BaseMenu;
import nesoi.aysihuniks.nclaim.ui.shared.ConfirmMenu;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimMainMenu
extends BaseMenu {
    public ClaimMainMenu(Player player) {
        super("claim_menu");
        this.setupMenu(player);
        this.displayTo(player);
    }

    private void setupMenu(Player player) {
        this.createInventory(MenuType.CHEST_3_ROWS, this.getString("title"));
        this.addBuyClaimButton();
        this.addManageClaimsButton();
        if (player.hasPermission("nclaim.admin")) {
            this.addAdminButton();
        }
    }

    @Override
    public Function<Integer, @Nullable SingleSlotButton> backgroundButtonFunction() {
        return BackgroundMenu::getButton;
    }

    private void addBuyClaimButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{11});
            }

            @Override
            public ItemStack getItem() {
                List lore = ClaimMainMenu.this.getStringList("buy_claim.lore");
                lore.replaceAll(l -> l.replace("{price}", String.valueOf(NClaim.inst().getNconfig().getClaimBuyPrice())));
                return ItemCreator.of(ClaimMainMenu.this.getMaterial("buy_claim")).name(ClaimMainMenu.this.getString("buy_claim.display_name")).lore(lore).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                if (clickType == ClickType.LEFT) {
                    ClaimMainMenu.this.handleBuyClaimClick(player);
                } else if (clickType == ClickType.RIGHT) {
                    NClaim.inst().getClaimVisualizerService().showClaimBorders(player);
                }
            }
        });
    }

    private void handleBuyClaimClick(Player player) {
        Consumer<String> onFinish = result -> {
            if ("confirmed".equals(result)) {
                player.closeInventory();
                NClaim.inst().getClaimService().buyNewClaim(player);
            } else if ("declined".equals(result)) {
                new ClaimMainMenu(player);
            }
        };
        new ConfirmMenu(player, NClaim.inst().getGuiLangManager().getString("confirm_menu", "children.buy_new_claim.display_name"), NClaim.inst().getGuiLangManager().getStringList("confirm_menu", "children.buy_new_claim.lore").stream().map(s -> s.replace("{price}", String.valueOf(NClaim.inst().getNconfig().getClaimBuyPrice()))).collect(Collectors.toList()), onFinish);
    }

    private void addManageClaimsButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{15});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimMainMenu.this.getMaterial("manage_claims")).name(ClaimMainMenu.this.getString("manage_claims.display_name")).lore(ClaimMainMenu.this.getStringList("manage_claims.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new ClaimListMenu(player, 0);
            }
        });
    }

    private void addAdminButton() {
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(ClaimMainMenu.this.getMaterial("admin")).name(ClaimMainMenu.this.getString("admin.display_name")).lore(ClaimMainMenu.this.getStringList("admin.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player player, @NotNull ClickType clickType) {
                new AdminAllClaimMenu(player, null, true, 0, new ArrayList<Claim>());
            }
        });
    }
}

